/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class GCWindowAlgorithm
extends BaseAlgorithm {
    public GCWindowAlgorithm(Strand strand) {
        super(strand, "GC Content (%)", "gc_content");
        this.setScalingFlag(true);
    }

    public void getValues(int start, int end, float[] values) {
        String sequence;
        try {
            sequence = this.getStrand().getSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        float gc_count = 0.0f;
        int i = 0;
        while (i < sequence.length()) {
            char this_char = sequence.charAt(i);
            if (this_char == 'g' || this_char == 'c') {
                gc_count += 1.0f;
            }
            ++i;
        }
        values[0] = gc_count / (float)sequence.length() * 100.0f;
    }

    public int getValueCount() {
        return 1;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(120);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(500);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(24);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 10) {
            return new Integer(window_size / 10);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(100.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(0.0f);
    }

    public Float getAverage() {
        return new Float(this.getStrand().getBases().getAverageGCPercent());
    }
}

