/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import java.io.IOException;
import java.io.Reader;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.StringVector;

public class UserDataAlgorithm
extends BaseAlgorithm {
    private float[][] data = null;
    private float data_max = -9999999.0f;
    private float data_min = 9999999.0f;
    private float average_value = 0.0f;
    private int number_of_values;

    public UserDataAlgorithm(Strand strand, Document document) throws IOException {
        super(strand, "User algorithm from " + document.getName(), "user");
        Reader document_reader = document.getReader();
        LinePushBackReader pushback_reader = new LinePushBackReader(document_reader);
        String first_line = pushback_reader.readLine();
        StringVector tokens = StringVector.getStrings(first_line, " \t");
        if (tokens.size() < 1) {
            throw new ReadFormatException("unknown file type");
        }
        this.number_of_values = tokens.size();
        pushback_reader.pushBack(first_line);
        this.data = new float[strand.getSequenceLength()][tokens.size()];
        this.readData(pushback_reader);
    }

    private void readData(LinePushBackReader pushback_reader) throws IOException {
        String line = null;
        int count = 0;
        while ((line = pushback_reader.readLine()) != null) {
            if (count >= this.getStrand().getSequenceLength()) {
                throw new ReadFormatException("too many values in input file");
            }
            StringVector tokens = StringVector.getStrings(line, " \t");
            if (tokens.size() == this.data[0].length) {
                int i = 0;
                while (i < tokens.size()) {
                    try {
                        float value = Float.valueOf(tokens.elementAt(i)).floatValue();
                        if (value > this.data_max) {
                            this.data_max = value;
                        }
                        if (value < this.data_min) {
                            this.data_min = value;
                        }
                        this.data[count][i] = value;
                        this.average_value += value;
                    }
                    catch (NumberFormatException e) {
                        throw new ReadFormatException("cannot understand this number: " + tokens.elementAt(i) + " - " + e.getMessage());
                    }
                    ++i;
                }
            } else {
                throw new ReadFormatException("line has the wrong number of fields");
            }
            ++count;
        }
        this.average_value /= (float)(this.data[0].length * this.getStrand().getSequenceLength());
    }

    public void getValues(int start, int end, float[] values) {
        int value_count = this.getValueCount();
        int i = 0;
        while (i < value_count) {
            values[i] = 0.0f;
            int base = start;
            while (base <= end) {
                int n = i;
                values[n] = values[n] + this.data[base - 1][i] / (float)(end - start + 1);
                ++base;
            }
            ++i;
        }
    }

    public int getValueCount() {
        return this.number_of_values;
    }

    public Integer getDefaultWindowSize() {
        return new Integer(3);
    }

    public Integer getDefaultMaxWindowSize() {
        return new Integer(100);
    }

    public Integer getDefaultMinWindowSize() {
        return new Integer(1);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 10) {
            return new Integer(window_size / 10);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(this.data_max);
    }

    protected Float getMinimumInternal() {
        return new Float(this.data_min);
    }

    public Float getAverage() {
        return new Float(this.average_value);
    }
}

