/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.sequence;

import java.util.WeakHashMap;
import org.biojava.bio.symbol.IllegalSymbolException;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class Bases {
    public static final int FORWARD = 1;
    public static final int REVERSE = 2;
    public static final int MIN_PRIORITY = -5;
    public static final int MEDIUM_PRIORITY = 0;
    public static final int MAX_PRIORITY = 5;
    public static final char[] letter_index = new char[]{'t', 'c', 'a', 'g', 'n'};
    private byte[] forward_stop_codon_cache = null;
    private byte[] reverse_stop_codon_cache = null;
    private final WeakHashMap[] listener_hash_map_array = new WeakHashMap[11];
    private Sequence embl_sequence;
    private Strand forward_strand;
    private Strand reverse_strand;

    public Bases(Sequence sequence) {
        this.embl_sequence = sequence;
        this.forward_stop_codon_cache = null;
        this.reverse_stop_codon_cache = null;
        this.forward_strand = new Strand(this, 1);
        this.reverse_strand = new Strand(this, 2);
        int i = 0;
        while (i < this.listener_hash_map_array.length) {
            this.listener_hash_map_array[i] = new WeakHashMap();
            ++i;
        }
    }

    public Strand getForwardStrand() {
        return this.forward_strand;
    }

    public Strand getReverseStrand() {
        return this.reverse_strand;
    }

    public int getLength() {
        return this.embl_sequence.length();
    }

    public String toString() {
        return this.embl_sequence.toString();
    }

    public void reverseComplement() throws ReadOnlyException {
        this.forward_stop_codon_cache = null;
        this.reverse_stop_codon_cache = null;
        Strand temp = this.forward_strand;
        this.forward_strand = this.reverse_strand;
        this.reverse_strand = temp;
        String new_sequence = Bases.reverseComplement(this.getSequence().getSubSequence(1, this.getLength()));
        try {
            this.getSequence().setFromString(new_sequence);
        }
        catch (IllegalSymbolException e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        SequenceChangeEvent event = new SequenceChangeEvent(this, 3);
        this.fireSequenceChangeEvent(event);
    }

    public static int getIndexOfBase(char base) {
        switch (base) {
            case 't': 
            case 'u': {
                return 0;
            }
            case 'c': {
                return 1;
            }
            case 'a': {
                return 2;
            }
            case 'g': {
                return 3;
            }
        }
        return 4;
    }

    public Range complementRange(Range range) {
        int real_start = this.getComplementPosition(range.getEnd());
        int real_end = this.getComplementPosition(range.getStart());
        try {
            Range real_range = new Range(real_start, real_end);
            return real_range;
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public int getComplementPosition(int position) {
        return this.getLength() - position + 1;
    }

    public int getRawPosition(int position, int direction) {
        if (direction == 1) {
            return position;
        }
        return this.getComplementPosition(position);
    }

    public AminoAcidSequence getTranslation(Range range, int direction, boolean unknown_is_x) {
        String sub_sequence = this.getSubSequence(range, direction);
        return AminoAcidSequence.getTranslation(sub_sequence, unknown_is_x);
    }

    public int[] getMatchingCodons(Range range, int direction, StringVector query_codons) {
        Range real_range = direction == 1 ? range : this.complementRange(range);
        float at_content = (100.0f - this.getAverageGCPercent()) / 100.0f;
        int array_start_size = (int)((float)range.getCount() * at_content * at_content * (2.0f - at_content) * (float)query_codons.size() / 64.0f);
        if (array_start_size < 20) {
            array_start_size = 20;
        }
        int[] return_positions = new int[array_start_size];
        int current_return_array_index = 0;
        String sequence_string = this.getSequence().getSubSequence(1, this.getLength());
        int range_start_index = real_range.getStart() - 1;
        int range_end_index = real_range.getEnd() - 1;
        if (direction == 1) {
            int i = range_start_index;
            while (i < range_end_index - 2) {
                boolean is_matching_codon;
                if (i >= 0 && i < sequence_string.length() - 2 && (is_matching_codon = this.isMatchingCodon(sequence_string, i, direction, query_codons))) {
                    if (current_return_array_index == return_positions.length) {
                        int[] new_array = new int[return_positions.length * 3 / 2 + 1];
                        System.arraycopy(return_positions, 0, new_array, 0, return_positions.length);
                        return_positions = new_array;
                    }
                    return_positions[current_return_array_index] = i + 1;
                    ++current_return_array_index;
                }
                i += 3;
            }
        } else {
            int i = range_end_index;
            while (i > range_start_index + 2) {
                boolean is_matching_codon;
                if (i >= 2 && i < sequence_string.length() && (is_matching_codon = this.isMatchingCodon(sequence_string, i, direction, query_codons))) {
                    if (current_return_array_index == return_positions.length) {
                        int[] new_array = new int[return_positions.length * 3 / 2 + 1];
                        System.arraycopy(return_positions, 0, new_array, 0, return_positions.length);
                        return_positions = new_array;
                    }
                    return_positions[current_return_array_index] = sequence_string.length() - i;
                    ++current_return_array_index;
                }
                i -= 3;
            }
        }
        return return_positions;
    }

    private boolean isMatchingCodon(String sequence_string, int start_index, int direction, StringVector query_codons) {
        int query_codon_index = 0;
        while (query_codon_index < query_codons.size()) {
            if (this.isMatchingCodon(sequence_string, start_index, direction, query_codons.elementAt(query_codon_index))) {
                return true;
            }
            ++query_codon_index;
        }
        return false;
    }

    private boolean isMatchingCodon(String sequence_string, int start_index, int direction, String query_codon) {
        if (direction == 1) {
            if (query_codon.charAt(0) == sequence_string.charAt(start_index) && query_codon.charAt(1) == sequence_string.charAt(start_index + 1) && query_codon.charAt(2) == sequence_string.charAt(start_index + 2)) {
                return true;
            }
        } else {
            char first_letter = Bases.complement(sequence_string.charAt(start_index));
            char second_letter = Bases.complement(sequence_string.charAt(start_index - 1));
            char third_letter = Bases.complement(sequence_string.charAt(start_index - 2));
            if (query_codon.charAt(0) == first_letter && query_codon.charAt(1) == second_letter && query_codon.charAt(2) == third_letter) {
                return true;
            }
        }
        return false;
    }

    private byte[] getForwardStopCodonCache() {
        if (this.forward_stop_codon_cache == null) {
            this.forward_stop_codon_cache = new byte[this.getLength()];
        }
        return this.forward_stop_codon_cache;
    }

    private byte[] getReverseStopCodonCache() {
        if (this.reverse_stop_codon_cache == null) {
            this.reverse_stop_codon_cache = new byte[this.getLength()];
        }
        return this.reverse_stop_codon_cache;
    }

    public int[] getStopCodons(Range range, int direction) {
        Range real_range = direction == 1 ? range : this.complementRange(range);
        float at_content = (100.0f - this.getAverageGCPercent()) / 100.0f;
        int array_start_size = (int)((float)range.getCount() * at_content * at_content * (2.0f - at_content) * 3.0f / 64.0f);
        if (array_start_size < 20) {
            array_start_size = 20;
        }
        int[] return_positions = new int[array_start_size];
        int current_return_array_index = 0;
        String sequence_string = this.getSequence().getSubSequence(1, this.getLength());
        int range_start_index = real_range.getStart() - 1;
        int range_end_index = real_range.getEnd() - 1;
        byte[] forward_stop_codon_flags = this.getForwardStopCodonCache();
        byte[] reverse_stop_codon_flags = this.getReverseStopCodonCache();
        if (direction == 1) {
            int i = range_start_index;
            while (i < range_end_index - 2) {
                if (i >= 0 && i < sequence_string.length() - 2) {
                    boolean is_stop_codon;
                    if (forward_stop_codon_flags[i] == 0) {
                        if (Bases.isStopCodon(sequence_string, i, direction)) {
                            forward_stop_codon_flags[i] = 2;
                            is_stop_codon = true;
                        } else {
                            forward_stop_codon_flags[i] = 1;
                            is_stop_codon = false;
                        }
                    } else {
                        is_stop_codon = forward_stop_codon_flags[i] == 2;
                    }
                    if (is_stop_codon) {
                        if (current_return_array_index == return_positions.length) {
                            int[] new_array = new int[return_positions.length * 3 / 2 + 1];
                            System.arraycopy(return_positions, 0, new_array, 0, return_positions.length);
                            return_positions = new_array;
                        }
                        return_positions[current_return_array_index] = is_stop_codon ? i + 1 : -(i + 1);
                        ++current_return_array_index;
                    }
                }
                i += 3;
            }
        } else {
            int i = range_end_index;
            while (i > range_start_index + 2) {
                if (i >= 2 && i < sequence_string.length()) {
                    boolean is_stop_codon;
                    if (reverse_stop_codon_flags[i] == 0) {
                        if (Bases.isStopCodon(sequence_string, i, direction)) {
                            reverse_stop_codon_flags[i] = 2;
                            is_stop_codon = true;
                        } else {
                            reverse_stop_codon_flags[i] = 1;
                            is_stop_codon = false;
                        }
                    } else {
                        is_stop_codon = reverse_stop_codon_flags[i] == 2;
                    }
                    if (is_stop_codon) {
                        if (current_return_array_index == return_positions.length) {
                            int[] new_array = new int[return_positions.length * 3 / 2 + 1];
                            System.arraycopy(return_positions, 0, new_array, 0, return_positions.length);
                            return_positions = new_array;
                        }
                        return_positions[current_return_array_index] = is_stop_codon ? sequence_string.length() - i : -(sequence_string.length() - i);
                        ++current_return_array_index;
                    }
                }
                i -= 3;
            }
        }
        return return_positions;
    }

    public char getBaseAt(int position) throws OutOfRangeException {
        if (position > this.getLength()) {
            throw new OutOfRangeException(String.valueOf(position) + " > " + this.getLength());
        }
        if (position < 1) {
            throw new OutOfRangeException(String.valueOf(position) + " < " + 1);
        }
        return this.toString().charAt(position - 1);
    }

    public String getSubSequence(Range range, int direction) {
        int i;
        char[] dummy_bases;
        int dummy_base_count;
        Range real_range = direction == 1 ? range : this.complementRange(range);
        int sub_seq_start_index = real_range.getStart() < 1 ? 1 : real_range.getStart();
        int sub_seq_end_index = real_range.getEnd() > this.getLength() ? this.getLength() : real_range.getEnd();
        String sub_sequence = this.getSequence().getSubSequence(sub_seq_start_index, sub_seq_end_index);
        if (real_range.getStart() < 1) {
            dummy_base_count = 1 - real_range.getStart();
            dummy_bases = new char[dummy_base_count];
            i = 0;
            while (i < dummy_base_count) {
                dummy_bases[i] = 64;
                ++i;
            }
            sub_sequence = String.valueOf(new String(dummy_bases)) + sub_sequence;
        }
        if (real_range.getEnd() > this.getLength()) {
            dummy_base_count = real_range.getEnd() - this.getLength();
            dummy_bases = new char[dummy_base_count];
            i = 0;
            while (i < dummy_base_count) {
                dummy_bases[i] = 64;
                ++i;
            }
            sub_sequence = String.valueOf(sub_sequence) + new String(dummy_bases);
        }
        if (1 == direction) {
            return sub_sequence;
        }
        return Bases.reverseComplement(sub_sequence);
    }

    public Bases truncate(Range constraint) {
        String bases_string = this.getSubSequence(constraint, 1);
        EmblStreamSequence new_sequence = new EmblStreamSequence(bases_string);
        return new Bases(new_sequence);
    }

    public String deleteRange(Range range) throws ReadOnlyException {
        this.forward_stop_codon_cache = null;
        this.reverse_stop_codon_cache = null;
        String removed_bases = this.getSequence().getSubSequence(range.getStart(), range.getEnd());
        String new_sequence = String.valueOf(this.getSequence().getSubSequence(1, range.getStart() - 1)) + this.getSequence().getSubSequence(range.getEnd() + 1, this.embl_sequence.length());
        try {
            this.embl_sequence.setFromString(new_sequence);
        }
        catch (IllegalSymbolException e) {
            throw new Error("internal error - unexpected exception: " + (Object)((Object)e));
        }
        SequenceChangeEvent event = new SequenceChangeEvent(this, 1, range.getStart(), removed_bases);
        this.fireSequenceChangeEvent(event);
        return removed_bases;
    }

    public void addBases(int position, int direction, String bases) throws ReadOnlyException, IllegalSymbolException {
        String real_bases;
        int real_position;
        this.forward_stop_codon_cache = null;
        this.reverse_stop_codon_cache = null;
        if (direction == 1) {
            real_position = position;
            real_bases = bases.toLowerCase();
        } else {
            real_position = position + 1;
            real_bases = Bases.reverseComplement(bases.toLowerCase());
        }
        String new_sequence = String.valueOf(this.getSequence().getSubSequence(1, real_position - 1)) + real_bases + this.getSequence().getSubSequence(real_position, this.getLength());
        this.getSequence().setFromString(new_sequence);
        SequenceChangeEvent event = new SequenceChangeEvent(this, 2, real_position, real_bases);
        this.fireSequenceChangeEvent(event);
    }

    public void addSequenceChangeListener(SequenceChangeListener l, int priority) {
        if (priority < -5) {
            priority = -5;
        }
        if (priority > 5) {
            priority = 5;
        }
        this.listener_hash_map_array[priority - -5].put(l, null);
    }

    public void removeSequenceChangeListener(SequenceChangeListener l) {
        int i = 0;
        while (i < this.listener_hash_map_array.length) {
            WeakHashMap this_hash_map = this.listener_hash_map_array[i];
            if (this_hash_map.containsKey(l)) {
                this_hash_map.remove(l);
                return;
            }
            ++i;
        }
    }

    private void fireSequenceChangeEvent(SequenceChangeEvent event) {
        int i = this.listener_hash_map_array.length - 1;
        while (i >= 0) {
            WeakHashMap this_hash_map = this.listener_hash_map_array[i];
            if (this_hash_map != null) {
                for (SequenceChangeListener this_listener : this_hash_map.keySet()) {
                    this_listener.sequenceChanged(event);
                }
            }
            --i;
        }
    }

    public float getAverageGCPercent() {
        return (float)(this.getSequence().getCCount() + this.getSequence().getGCount()) / (float)this.getSequence().length() * 100.0f;
    }

    public float getAverageAGPercent() {
        return (float)(this.getSequence().getACount() + this.getSequence().getGCount()) / (float)this.getSequence().length() * 100.0f;
    }

    public int getACount() {
        return this.getSequence().getACount();
    }

    public int getTCount() {
        return this.getSequence().getTCount();
    }

    public int getGCount() {
        return this.getSequence().getGCount();
    }

    public int getCCount() {
        return this.getSequence().getCCount();
    }

    public static String reverseComplement(String sequence_string) {
        StringBuffer return_buffer = new StringBuffer(sequence_string.length());
        int i = sequence_string.length() - 1;
        while (i >= 0) {
            return_buffer.append(Bases.complement(sequence_string.charAt(i)));
            --i;
        }
        return return_buffer.toString();
    }

    public static String complement(String sequence_string) {
        StringBuffer return_buffer = new StringBuffer(sequence_string.length());
        int i = 0;
        while (i < sequence_string.length()) {
            return_buffer.append(Bases.complement(sequence_string.charAt(i)));
            ++i;
        }
        return return_buffer.toString();
    }

    public static char complement(char base) {
        switch (base) {
            case 'A': 
            case 'a': {
                return 't';
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 'a';
            }
            case 'G': 
            case 'g': {
                return 'c';
            }
            case 'C': 
            case 'c': {
                return 'g';
            }
            case 'R': 
            case 'r': {
                return 'y';
            }
            case 'Y': 
            case 'y': {
                return 'r';
            }
            case 'K': 
            case 'k': {
                return 'm';
            }
            case 'M': 
            case 'm': {
                return 'k';
            }
            case 'S': 
            case 's': {
                return 's';
            }
            case 'W': 
            case 'w': {
                return 'w';
            }
            case 'B': 
            case 'b': {
                return 'v';
            }
            case 'D': 
            case 'd': {
                return 'h';
            }
            case 'H': 
            case 'h': {
                return 'd';
            }
            case 'V': 
            case 'v': {
                return 'b';
            }
            case 'N': 
            case 'n': {
                return 'n';
            }
            case 'X': 
            case 'x': {
                return 'x';
            }
        }
        return '@';
    }

    public Sequence getSequence() {
        return this.embl_sequence;
    }

    private static boolean isStopCodon(String sequence_string, int start_index, int direction) {
        char translation;
        if (direction == 1) {
            char first_letter = sequence_string.charAt(start_index);
            char second_letter = sequence_string.charAt(start_index + 1);
            char third_letter = sequence_string.charAt(start_index + 2);
            if (first_letter == 'x' || second_letter == 'x' || third_letter == 'x') {
                return true;
            }
            translation = AminoAcidSequence.getCodonTranslation(first_letter, second_letter, third_letter);
        } else {
            char first_letter = Bases.complement(sequence_string.charAt(start_index - 2));
            char second_letter = Bases.complement(sequence_string.charAt(start_index - 1));
            char third_letter = Bases.complement(sequence_string.charAt(start_index));
            if (first_letter == 'x' || second_letter == 'x' || third_letter == 'x') {
                return true;
            }
            translation = AminoAcidSequence.getCodonTranslation(third_letter, second_letter, first_letter);
        }
        return translation == '+' || translation == '*' || translation == '#';
    }

    private static boolean isLegalCodon(String sequence_string, int start_index, int direction) {
        return direction == 1 ? Bases.isLegalBase(sequence_string.charAt(start_index)) && Bases.isLegalBase(sequence_string.charAt(start_index + 1)) && Bases.isLegalBase(sequence_string.charAt(start_index + 2)) : Bases.isLegalBase(sequence_string.charAt(start_index)) && Bases.isLegalBase(sequence_string.charAt(start_index - 1)) && Bases.isLegalBase(sequence_string.charAt(start_index - 2));
    }

    public static boolean isLegalBase(char base_char) {
        switch (base_char) {
            case 'A': 
            case 'a': {
                return true;
            }
            case 'T': 
            case 't': {
                return true;
            }
            case 'U': 
            case 'u': {
                return true;
            }
            case 'G': 
            case 'g': {
                return true;
            }
            case 'C': 
            case 'c': {
                return true;
            }
        }
        return false;
    }
}

