/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.ProgressInputStream;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class URLDocument
extends Document {
    public URLDocument(URL location) {
        super(location);
    }

    public Document append(String name) throws IOException {
        return new URLDocument(new URL(String.valueOf(this.getURL().toString()) + '/' + name));
    }

    public String getName() {
        String url_string = this.getURL().toString();
        String file_url_string = url_string.substring(url_string.lastIndexOf(47) + 1);
        return file_url_string;
    }

    public Document getParent() {
        String url_string = this.getURL().toString();
        String directory_url_string = url_string.substring(0, url_string.lastIndexOf(47));
        try {
            return new URLDocument(new URL(directory_url_string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean readable() {
        return true;
    }

    public boolean writable() {
        return false;
    }

    public InputStream getInputStream() throws IOException {
        URL url = (URL)this.getLocation();
        URLConnection connection = url.openConnection();
        connection.connect();
        ProgressInputStream in_stream = new ProgressInputStream(connection.getInputStream(), this.getProgressListeners());
        if (this.getURL().toString().endsWith(".gz")) {
            System.out.println(this.getName());
            return new GZIPInputStream(in_stream);
        }
        return in_stream;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new ReadOnlyException("this Document can not be written to");
    }

    private URL getURL() {
        return (URL)this.getLocation();
    }
}

