/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetManager;
import org.eclipse.help.ui.internal.ide.HelpIdePlugin;
import org.eclipse.help.ui.internal.ide.HelpIdeResources;
import org.eclipse.help.ui.internal.search.HelpSearchResult;
import org.eclipse.help.ui.internal.search.SearchQueryData;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IWorkingSet;

public class HelpSearchQuery
implements ISearchQuery {
    private SearchQueryData queryData;
    private String singularLabel;
    private String pluralLabelpattern;
    private HelpSearchResult helpSearchResult;

    public HelpSearchQuery(SearchQueryData data) {
        this.queryData = data;
        this.singularLabel = HelpIdeResources.getString("singleSearchResult", this.queryData.getSearchWord());
        this.pluralLabelpattern = HelpIdeResources.getString("multipleSearchResult", this.queryData.getSearchWord(), "{0}");
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            WorkingSet[] workingSets = null;
            if (this.queryData.isBookFiltering()) {
                IWorkingSet[] allWorkingSets = this.queryData.getSelectedWorkingSets();
                ArrayList<WorkingSet> helpWorkingSets = new ArrayList<WorkingSet>();
                WorkingSetManager wsmgr = BaseHelpSystem.getWorkingSetManager();
                int i = 0;
                while (i < allWorkingSets.length) {
                    WorkingSet ws = wsmgr.getWorkingSet(allWorkingSets[i].getName());
                    if (ws != null) {
                        helpWorkingSets.add(ws);
                    }
                    ++i;
                }
                workingSets = helpWorkingSets.toArray(new WorkingSet[helpWorkingSets.size()]);
            }
            SearchResults results = new SearchResults(workingSets, this.queryData.getMaxHits(), this.queryData.getLocale());
            try {
                BaseHelpSystem.getSearchManager().search(this.queryData.getSearchQuery(), (ISearchHitCollector)results, monitor);
            }
            catch (QueryTooComplexException queryTooComplexException) {}
            this.postResults(results);
        }
        catch (OperationCanceledException operationCanceledException) {
            monitor.done();
        }
        catch (Exception e) {
            HelpIdePlugin.logError("Exception occurred executing help search.", e);
        }
        monitor.done();
        return new Status(0, "org.eclipse.help.ide", 0, "", null);
    }

    public String getLabel() {
        return HelpIdeResources.getString("Searching_for", this.queryData.getSearchWord());
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.helpSearchResult == null) {
            this.helpSearchResult = new HelpSearchResult(this);
        }
        return this.helpSearchResult;
    }

    private void postResults(SearchResults results) {
        SearchHit[] searchHits = results.getSearchHits();
        ArrayList<SearchHit> enabledHits = new ArrayList<SearchHit>();
        int i = 0;
        while (i < searchHits.length) {
            if (!this.queryData.isActivityFiltering() || HelpBasePlugin.getActivitySupport().isEnabledTopic(searchHits[i].getHref(), this.queryData.getLocale())) {
                enabledHits.add(searchHits[i]);
            }
            ++i;
        }
        Match[] matches = new Match[enabledHits.size()];
        int i2 = 0;
        while (i2 < enabledHits.size()) {
            matches[i2] = new Match(enabledHits.get(i2), 0, 0);
            ++i2;
        }
        ((HelpSearchResult)this.getSearchResult()).removeAll();
        ((HelpSearchResult)this.getSearchResult()).addMatches(matches);
    }

    String getPluralLabelpattern() {
        return this.pluralLabelpattern;
    }

    String getSingularLabel() {
        return this.singularLabel;
    }

    SearchQueryData getQueryData() {
        return this.queryData;
    }
}

