/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.ExecutableSQLDAO;
import uk.ac.sanger.jcon.dao.HostNameSQLDAO;
import uk.ac.sanger.jcon.dao.JobDAO;
import uk.ac.sanger.jcon.dao.JobNestedSetHelper;
import uk.ac.sanger.jcon.dao.SQLDAOBaseImpl;
import uk.ac.sanger.jcon.dao.StatusSQLDAO;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.job.Executable;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.JobBatchImpl;
import uk.ac.sanger.jcon.job.JobDefaultImpl;
import uk.ac.sanger.jcon.job.Status;

public class JobSQLDAO
extends SQLDAOBaseImpl
implements JobDAO {
    static final int CASCADE_EXITVALUE = 999;
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$dao$JobSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$JobSQLDAO = JobSQLDAO.class$("uk.ac.sanger.jcon.dao.JobSQLDAO")) : class$uk$ac$sanger$jcon$dao$JobSQLDAO).getName());
    static ResourceBundle sqlStatements = ResourceBundle.getBundle((class$uk$ac$sanger$jcon$dao$JobSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$JobSQLDAO = JobSQLDAO.class$("uk.ac.sanger.jcon.dao.JobSQLDAO")) : class$uk$ac$sanger$jcon$dao$JobSQLDAO).getName());
    private ExecutableSQLDAO executableSQLDAO;
    private StatusSQLDAO statusSQLDAO;
    private HostNameSQLDAO hostNameSQLDAO;
    private JobNestedSetHelper setHelper = new JobNestedSetHelper();
    static /* synthetic */ Class class$uk$ac$sanger$jcon$dao$JobSQLDAO;

    public JobSQLDAO() {
        this.executableSQLDAO = new ExecutableSQLDAO();
        this.statusSQLDAO = new StatusSQLDAO();
        this.hostNameSQLDAO = new HostNameSQLDAO();
    }

    public JobSQLDAO(DataSource datasource) {
        super(datasource);
        this.executableSQLDAO = new ExecutableSQLDAO();
        this.statusSQLDAO = new StatusSQLDAO();
        this.hostNameSQLDAO = new HostNameSQLDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Job readJobById(int jobId) throws Exception, JobControlException {
        Connection c = this.getManagedConnection();
        Job job = null;
        try {
            job = this._readJobById(jobId);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readJobsByTaskId(int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readJobsByTaskId");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Job> jobs = new ArrayList<Job>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                jobs.add(this.populateJob(r));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int readTaskIdByJob(Job job) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readTaskIdByJob");
        Connection c = this.getManagedConnection();
        int taskId = 0;
        try {
            taskId = this._readTaskIdByJob(job);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readJobsByStatusAndTaskId(Status status, int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readJobsByStatusAndTaskId");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Job> jobs = new ArrayList<Job>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            ps.setInt(2, status.getId());
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                jobs.add(this.populateJob(r));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readNJobsByStatusAndTaskId(int n, Status status, int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readNJobsByStatusAndTaskId");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Job> jobs = new ArrayList<Job>();
        int rowCount = 0;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            ps.setInt(2, status.getId());
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next() && rowCount < n) {
                jobs.add(this.populateJob(r));
                ++rowCount;
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List readJobPath(Job job) throws SQLException, JobControlException {
        Connection c = this.getManagedConnection();
        List path = null;
        try {
            path = this._readJobPath(job);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        cat.debug((Object)("Path to root from Job [" + job.getId() + "] is " + path));
        return path;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateJob(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        Timestamp startTime = job.getStartTime();
        Timestamp completionTime = job.getCompletionTime();
        int exitValue = job.getExitValue();
        int retryCount = job.getRetryCount();
        int statusId = job.getStatus().getId();
        String sql = sqlStatements.getString("updateJobById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            this.lockJob(jobId);
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            us.setInt(1, statusId);
            if (startTime != null) {
                us.setTimestamp(2, startTime);
            } else {
                us.setNull(2, 93);
            }
            if (completionTime != null) {
                us.setTimestamp(3, completionTime);
            } else {
                us.setNull(3, 93);
            }
            us.setInt(4, retryCount);
            us.setInt(5, exitValue);
            us.setInt(6, jobId);
            cat.debug((Object)("Executing SQL: " + us));
            us.executeUpdate();
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
                catch (JobControlException je) {
                    cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)je);
                    rollback = true;
                    throw je;
                }
            }
            catch (Throwable throwable) {
                this.cSupport.close(us);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (!this.isManagingConnections()) throw throwable;
                this.cSupport.close(c);
                throw throwable;
            }
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    public synchronized void updateJobReady(Job job) throws SQLException, JobControlException {
        Connection c = this.getManagedConnection();
        boolean rollback = false;
        try {
            this._updateJobReady(job);
        }
        catch (SQLException se) {
            cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
            rollback = true;
            throw se;
        }
        catch (JobControlException je) {
            cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)je);
            rollback = true;
            throw je;
        }
        finally {
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateJobStarted(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int statusId = job.getStatus().getId();
        int retryCount = job.getRetryCount();
        int batchId = 0;
        String queue = null;
        if (job instanceof BatchJob) {
            BatchJob batchJob = (BatchJob)job;
            batchId = batchJob.getBatchId();
            queue = batchJob.getQueue();
        }
        if (statusId != 2) {
            throw new JobControlException("Failed to start Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + "'");
        }
        String sql = sqlStatements.getString("updateJobStartedById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            this.lockJob(jobId);
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            us.setInt(1, 3);
            us.setInt(2, batchId);
            if (queue != null) {
                us.setString(3, queue);
            } else {
                us.setNull(3, 12);
            }
            us.setInt(4, retryCount);
            us.setInt(5, jobId);
            cat.debug((Object)("Executing SQL: " + us));
            us.executeUpdate();
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
                catch (JobControlException je) {
                    cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)je);
                    rollback = true;
                    throw je;
                }
            }
            catch (Throwable throwable) {
                this.cSupport.close(us);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (!this.isManagingConnections()) throw throwable;
                this.cSupport.close(c);
                throw throwable;
            }
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateJobCompleted(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int statusId = job.getStatus().getId();
        int exitValue = job.getExitValue();
        if (statusId != 3) {
            throw new JobControlException("Failed to complete Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + "'");
        }
        String sql = sqlStatements.getString("updateJobCompletedById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            this.lockJob(jobId);
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            us.setInt(1, 4);
            us.setInt(2, exitValue);
            us.setInt(3, jobId);
            cat.debug((Object)("Executing SQL: " + us));
            us.executeUpdate();
            if (job instanceof BatchJob) {
                this.updateJobHosts(job);
            }
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
                catch (JobControlException je) {
                    cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)je);
                    rollback = true;
                    throw je;
                }
            }
            catch (Throwable throwable) {
                this.cSupport.close(us);
                if (!rollback) throw throwable;
                this.cSupport.rollback(c);
                this.cSupport.close(c);
                throw throwable;
            }
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
            this.cSupport.close(c);
        }
        int parentId = this._readJobParentId(job);
        int taskId = this._readTaskIdByJob(job);
        if (parentId == 0) {
            if (job.getLow() == 0) {
                this.cSupport.commit(c);
                if (!this.isManagingConnections()) return;
                this.cSupport.close(c);
                return;
            }
            try {
                this.updateNextJobTreeReady(job, taskId);
                return;
            }
            catch (SQLException se) {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
            }
            finally {
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
            }
        }
        try {
            Job parent = this._readJobById(parentId);
            String parentOperator = parent.getOperator();
            int parentStatusId = parent.getStatus().getId();
            if (parentOperator.equals("AND")) {
                switch (parentStatusId) {
                    case 1: {
                        sql = sqlStatements.getString("readChildStatusSummaryById");
                        Object ps = null;
                        Object childRes = null;
                        boolean allComplete = this.commonChildStatus(parent, 4, taskId);
                        if (!allComplete) return;
                        cat.info((Object)("All children of Job [" + parentId + "] are complete"));
                        this._updateJobReady(parent);
                        return;
                    }
                    case 5: {
                        cat.info((Object)("Parent of Job [" + jobId + "] could not be set READY as it had already FAILED"));
                        return;
                    }
                    case 7: {
                        cat.info((Object)"Parent could not be set READY as it had already SKIPPED");
                        return;
                    }
                    case 6: {
                        cat.info((Object)"Parent could not be set READY as it had already CANCELLED");
                        return;
                    }
                }
                cat.warn((Object)("Unexpected Job parent state '" + parentStatusId + "' (" + parent.getStatus().getDescription() + ")"));
                return;
            }
            if (parentOperator.equals("OR")) {
                switch (parentStatusId) {
                    case 1: {
                        this.updateRedundantChildJobs(parentId, 7, taskId);
                        this._updateJobReady(parent);
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        return;
                    }
                    case 4: {
                        cat.warn((Object)"Parent could not be set READY as it had already COMPLETED");
                        return;
                    }
                    case 7: {
                        cat.warn((Object)"Parent could not be set READY as it had already been SKIPPED");
                        return;
                    }
                    case 5: {
                        cat.warn((Object)"Parent could not be set READY as it had already FAILED");
                        return;
                    }
                }
                cat.warn((Object)("Unexpected Job parent state '" + parentStatusId + "' (" + parent.getStatus().getDescription() + ")"));
                return;
            }
            cat.warn((Object)("Unexpected Job parent operator '" + parent.getOperator() + "'"));
            return;
        }
        catch (SQLException se) {
            cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
            rollback = true;
            throw se;
        }
        catch (JobControlException je) {
            cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)je);
            rollback = true;
            throw je;
        }
        finally {
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
        }
    }

    public void updateJobRetry(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int statusId = job.getStatus().getId();
        int exitValue = job.getExitValue();
        int retryCount = job.getRetryCount();
        int maxRetryCount = job.getMaxRetryCount();
        if (statusId != 2 && statusId != 3) {
            throw new JobControlException("Failed to retry Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + "'");
        }
        String sql = sqlStatements.getString("updateJobRetryById");
        cat.info((Object)("Job [" + jobId + "] failed with exit value " + exitValue + ". Now running retry " + ++retryCount + " of maximum " + maxRetryCount));
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            this.lockJob(jobId);
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            us.setInt(1, 2);
            us.setInt(2, retryCount);
            us.setInt(3, jobId);
            cat.debug((Object)("Executing SQL: " + us));
            us.executeUpdate();
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
            }
            catch (Throwable throwable) {
                this.cSupport.close(us);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
                throw throwable;
            }
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateJobFailed(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int statusId = job.getStatus().getId();
        int exitValue = job.getExitValue();
        int retryCount = job.getRetryCount();
        int maxRetryCount = job.getMaxRetryCount();
        if (statusId != 2 && statusId != 3) {
            throw new JobControlException("Failed to fail Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + "'");
        }
        if (retryCount < maxRetryCount) {
            this.updateJobRetry(job);
            return;
        }
        cat.info((Object)("Job [" + jobId + "] failed with exit value " + exitValue));
        cat.debug((Object)"Updating single Job failure");
        String sql = sqlStatements.getString("updateJobFailedById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            this.lockJob(jobId);
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            us.setInt(1, 5);
            us.setInt(2, exitValue);
            us.setInt(3, jobId);
            cat.debug((Object)("Executing SQL: " + us));
            us.executeUpdate();
            if (job instanceof BatchJob) {
                this.updateJobHosts(job);
            }
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
                catch (JobControlException je) {
                    cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)je);
                    rollback = true;
                    throw je;
                }
            }
            catch (Throwable throwable) {
                this.cSupport.close(us);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (!this.isManagingConnections()) throw throwable;
                this.cSupport.close(c);
                throw throwable;
            }
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateJobFailedCascade(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int statusId = job.getStatus().getId();
        int exitValue = job.getExitValue();
        int retryCount = job.getRetryCount();
        int maxRetryCount = job.getMaxRetryCount();
        if (statusId != 2 && statusId != 3) {
            throw new JobControlException("Failed to fail Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + "'");
        }
        if (retryCount < maxRetryCount) {
            this.updateJobRetry(job);
            return;
        }
        cat.info((Object)("Job [" + jobId + "] failed with exit value " + exitValue));
        cat.debug((Object)"Updating Job failure cascade");
        String sql = sqlStatements.getString("updateJobFailedById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            int taskId = this._readTaskIdByJob(job);
            List jobPath = this._readJobPath(job);
            List failPath = this.filterJobFailurePath(jobPath, taskId);
            if (job instanceof BatchJob) {
                this.updateJobHosts(job);
            }
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            this.lockJob(jobId);
            us.setInt(1, 5);
            us.setInt(2, exitValue);
            us.setInt(3, jobId);
            us.addBatch();
            Iterator fpi = failPath.iterator();
            while (true) {
                if (!fpi.hasNext()) {
                    cat.debug((Object)("Executing SQL: " + us));
                    us.executeBatch();
                    break;
                }
                Job fail = (Job)fpi.next();
                int failId = fail.getId();
                this.lockJob(failId);
                us.setInt(1, 6);
                us.setInt(2, 999);
                us.setInt(3, failId);
                us.addBatch();
            }
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
                catch (JobControlException je) {
                    cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)je);
                    rollback = true;
                    throw je;
                }
            }
            catch (Throwable throwable) {
                this.cSupport.close(us);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (!this.isManagingConnections()) throw throwable;
                this.cSupport.close(c);
                throw throwable;
            }
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    public void updateJobRestore(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int statusId = job.getStatus().getId();
        if (statusId != 5) {
            throw new JobControlException("Failed to continue Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + ". Unable to continue a Job which has not failed");
        }
        String sql = sqlStatements.getString("updateSkippedJobRestoreById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            Integer id;
            this.lockJob(jobId);
            int taskId = this._readTaskIdByJob(job);
            List skipped = this.lockRestorableJobs(jobId, 7, taskId);
            List failed = this.lockRestorableJobs(jobId, 5, taskId);
            if (skipped.size() > 0) {
                cat.debug((Object)("Preparing SQL: " + sql));
                us = c.prepareStatement(sql);
                Iterator si = skipped.iterator();
                while (si.hasNext()) {
                    id = (Integer)si.next();
                    cat.info((Object)("Marking SKIPPED Job [" + id + "] as restorable"));
                    us.setInt(1, 1);
                    us.setNull(2, 4);
                    us.setInt(3, id);
                    us.addBatch();
                }
                cat.debug((Object)("Executing SQL: " + us));
                us.executeBatch();
                this.cSupport.close((Statement)us);
            }
            if (failed.size() > 0) {
                sql = sqlStatements.getString("updateFailedJobRestoreById");
                cat.debug((Object)("Preparing SQL: " + sql));
                us = c.prepareStatement(sql);
                Iterator fi = failed.iterator();
                while (fi.hasNext()) {
                    id = (Integer)fi.next();
                    cat.info((Object)("Marking FAILED Job [" + id + "] as restorable"));
                    us.setInt(1, 2);
                    us.setNull(2, 93);
                    us.setNull(3, 93);
                    us.setInt(4, 0);
                    us.setInt(5, 0);
                    us.setNull(6, 4);
                    us.setInt(7, id);
                    us.addBatch();
                }
                cat.debug((Object)("Executing SQL: " + us));
                us.executeBatch();
                this.cSupport.close((Statement)us);
                this.deleteJobHosts(failed);
            }
        }
        catch (SQLException se) {
            cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
            rollback = true;
            throw se;
        }
        finally {
            this.cSupport.close(us);
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
        }
    }

    public synchronized void updateJobCancelled(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int statusId = job.getStatus().getId();
        int retryCount = job.getRetryCount();
        int maxRetryCount = job.getMaxRetryCount();
        if (statusId == 5 && retryCount < maxRetryCount) {
            throw new JobControlException("Failed to cancel Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + "' and " + "retryCount " + retryCount + "(maximum " + maxRetryCount + "). Unable to cancel a Job which can not be started");
        }
        if (statusId != 2 && statusId != 3) {
            throw new JobControlException("Failed to fail Job [" + jobId + "] as it has status '" + job.getStatus().getDescription() + "'. Unable to cancel a Job which can not be started");
        }
        String sql = sqlStatements.getString("updateJobCancelledById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            this.lockJob(jobId);
            int taskId = this._readTaskIdByJob(job);
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            us.setInt(1, 6);
            us.setInt(2, jobId);
            cat.debug((Object)("Executing SQL: " + us));
            us.executeUpdate();
            this.updateRedundantChildJobs(jobId, 6, taskId);
        }
        catch (SQLException se) {
            try {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
            }
            catch (Throwable throwable) {
                this.cSupport.close(us);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
                throw throwable;
            }
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized int createJob(Job job, int taskId, int low) throws Exception {
        Iterator ji;
        String sql = sqlStatements.getString("createJob");
        List preorderList = this.setHelper.calculateNestedSets(job, low);
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        int tempTaskId = 0;
        int tempParentId = 0;
        int keyCount = 0;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ji = preorderList.iterator();
            while (true) {
                if (!ji.hasNext()) {
                    cat.debug((Object)("Executing SQL: " + ps));
                    ps.executeBatch();
                    Object var23_24 = null;
                    break;
                }
                Job j = (Job)ji.next();
                ps.setInt(1, tempTaskId);
                ps.setInt(2, tempParentId);
                ps.setInt(3, j.getLow());
                ps.setInt(4, j.getHigh());
                ps.setString(5, j.getOperator());
                Executable executable = j.getExecutable();
                if (executable == null) {
                    throw new JobControlException("Failed to create Job as it has a null Executable");
                }
                ps.setInt(6, executable.getId());
                Status status = j.getStatus();
                if (j == null) {
                    throw new JobControlException("Failed to create Job as it has a null Status");
                }
                ps.setInt(7, status.getId());
                ps.setNull(8, 93);
                ps.setNull(9, 93);
                String inputName = j.getInputName();
                if (inputName != null) {
                    ps.setString(10, inputName);
                } else {
                    ps.setNull(10, 12);
                }
                String outputName = j.getOutputName();
                if (outputName != null) {
                    ps.setString(11, outputName);
                } else {
                    ps.setNull(11, 12);
                }
                String errorName = j.getErrorName();
                if (errorName != null) {
                    ps.setString(12, errorName);
                } else {
                    ps.setNull(12, 12);
                }
                String commandTemplate = j.getCommandTemplate();
                if (commandTemplate != null) {
                    ps.setString(13, commandTemplate);
                } else {
                    ps.setNull(13, 12);
                }
                String workDirName = j.getWorkDirectoryName();
                if (workDirName != null) {
                    ps.setString(14, workDirName);
                } else {
                    ps.setNull(14, 12);
                }
                String environment = j.getEnvironment();
                if (environment != null) {
                    ps.setString(15, environment);
                } else {
                    ps.setNull(15, 12);
                }
                if (j instanceof BatchJob) {
                    ps.setString(16, ((BatchJob)j).getQueue());
                    ps.setInt(17, ((BatchJob)j).getBatchId());
                } else {
                    ps.setNull(16, 12);
                    ps.setInt(17, 0);
                }
                ps.setInt(18, j.getMaxRetryCount());
                ps.setInt(19, j.getRetryCount());
                ps.setNull(20, 4);
                ps.addBatch();
            }
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        try {
            sql = sqlStatements.getString("readJobIdsByTaskId");
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, tempTaskId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            ji = preorderList.iterator();
            while (true) {
                block36: {
                    block35: {
                        if (!r.next()) break block35;
                        if (ji.hasNext()) break block36;
                    }
                    Object var25_27 = null;
                    break;
                }
                int jobId = r.getInt("job_id");
                ++keyCount;
                Job j = (Job)ji.next();
                this.setObjectIntField(j, "id", jobId);
            }
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            this.cSupport.close(r);
            this.cSupport.close((Statement)ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (preorderList.size() != keyCount) {
            throw new JobControlException("Created " + preorderList.size() + " Jobs but retrieved " + keyCount + " autoincremented IDs.");
        }
        try {
            sql = sqlStatements.getString("updateJobTaskParentById");
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ji = preorderList.iterator();
            while (true) {
                if (!ji.hasNext()) {
                    cat.debug((Object)("Executing SQL: " + ps));
                    ps.executeBatch();
                    Object var27_30 = null;
                    break;
                }
                Job j = (Job)ji.next();
                ps.setInt(1, taskId);
                Job parent = (Job)j.getParent();
                if (parent == null) {
                    ps.setInt(2, 0);
                } else {
                    ps.setInt(2, parent.getId());
                }
                ps.setInt(3, j.getId());
                ps.addBatch();
            }
        }
        catch (Throwable throwable) {
            Object var27_31 = null;
            this.cSupport.close((Statement)ps);
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        return job.getHigh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Job[] readRootJobsByTaskId(int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readRootJobsByTaskId");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Job> jobs = new ArrayList<Job>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                jobs.add(this.populateJob(r));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        return jobs.toArray(new Job[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateNextJobTreeReady(Job rootJob, int taskId) throws SQLException, JobControlException {
        int jobId = rootJob.getId();
        int low = rootJob.getLow();
        if (low == 0) {
            throw new JobControlException("Job [" + jobId + "] is the goal for Task [" + taskId + "]");
        }
        String sql = sqlStatements.getString("readNextRootJob");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        Job job = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            ps.setInt(2, jobId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Unable to update next tree after Job [" + jobId + "] in Task [" + taskId + "]");
            }
            job = this.populateJob(r);
            this.updateLeafJobsReady(job, taskId);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateLeafJobsReady(Job rootJob, int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("updateLeafJobsReady");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, 2);
            ps.setInt(2, taskId);
            ps.setInt(3, rootJob.getLow());
            ps.setInt(4, rootJob.getHigh());
            ps.setInt(5, 1);
            cat.debug((Object)("Executing SQL: " + ps));
            ps.executeUpdate();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteJob(int jobId, int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("deleteJob");
        Connection c = this.getConnection();
        PreparedStatement us = null;
        try {
            List selected = this.lockJobTree(jobId, taskId);
            if (selected.size() > 0) {
                cat.debug((Object)("Preparing SQL: " + sql));
                us = c.prepareStatement(sql);
                Iterator si = selected.iterator();
                while (si.hasNext()) {
                    Integer id = (Integer)si.next();
                    cat.info((Object)("Marking Job [" + id + "] for deletion"));
                    us.setInt(1, id);
                    us.addBatch();
                }
                cat.debug((Object)("Executing SQL: " + us));
                us.executeBatch();
                this.deleteJobHosts(selected);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.cSupport.close(us);
            throw throwable;
        }
        this.cSupport.close(us);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockJob(int jobId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("selectJobForUpdateById");
        Connection c = this.getConnection();
        PreparedStatement ls = null;
        ResultSet r = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ls = c.prepareStatement(sql);
            ls.setInt(1, jobId);
            cat.debug((Object)("Executing SQL: " + ls));
            r = ls.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Failed to find Job [" + jobId + "] for update");
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(r);
            this.cSupport.close(ls);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List lockJobTree(int jobId, int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("selectTreeForUpdate");
        Connection c = this.getConnection();
        PreparedStatement ls = null;
        ResultSet r = null;
        ArrayList<Integer> selected = new ArrayList<Integer>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ls = c.prepareStatement(sql);
            ls.setInt(1, taskId);
            ls.setInt(2, taskId);
            ls.setInt(3, jobId);
            cat.debug((Object)("Executing SQL: " + ls));
            r = ls.executeQuery();
            while (r.next()) {
                int id = r.getInt("job_id");
                selected.add(new Integer(id));
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.cSupport.close(r);
            this.cSupport.close(ls);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ls);
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List lockChildJobsByStatus(int parentId, int taskId, int statusIdX, int statusIdY) throws SQLException {
        String sql = sqlStatements.getString("selectChildTreeForUpdateByStatus");
        Connection c = this.getConnection();
        PreparedStatement ls = null;
        ResultSet r = null;
        ArrayList<Integer> selected = new ArrayList<Integer>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ls = c.prepareStatement(sql);
            ls.setInt(1, taskId);
            ls.setInt(2, taskId);
            ls.setInt(3, parentId);
            ls.setInt(4, statusIdX);
            ls.setInt(5, statusIdY);
            cat.debug((Object)("Executing SQL: " + ls));
            r = ls.executeQuery();
            while (r.next()) {
                int jobId = r.getInt("job_id");
                selected.add(new Integer(jobId));
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.cSupport.close(r);
            this.cSupport.close(ls);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ls);
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List lockRestorableJobs(int jobId, int statusId, int taskId) throws SQLException {
        String sql = sqlStatements.getString("selectRestorableJobsForUpdate");
        Connection c = this.getConnection();
        PreparedStatement ls = null;
        ResultSet r = null;
        ArrayList<Integer> selected = new ArrayList<Integer>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ls = c.prepareStatement(sql);
            ls.setInt(1, taskId);
            ls.setInt(2, taskId);
            ls.setInt(3, jobId);
            ls.setInt(4, statusId);
            ls.setInt(5, 0);
            cat.debug((Object)("Executing SQL: " + ls));
            r = ls.executeQuery();
            while (r.next()) {
                int id = r.getInt("job_id");
                selected.add(new Integer(id));
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.cSupport.close(r);
            this.cSupport.close(ls);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ls);
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRedundantChildJobs(int parentId, int newStatusId, int taskId) throws SQLException {
        if (newStatusId != 7 && newStatusId != 6) {
            throw new IllegalArgumentException("New Status ID was not one of 7 or 6");
        }
        String sql = sqlStatements.getString("updateJobStatus");
        Connection c = this.getConnection();
        PreparedStatement us = null;
        try {
            List redundant = this.lockChildJobsByStatus(parentId, taskId, 1, 2);
            if (redundant.size() > 0) {
                cat.debug((Object)("Preparing SQL: " + sql));
                us = c.prepareStatement(sql);
                Iterator ri = redundant.iterator();
                while (ri.hasNext()) {
                    Integer id = (Integer)ri.next();
                    cat.info((Object)("Marking Job [" + id + "] as redundant"));
                    us.setInt(1, newStatusId);
                    us.setInt(2, id);
                    us.addBatch();
                }
                cat.debug((Object)("Executing SQL: " + us));
                us.executeBatch();
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.cSupport.close(us);
            throw throwable;
        }
        this.cSupport.close(us);
    }

    private Job populateJob(ResultSet r) throws SQLException, JobControlException {
        Connection c = this.getConnection();
        this.executableSQLDAO.setConnection(c);
        this.statusSQLDAO.setConnection(c);
        this.hostNameSQLDAO.setConnection(c);
        int jobId = r.getInt("job_id");
        int parentId = r.getInt("parent_id");
        int execId = r.getInt("exec_id");
        int statusId = r.getInt("status_id");
        int low = r.getInt("low");
        int high = r.getInt("high");
        Timestamp startTime = r.getTimestamp("start_time");
        Timestamp completionTime = r.getTimestamp("completion_time");
        String operator = r.getString("operator");
        String inputName = r.getString("input_name");
        String outputName = r.getString("output_name");
        String errorName = r.getString("error_name");
        String commandTemplate = r.getString("cmd_templ");
        String workDirectoryName = r.getString("work_dir_name");
        String environment = r.getString("environment");
        int maxRetryCount = r.getInt("max_retry_count");
        int retryCount = r.getInt("retry_count");
        int exitValue = r.getInt("exit_value");
        int batchId = r.getInt("batch_id");
        String queue = r.getString("queue");
        Executable executable = this.executableSQLDAO.readExecutableById(execId);
        Status status = this.statusSQLDAO.readStatusById(statusId);
        String[] hosts = this.hostNameSQLDAO.readHostNamesByJobId(jobId);
        JobDefaultImpl job = null;
        if (queue != null) {
            job = new JobBatchImpl(operator, executable, status, startTime, completionTime, inputName, outputName, errorName, commandTemplate, workDirectoryName, environment, maxRetryCount, retryCount, exitValue, queue);
            ((BatchJob)((Object)job)).setBatchId(batchId);
            ((BatchJob)((Object)job)).setHosts(hosts);
        } else {
            job = new JobDefaultImpl(operator, executable, status, startTime, completionTime, inputName, outputName, errorName, commandTemplate, workDirectoryName, environment, maxRetryCount, retryCount, exitValue);
        }
        this.setObjectIntField(job, "id", jobId);
        job.setLow(low);
        job.setHigh(high);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Job[] populateJobTrees(int taskId) throws SQLException, JobControlException {
        Integer pi;
        HashMap<Integer, Job> parentIdToParent = new HashMap<Integer, Job>();
        HashMap parentIdToChildren = new HashMap();
        String sql = sqlStatements.getString("readJobsByTaskId");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                Job job = this.populateJob(r);
                parentIdToParent.put(new Integer(job.getId()), job);
                int parentId = r.getInt("parent_id");
                pi = new Integer(parentId);
                if (parentIdToChildren.containsKey(pi)) {
                    ((List)parentIdToChildren.get(pi)).add(job);
                    continue;
                }
                ArrayList<Job> children = new ArrayList<Job>();
                children.add(job);
                parentIdToChildren.put(pi, children);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        TreeMap rootJobs = new TreeMap();
        Iterator ji = parentIdToChildren.keySet().iterator();
        while (ji.hasNext()) {
            pi = (Integer)ji.next();
            Job parent = (Job)parentIdToParent.get(pi);
            if (parent == null) {
                rootJobs.put(pi, ((List)parentIdToChildren.get(pi)).get(0));
                continue;
            }
            List children = (List)parentIdToChildren.get(pi);
            Iterator ci = children.iterator();
            while (ci.hasNext()) {
                Job child = (Job)ci.next();
                parent.add(child);
            }
        }
        return rootJobs.values().toArray(new Job[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewJobId() throws Exception {
        String sql = sqlStatements.getString("createNewJobId");
        Connection c = this.getConnection();
        Statement s = null;
        ResultSet r = null;
        int id = 0;
        try {
            s = c.createStatement();
            cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            if (!r.next()) {
                throw new Exception("Failed to retrieve a new Job ID");
            }
            id = r.getInt("job_id");
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(r);
            this.cSupport.close(s);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commonChildStatus(Job job, int statusId, int taskId) throws SQLException {
        String sql = sqlStatements.getString("readChildStatusSummaryById");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        boolean allMatch = true;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            ps.setInt(2, job.getId());
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                int childStatusId = r.getInt("status_id");
                if (childStatusId == statusId) continue;
                allMatch = false;
                break;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        return allMatch;
    }

    private List filterJobFailurePath(List path, int taskId) throws SQLException, JobControlException {
        ArrayList<Job> filtered = new ArrayList<Job>();
        boolean continguous = true;
        int i = 0;
        block5: while (i < path.size()) {
            Job job = (Job)path.get(i);
            int jobId = job.getId();
            String operator = job.getOperator();
            int statusId = job.getStatus().getId();
            switch (statusId) {
                case 1: 
                case 2: {
                    if (operator.equals("AND")) {
                        if (!continguous) break;
                        filtered.add(job);
                        break;
                    }
                    if (!operator.equals("OR") || !this.commonChildStatus(job, 5, taskId)) break;
                    filtered.add(job);
                    break;
                }
                case 3: {
                    break block5;
                }
                case 5: 
                case 6: 
                case 7: {
                    continguous = false;
                    break;
                }
                default: {
                    throw new JobControlException("Unknown Status ID '" + statusId + "'");
                }
            }
            ++i;
        }
        cat.debug((Object)("Failure path to root from Job is now " + filtered));
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobHosts(Job job) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("updateJobHosts");
        Connection c = this.getConnection();
        this.hostNameSQLDAO.setConnection(c);
        PreparedStatement us = null;
        int jobId = job.getId();
        String[] hosts = ((JobBatchImpl)job).getHosts();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            int i = 0;
            while (i < hosts.length) {
                int hostId = this.hostNameSQLDAO.readHostIdByName(hosts[i]);
                us.setInt(1, jobId);
                us.setInt(2, hostId);
                us.addBatch();
                ++i;
            }
            cat.debug((Object)("Executing SQL: " + us));
            us.executeBatch();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.cSupport.close(us);
            throw throwable;
        }
        this.cSupport.close((Statement)us);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteJobHosts(List jobIds) throws SQLException {
        String sql = sqlStatements.getString("deleteJobHosts");
        Connection c = this.getConnection();
        PreparedStatement us = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            Iterator ji = jobIds.iterator();
            while (ji.hasNext()) {
                Integer id = (Integer)ji.next();
                us.setInt(1, id);
                us.addBatch();
            }
            cat.debug((Object)("Executing SQL: " + us));
            us.executeBatch();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cSupport.close(us);
            throw throwable;
        }
        this.cSupport.close((Statement)us);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job _readJobById(int jobId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readJobById");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        Job job = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, jobId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Requested a non-existent Job with ID '" + jobId + "'");
            }
            job = this.populateJob(r);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _readTaskIdByJob(Job job) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readTaskIdByJob");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        int taskId = -1;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, job.getId());
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Failed to find Job [" + job.getId() + "]");
            }
            taskId = r.getInt("task_id");
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _readJobParentId(Job job) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readJobParentId");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        int parentId = 0;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, job.getId());
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Failed to find Job [" + job.getId() + "]");
            }
            parentId = r.getInt("parent_id");
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        return parentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List _readJobPath(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        int low = job.getLow();
        int high = job.getHigh();
        int taskId = this._readTaskIdByJob(job);
        String sql = sqlStatements.getString("readJobPath");
        Connection c = this.getConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Job> path = new ArrayList<Job>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            ps.setInt(2, low);
            ps.setInt(3, high);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            int childId = jobId;
            while (r.next()) {
                Job j = this.populateJob(r);
                path.add(j);
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        cat.debug((Object)("Path to root from Job [" + jobId + "] is " + path));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateJobReady(Job job) throws SQLException, JobControlException {
        int jobId = job.getId();
        String sql = sqlStatements.getString("updateJobReadyById");
        Connection c = this.getConnection();
        PreparedStatement us = null;
        try {
            this.lockJob(jobId);
            cat.debug((Object)("Preparing SQL: " + sql));
            us = c.prepareStatement(sql);
            us.setInt(1, 2);
            us.setInt(2, jobId);
            cat.debug((Object)("Executing SQL: " + us));
            us.executeUpdate();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(us);
            throw throwable;
        }
        this.cSupport.close((Statement)us);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

