/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControl;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.JobDAO;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.Task;
import uk.ac.sanger.jcon.lsf.LSFBatchException;
import uk.ac.sanger.jcon.lsf.LSFQueueWatcher;
import uk.ac.sanger.jcon.run.CommandLineFactory;
import uk.ac.sanger.jcon.run.CommandLineFactoryVelocityImpl;
import uk.ac.sanger.jcon.run.Coordinator;
import uk.ac.sanger.jcon.run.Processor;
import uk.ac.sanger.jcon.run.ProcessorFactory;

public class CoordinatorLSFImpl
implements Coordinator,
Runnable {
    public static final int DEFAULT_MAX_CONCURRENT = 20;
    public static final int DEFAULT_GRAB_SIZE = 10;
    public static final int DEFAULT_POLL_INTERVAL = 60000;
    public static final String BATCH_QUEUE_KEY = "jobcontrol.queue.name";
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$run$CoordinatorLSFImpl == null ? (class$uk$ac$sanger$jcon$run$CoordinatorLSFImpl = CoordinatorLSFImpl.class$("uk.ac.sanger.jcon.run.CoordinatorLSFImpl")) : class$uk$ac$sanger$jcon$run$CoordinatorLSFImpl).getName());
    protected JobDAO jobDAO;
    protected StatusDAO statusDAO;
    protected ProcessorFactory pFactory;
    protected CommandLineFactory clFactory;
    protected Task taskLite;
    protected int jobGrabSize;
    protected int jobPollInterval;
    protected int maxConcurrentJobs;
    protected boolean isCoordinating;
    protected boolean stopRequested;
    protected Status started;
    protected Status ready;
    private Thread thread;
    private LSFQueueWatcher queueWatcher;
    private Map queueProcessors;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$run$CoordinatorLSFImpl;

    public CoordinatorLSFImpl(ProcessorFactory pFactory, JobDAO jobDAO, StatusDAO statusDAO) {
        this.pFactory = pFactory;
        this.jobDAO = jobDAO;
        this.statusDAO = statusDAO;
        this.clFactory = CommandLineFactoryVelocityImpl.getInstance();
        this.isCoordinating = false;
        this.stopRequested = false;
        this.queueProcessors = new HashMap();
        this.maxConcurrentJobs = 20;
        this.jobGrabSize = 10;
        this.jobPollInterval = 60000;
        ResourceBundle bundle = JobControl.getConfiguration();
        try {
            Enumeration<String> e = bundle.getKeys();
            while (e.hasMoreElements()) {
                String val;
                String key = e.nextElement();
                try {
                    val = bundle.getString(key);
                }
                catch (NullPointerException npe) {
                    throw new Error("Malformed configuration ResourceBundle contains key '" + key + "' missing a corresponding value");
                }
                if (key.equals(BATCH_QUEUE_KEY)) {
                    StringTokenizer st = new StringTokenizer(val);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        cat.info((Object)("Adding queue '" + token + "' to known queues"));
                        this.queueProcessors.put(token, null);
                    }
                    continue;
                }
                if (key.equals("jobcontrol.coordinator.max_concurrent")) {
                    this.maxConcurrentJobs = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("jobcontrol.coordinator.grab_size")) {
                    this.jobGrabSize = Integer.parseInt(val);
                    continue;
                }
                if (!key.equals("jobcontrol.coordinator.poll_interval")) continue;
                this.jobPollInterval = Integer.parseInt(val);
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Number format error in configuration ResourceBundle");
        }
        this.queueWatcher = new LSFQueueWatcher(statusDAO);
        this.thread = new Thread(this);
    }

    public Task getTask() {
        return this.taskLite;
    }

    public synchronized void setTask(Task taskLite) {
        cat.info((Object)("Changed current Task to " + taskLite));
        this.taskLite = taskLite;
    }

    public int getMaxConcurrentJobs() {
        return this.maxConcurrentJobs;
    }

    public int getJobGrabSize() {
        return this.jobGrabSize;
    }

    public void setJobGrabSize(int jobGrabSize) throws JobControlException {
        if (jobGrabSize < 1 || jobGrabSize > this.maxConcurrentJobs) {
            throw new JobControlException("Failed to set Job grab size to a value exceeding the maximum concurrent number of Jobs");
        }
        cat.debug((Object)("Now fetching groups of " + jobGrabSize + " jobs from storage"));
        this.jobGrabSize = jobGrabSize;
    }

    public void startCoordinating() throws IllegalStateException {
        if (this.isCoordinating) {
            throw new IllegalStateException("Coordinator is already running");
        }
        this.isCoordinating = true;
        this.stopRequested = false;
        this.createProcessors();
        cat.info((Object)"Job execution Coordinator started");
        this.thread.start();
    }

    public void stopCoordinating() throws IllegalStateException {
        if (!this.isCoordinating) {
            throw new IllegalStateException("Coordinator is already stopped");
        }
        this.stopRequested = true;
        cat.info((Object)"Job execution Coordinator stop requested");
    }

    public void run() {
        this.coordinate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void coordinate() {
        try {
            this.started = this.statusDAO.readStatusById(3);
            this.ready = this.statusDAO.readStatusById(2);
        }
        catch (Exception e) {
            cat.error((Object)"Caught Exception while reading startup values.", (Throwable)e);
        }
        while (this.isCoordinating) {
            int freeSlots = this.countFreeProcessors();
            int queues = this.queueProcessors.keySet().size();
            cat.info((Object)("Currently running: " + (queues * this.maxConcurrentJobs - freeSlots) + " jobs. Max concurrent Jobs per queue allowed: " + this.maxConcurrentJobs + " (" + freeSlots + " combined free slots; grab size " + this.jobGrabSize + ")"));
            if (this.stopRequested) {
                if (freeSlots == queues * this.maxConcurrentJobs) {
                    cat.info((Object)"No Jobs running. Coordinator stopping now.");
                    this.isCoordinating = false;
                    return;
                }
                cat.info((Object)"Jobs still running. Awaiting their completion before Coordinator is stopped.");
                this.waitFor(this.jobPollInterval);
                this.checkRunningJobs();
                continue;
            }
            if (this.taskLite == null) {
                this.waitFor(this.jobPollInterval);
                continue;
            }
            if (freeSlots >= this.jobGrabSize) {
                try {
                    CoordinatorLSFImpl coordinatorLSFImpl = this;
                    synchronized (coordinatorLSFImpl) {
                        Collection readyJobs = this.jobDAO.readNJobsByStatusAndTaskId(freeSlots, this.ready, this.taskLite.getId());
                        cat.debug((Object)("Found ready Jobs: " + readyJobs));
                        this.assignReadyJobs(readyJobs);
                    }
                }
                catch (Exception e) {
                    cat.error((Object)"Caught Exception while fetching ready Jobs.", (Throwable)e);
                }
            }
            this.waitFor(this.jobPollInterval);
            this.checkRunningJobs();
        }
    }

    protected void checkRunningJobs() {
        this.queueWatcher.update();
    }

    protected synchronized void waitFor(int milliSeconds) {
        try {
            cat.info((Object)("Waiting for " + milliSeconds + " ms"));
            this.wait(milliSeconds);
        }
        catch (InterruptedException ie) {
            cat.error((Object)"Caught Exception", (Throwable)ie);
        }
    }

    protected void createProcessors() {
        Iterator qi = this.queueProcessors.keySet().iterator();
        while (qi.hasNext()) {
            String queue = (String)qi.next();
            cat.debug((Object)("Creating " + this.getMaxConcurrentJobs() + " processors for queue '" + queue + "'"));
            Processor[] processors = new Processor[this.getMaxConcurrentJobs()];
            int i = 0;
            while (i < processors.length) {
                processors[i] = this.pFactory.createProcessor(this.clFactory, this.statusDAO);
                ++i;
            }
            this.queueProcessors.put(queue, processors);
        }
    }

    protected int countFreeProcessors() {
        int totalFreeProcs = 0;
        Iterator qi = this.queueProcessors.keySet().iterator();
        while (qi.hasNext()) {
            String queue = (String)qi.next();
            Processor[] processors = (Processor[])this.queueProcessors.get(queue);
            int freeProcs = 0;
            int i = 0;
            while (i < processors.length) {
                if (processors[i].getFree()) {
                    ++freeProcs;
                }
                ++i;
            }
            totalFreeProcs += freeProcs;
            cat.debug((Object)("Found " + freeProcs + " for queue '" + queue + "'"));
        }
        return totalFreeProcs;
    }

    protected Processor getFreeProcessor(String queue) {
        Processor[] processors = (Processor[])this.queueProcessors.get(queue);
        cat.debug((Object)("Checking for free slots in " + processors));
        int i = 0;
        while (i < processors.length) {
            cat.debug((Object)("Testing whether processor " + i + " is free"));
            if (processors[i].getFree()) {
                cat.debug((Object)("Processor " + i + " is free"));
                return processors[i];
            }
            ++i;
        }
        return null;
    }

    protected void setFreeProcessor(BatchJob job) {
        String queue = job.getQueue();
        int index = this.findProcessorIndex(job.getId(), queue);
        if (index == -1) {
            cat.error((Object)("Failed to find which Processor was processing Job [" + job.getId() + "]"));
        } else {
            cat.debug((Object)("Set processor " + index + " free on completion of Job [" + job.getId() + "]"));
            Processor[] processors = (Processor[])this.queueProcessors.get(queue);
            processors[index].setFree(true);
        }
        try {
            this.queueWatcher.stopWatching(job);
        }
        catch (LSFBatchException lbe) {
            cat.error((Object)("Caught Exception while freeing Job [" + job.getId() + "] from queue watcher"), (Throwable)lbe);
        }
    }

    protected int findProcessorIndex(int jobId, String queue) {
        Processor[] processors = (Processor[])this.queueProcessors.get(queue);
        int i = 0;
        while (i < processors.length) {
            Job procJob;
            if (!processors[i].getFree() && (procJob = processors[i].getJob()) != null && jobId == procJob.getId()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void assignReadyJobs(Collection readyJobs) {
        HashSet<String> fullProcessors = new HashSet<String>();
        Iterator ri = readyJobs.iterator();
        while (ri.hasNext()) {
            Job j = (Job)ri.next();
            if (!(j instanceof BatchJob)) {
                cat.error((Object)("Job [" + j.getId() + "] is not a batch job. Skipping..."));
                continue;
            }
            BatchJob job = (BatchJob)j;
            String queue = job.getQueue();
            if (fullProcessors.contains(queue)) {
                cat.debug((Object)("Not looking for free processor for queue '" + queue + "' because previous attempt showed none available"));
                continue;
            }
            cat.debug((Object)("Looking for free processor for queue '" + queue + "'"));
            Processor proc = this.getFreeProcessor(queue);
            if (proc != null) {
                cat.debug((Object)("About to start " + job));
                PropertyChangeListener listener = this.createUpdateListener();
                job.addPropertyChangeListener("status", listener);
                try {
                    proc.process(job);
                    this.queueWatcher.watchFor(job);
                }
                catch (Exception e) {
                    cat.error((Object)("Caught Exception while starting Job [" + job.getId() + "]"), (Throwable)e);
                    cat.debug((Object)("Removing status update listener from Job [" + job.getId() + "]"));
                    job.removePropertyChangeListener(listener);
                    this.setFreeProcessor(job);
                }
                continue;
            }
            cat.debug((Object)("Failed to find a free Processor for queue '" + queue + "'. Will not check again"));
            fullProcessors.add(queue);
        }
    }

    protected PropertyChangeListener createUpdateListener() {
        return new UpdateListener();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UpdateListener
    implements PropertyChangeListener {
        UpdateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent evt) {
            job = (BatchJob)evt.getSource();
            oldState = ((Status)evt.getOldValue()).getId();
            newState = ((Status)evt.getNewValue()).getId();
            terminated = false;
            try {
                try {
                    switch (newState) {
                        case 3: {
                            CoordinatorLSFImpl.this.jobDAO.updateJobStarted(job);
                            ** break;
                        }
                        case 4: {
                            CoordinatorLSFImpl.this.jobDAO.updateJobCompleted(job);
                            terminated = true;
                            ** break;
                        }
                        case 5: {
                            CoordinatorLSFImpl.this.jobDAO.updateJobFailedCascade(job);
                            terminated = true;
                            ** break;
                        }
                        case 6: {
                            terminated = true;
                            ** break;
                        }
                        case 7: {
                            terminated = true;
                            ** break;
                        }
                    }
                    CoordinatorLSFImpl.cat.warn((Object)("Coordinator was asked to apply unexpected update of Job [" + job.getId() + "] from status " + oldState + " to " + newState));
                }
                catch (Exception e) {
                    CoordinatorLSFImpl.cat.error((Object)("Coordinator failed to update Job [" + job.getId() + "]"), (Throwable)e);
                    var8_7 = null;
                    if (terminated == false) return;
                    CoordinatorLSFImpl.this.setFreeProcessor(job);
                    job.removePropertyChangeListener(this);
                    return;
                }
                var8_6 = null;
                if (terminated == false) return;
                CoordinatorLSFImpl.this.setFreeProcessor(job);
            }
            catch (Throwable var7_10) {
                var8_8 = null;
                if (terminated == false) throw var7_10;
                CoordinatorLSFImpl.this.setFreeProcessor(job);
                job.removePropertyChangeListener(this);
                throw var7_10;
            }
            job.removePropertyChangeListener(this);
        }
    }
}

