/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.EditorAreaDropAdapter;
import org.eclipse.ui.internal.ide.IDEExceptionHandler;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.WorkbenchActionBuilder;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.SiteManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class IDEWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String ACTION_BUILDER = "ActionBuilder";
    private static final String WELCOME_EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    private static final String WORKBENCH_PREFERENCE_CATEGORY_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String INSTALLED_FEATURES = "installedFeatures";
    private static IDEWorkbenchAdvisor workbenchAdvisor = null;
    private IDEExceptionHandler exceptionHandler = null;
    private String workspaceLocation = null;
    private Map newlyAddedBundleGroups;
    private ArrayList welcomePerspectiveInfos = null;
    private IDEWorkbenchActivityHelper activityHelper = null;
    private boolean editorsAndIntrosOpened = false;

    protected IDEWorkbenchAdvisor() {
        if (workbenchAdvisor != null) {
            throw new IllegalStateException();
        }
        workbenchAdvisor = this;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        this.exceptionHandler = new IDEExceptionHandler(configurer);
        WorkbenchAdapterBuilder.registerAdapters();
        String[] cmdLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < cmdLineArgs.length) {
            if ("-showlocation".equalsIgnoreCase(cmdLineArgs[i])) {
                this.workspaceLocation = Platform.getLocation().toOSString();
                break;
            }
            ++i;
        }
        this.declareWorkbenchImages();
        this.activityHelper = IDEWorkbenchActivityHelper.getInstance();
    }

    public void preStartup() {
        Platform.getJobManager().suspend();
        if (!this.hasIntro()) {
            Map m = this.getNewlyAddedBundleGroups();
            this.welcomePerspectiveInfos = new ArrayList(m.size());
            Iterator i = m.values().iterator();
            while (i.hasNext()) {
                AboutInfo info = (AboutInfo)i.next();
                if (info == null || info.getWelcomePerspectiveId() == null || info.getWelcomePageURL() == null) continue;
                this.welcomePerspectiveInfos.add(info);
            }
        }
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        ImageDescriptor newImage = IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC");
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_MANUAL_BUILD);
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postStartup() {
        try {
            this.refreshFromLocal();
            this.checkUpdates();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            Platform.getJobManager().resume();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        Platform.getJobManager().resume();
    }

    public void postShutdown() {
        if (this.activityHelper != null) {
            this.activityHelper.shutdown();
            this.activityHelper = null;
        }
        if (IDEWorkbenchPlugin.getPluginWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
    }

    public void eventLoopException(Throwable exception) {
        super.eventLoopException(exception);
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(exception);
        } else if (this.getWorkbenchConfigurer() != null) {
            this.getWorkbenchConfigurer().emergencyClose();
        }
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer windowConfigurer) {
        if (this.getWorkbenchConfigurer().getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        if (promptOnExit) {
            String productName = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                productName = product.getName();
            }
            String message = productName == null ? IDEWorkbenchMessages.getString("PromptOnExitDialog.message0") : IDEWorkbenchMessages.format("PromptOnExitDialog.message1", new Object[]{productName});
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)windowConfigurer.getWindow().getShell(), (String)IDEWorkbenchMessages.getString("PromptOnExitDialog.shellTitle"), (String)message, (String)IDEWorkbenchMessages.getString("PromptOnExitDialog.choice"), (boolean)false, null, null);
            if (dlg.getReturnCode() != 0) {
                return false;
            }
            if (dlg.getToggleState()) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
                IDEWorkbenchPlugin.getDefault().savePluginPreferences();
            }
        }
        return true;
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer windowConfigurer) {
        windowConfigurer.setShowPerspectiveBar(true);
        windowConfigurer.setShowFastViewBars(true);
        windowConfigurer.setShowProgressIndicator(true);
        windowConfigurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        windowConfigurer.addEditorAreaTransfer((Transfer)ResourceTransfer.getInstance());
        windowConfigurer.addEditorAreaTransfer((Transfer)MarkerTransfer.getInstance());
        windowConfigurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter(windowConfigurer.getWindow()));
        windowConfigurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
                IDEWorkbenchAdvisor.this.updateTitle(page.getWorkbenchWindow());
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        windowConfigurer.getWindow().addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchAdvisor.this.updateTitle(page.getWorkbenchWindow());
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        });
        windowConfigurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference || ref.getPage().getActiveEditor() == null) {
                    IDEWorkbenchAdvisor.this.updateTitle(ref.getPage().getWorkbenchWindow());
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference || ref.getPage().getActiveEditor() == null) {
                    IDEWorkbenchAdvisor.this.updateTitle(ref.getPage().getWorkbenchWindow());
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
            }

            public void partVisible(IWorkbenchPartReference ref) {
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer windowConfigurer) throws WorkbenchException {
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        if (index >= 0 && this.welcomePerspectiveInfos != null && index < this.welcomePerspectiveInfos.size()) {
            IWorkbenchPage[] pages;
            IWorkbenchPage page = windowConfigurer.getWindow().getActivePage();
            if (page == null && (pages = windowConfigurer.getWindow().getPages()) != null && pages.length > 0) {
                page = pages[0];
            }
            String perspectiveId = ((AboutInfo)this.welcomePerspectiveInfos.get(index)).getWelcomePerspectiveId();
            if (page == null) {
                IAdaptable root = this.getDefaultPageInput();
                page = windowConfigurer.getWindow().openPage(perspectiveId, root);
            } else {
                IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
                IPerspectiveDescriptor desc = reg.findPerspectiveWithId(perspectiveId);
                if (desc != null) {
                    page.setPerspective(desc);
                }
            }
            windowConfigurer.getWindow().setActivePage(page);
            page.openEditor((IEditorInput)new WelcomeEditorInput((AboutInfo)this.welcomePerspectiveInfos.get(index)), WELCOME_EDITOR_ID, true);
        }
    }

    public void postWindowClose(IWorkbenchWindowConfigurer windowConfigurer) {
        WorkbenchActionBuilder a = (WorkbenchActionBuilder)windowConfigurer.getData(ACTION_BUILDER);
        if (a != null) {
            windowConfigurer.setData(ACTION_BUILDER, null);
            a.dispose();
        }
    }

    private void refreshFromLocal() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-refresh")) {
                return;
            }
            ++i;
        }
        IWorkbenchWindow window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window == null ? null : window.getShell();
        ProgressMonitorJobsDialog dlg = new ProgressMonitorJobsDialog(shell);
        final CoreException[] ex = new CoreException[1];
        try {
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        root.refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                ErrorDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("Workspace.problemsTitle"), (String)IDEWorkbenchMessages.getString("Workspace.problemMessage"), (IStatus)ex[0].getStatus());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String msg = "InvocationTargetException refreshing from local on startup";
            IDEWorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui.ide", 0, msg, e.getTargetException()));
        }
    }

    private void disconnectFromWorkspace() {
        final MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, IDEWorkbenchMessages.getString("ProblemSavingWorkbench"), null);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(null).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.getString("InternalError"), e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.getString("InternalError"), (Throwable)e));
        }
        ErrorDialog.openError(null, (String)IDEWorkbenchMessages.getString("ProblemsSavingWorkspace"), null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.getString("ProblemsSavingWorkspace"), (IStatus)status);
        }
    }

    private void checkUpdates() {
        boolean newUpdates = false;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-newUpdates")) {
                newUpdates = true;
                break;
            }
            ++i;
        }
        if (newUpdates) {
            try {
                SiteManager.handleNewChanges();
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Problem opening update manager", e.getStatus());
            }
        }
    }

    public boolean isApplicationMenu(IWorkbenchWindowConfigurer windowConfigurer, String menuID) {
        WorkbenchActionBuilder a = (WorkbenchActionBuilder)windowConfigurer.getData(ACTION_BUILDER);
        return a.isContainerMenu(menuID);
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        String perspectiveId = null;
        if (index >= 0 && this.welcomePerspectiveInfos != null && index < this.welcomePerspectiveInfos.size()) {
            perspectiveId = ((AboutInfo)this.welcomePerspectiveInfos.get(index)).getWelcomePerspectiveId();
        }
        if (perspectiveId == null) {
            perspectiveId = "org.eclipse.ui.resourcePerspective";
        }
        return perspectiveId;
    }

    private void openWelcomeEditors(IWorkbenchWindow window) {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("WELCOME_DIALOG")) {
            IProduct product = Platform.getProduct();
            if (product == null) {
                return;
            }
            AboutInfo productInfo = new AboutInfo(product);
            URL url = productInfo.getWelcomePageURL();
            if (url == null) {
                return;
            }
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("WELCOME_DIALOG", false);
            this.openWelcomeEditor(window, new WelcomeEditorInput(productInfo), null);
        } else {
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            Iterator it = this.getNewlyAddedBundleGroups().entrySet().iterator();
            while (it.hasNext()) {
                Bundle bundle;
                String pi;
                Map.Entry entry = it.next();
                String versionedId = (String)entry.getKey();
                String featureId = versionedId.substring(0, versionedId.indexOf(58));
                AboutInfo info = (AboutInfo)entry.getValue();
                if (info == null || info.getWelcomePageURL() == null) continue;
                welcomeFeatures.add(info);
                IPlatformConfiguration platformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
                IPlatformConfiguration.IFeatureEntry feature = platformConfiguration.findConfiguredFeatureEntry(featureId);
                if (feature == null || (pi = feature.getFeaturePluginIdentifier()) == null || (bundle = Platform.getBundle((String)pi)) == null) continue;
                try {
                    bundle.start();
                }
                catch (BundleException exception) {
                    IDEWorkbenchPlugin.log("Failed to load feature", exception);
                }
            }
            int wCount = this.getWorkbenchConfigurer().getWorkbench().getWorkbenchWindowCount();
            int i = 0;
            while (i < welcomeFeatures.size()) {
                AboutInfo newInfo = (AboutInfo)welcomeFeatures.get(i);
                String id = newInfo.getWelcomePerspectiveId();
                if (id == null || i >= wCount) {
                    this.openWelcomeEditor(window, new WelcomeEditorInput(newInfo), id);
                }
                ++i;
            }
        }
    }

    private Map computeBundleGroupMap() {
        TreeMap<String, AboutInfo> ids = new TreeMap<String, AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        int i = 0;
        while (i < providers.length) {
            IBundleGroup[] groups = providers[i].getBundleGroups();
            int j = 0;
            while (j < groups.length) {
                IBundleGroup group = groups[j];
                AboutInfo info = new AboutInfo(group);
                String version = info.getVersionId();
                version = version == null ? "0.0.0" : new PluginVersionIdentifier(version).toString();
                String versionedFeature = String.valueOf(group.getIdentifier()) + ":" + version;
                ids.put(versionedFeature, info);
                ++j;
            }
            ++i;
        }
        return ids;
    }

    private Map getNewlyAddedBundleGroups() {
        if (this.newlyAddedBundleGroups == null) {
            this.newlyAddedBundleGroups = this.createNewBundleGroupsMap();
        }
        return this.newlyAddedBundleGroups;
    }

    private Map createNewBundleGroupsMap() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        String[] previousFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        Map bundleGroups = this.computeBundleGroupMap();
        String[] currentFeaturesArray = new String[bundleGroups.size()];
        bundleGroups.keySet().toArray(currentFeaturesArray);
        settings.put(INSTALLED_FEATURES, currentFeaturesArray);
        if (previousFeaturesArray != null) {
            int i = 0;
            while (i < previousFeaturesArray.length) {
                bundleGroups.remove(previousFeaturesArray[i]);
                ++i;
            }
        }
        return bundleGroups;
    }

    private void openWelcomeEditor(IWorkbenchWindow window, WelcomeEditorInput input, String perspectiveId) {
        if (this.getWorkbenchConfigurer().getWorkbench().getWorkbenchWindowCount() == 0) {
            return;
        }
        IWorkbenchWindow win = window;
        if (perspectiveId != null) {
            try {
                win = this.getWorkbenchConfigurer().getWorkbench().openWorkbenchWindow(perspectiveId, this.getDefaultPageInput());
                if (win == null) {
                    win = window;
                }
            }
            catch (WorkbenchException e) {
                IDEWorkbenchPlugin.log("Error opening window with welcome perspective.", e.getStatus());
                return;
            }
        }
        if (win == null) {
            win = this.getWorkbenchConfigurer().getWorkbench().getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = win.getActivePage();
        String id = perspectiveId;
        if (id == null) {
            id = this.getWorkbenchConfigurer().getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (page == null) {
            try {
                page = win.openPage(id, this.getDefaultPageInput());
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.getString("Problems_Opening_Page"), (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            try {
                page = this.getWorkbenchConfigurer().getWorkbench().showPerspective(id, win);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogTitle"), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogMessage"), (IStatus)e.getStatus());
                return;
            }
        }
        page.setEditorAreaVisible(true);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return;
        }
        try {
            page.openEditor((IEditorInput)input, WELCOME_EDITOR_ID);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogTitle"), (String)IDEWorkbenchMessages.getString("Workbench.openEditorErrorDialogMessage"), (IStatus)e.getStatus());
        }
    }

    private void updateTitle(IWorkbenchWindow window) {
        IWorkbenchPage currentPage;
        IWorkbenchWindowConfigurer windowConfigurer = this.getWorkbenchConfigurer().getWindowConfigurer(window);
        String title = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            title = product.getName();
        }
        if (title == null) {
            title = "";
        }
        if (this.workspaceLocation != null) {
            title = IDEWorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{this.workspaceLocation, title});
        }
        if ((currentPage = window.getActivePage()) != null) {
            IAdaptable input;
            IEditorPart editor = currentPage.getActiveEditor();
            if (editor != null) {
                String editorTitle = editor.getTitle();
                title = IDEWorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{editorTitle, title});
            }
            IPerspectiveDescriptor persp = currentPage.getPerspective();
            String label = "";
            if (persp != null) {
                label = persp.getLabel();
            }
            if ((input = currentPage.getInput()) != null && !input.equals(this.getDefaultPageInput())) {
                label = currentPage.getLabel();
            }
            if (label != null && !label.equals("")) {
                title = IDEWorkbenchMessages.format("WorkbenchWindow.shellTitle", new Object[]{label, title});
            }
        }
        windowConfigurer.setTitle(title);
    }

    private void declareWorkbenchImages() {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_TOOL_NEW_WIZARD", "icons/full/etool16/new_wiz.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_TOOL_NEW_WIZARD_HOVER", "icons/full/etool16/new_wiz.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_TOOL_NEW_WIZARD_DISABLED", "icons/full/dtool16/new_wiz.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_IMPORT_WIZ", "icons/full/etool16/import_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_EXPORT_WIZ", "icons/full/etool16/export_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "icons/full/etool16/next_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "icons/full/etool16/prev_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEW_WIZ", "icons/full/wizban/new_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "icons/full/wizban/newprj_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "icons/full/wizban/newfolder_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "icons/full/wizban/newfile_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORT_WIZ", "icons/full/wizban/import_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "icons/full/wizban/importdir_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "icons/full/wizban/importzip_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORT_WIZ", "icons/full/wizban/export_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "icons/full/wizban/exportdir_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "icons/full/wizban/exportzip_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "icons/full/wizban/workset_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "icons/full/elcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "icons/full/obj16/welcome_banner.gif", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = ideBundle.getEntry(path);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer actionConfigurer, int flags) {
        WorkbenchActionBuilder actionBuilder = null;
        IWorkbenchWindowConfigurer windowConfigurer = this.getWorkbenchConfigurer().getWindowConfigurer(window);
        actionBuilder = (WorkbenchActionBuilder)windowConfigurer.getData(ACTION_BUILDER);
        if (actionBuilder == null) {
            actionBuilder = new WorkbenchActionBuilder(window);
        }
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                actionBuilder.populateMenuBar(actionConfigurer);
            }
            if ((flags & 4) != 0) {
                actionBuilder.populateCoolBar(actionConfigurer);
            }
        } else {
            windowConfigurer.setData(ACTION_BUILDER, (Object)actionBuilder);
            actionBuilder.makeAndPopulateActions(this.getWorkbenchConfigurer(), actionConfigurer);
        }
    }

    public String getMainPreferencePageId() {
        return WORKBENCH_PREFERENCE_CATEGORY_ID;
    }

    public void openIntro(IWorkbenchWindowConfigurer windowConfigurer) {
        if (this.editorsAndIntrosOpened) {
            return;
        }
        this.editorsAndIntrosOpened = true;
        if (this.hasIntro()) {
            super.openIntro(windowConfigurer);
        } else {
            this.openWelcomeEditors(windowConfigurer.getWindow());
            IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        }
    }

    private boolean hasIntro() {
        IWorkbenchConfigurer wc = this.getWorkbenchConfigurer();
        return wc == null ? false : wc.getWorkbench().getIntroManager().hasIntro();
    }

    static WorkbenchActionBuilder getActionBuilder(IWorkbenchWindow window) {
        IWorkbenchWindowConfigurer configurer = workbenchAdvisor.getWorkbenchConfigurer().getWindowConfigurer(window);
        return (WorkbenchActionBuilder)configurer.getData(ACTION_BUILDER);
    }

    public Control createEmptyWindowContents(final IWorkbenchWindowConfigurer configurer, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Display display = composite.getDisplay();
        Color bgCol = display.getSystemColor(16);
        composite.setBackground(bgCol);
        Label label = new Label(composite, 64);
        label.setForeground(display.getSystemColor(1));
        label.setBackground(bgCol);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        String msg = IDEWorkbenchMessages.getString("IDEWorkbenchAdvisor.noPerspective");
        label.setText(msg);
        ToolBarManager toolBarManager = new ToolBarManager();
        Action openPerspectiveAction = new Action(){
            {
                this.setToolTipText(IDEWorkbenchMessages.getString("IDEWorkbenchAdvisor.openPerspective"));
                this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_NEW_PAGE"));
            }

            public void run() {
                SelectPerspectiveDialog dlg = new SelectPerspectiveDialog(configurer.getWindow().getShell(), configurer.getWindow().getWorkbench().getPerspectiveRegistry());
                dlg.open();
                if (dlg.getReturnCode() == 1) {
                    return;
                }
                IPerspectiveDescriptor desc = dlg.getSelection();
                if (desc != null) {
                    try {
                        configurer.getWindow().openPage(desc.getId(), IDEWorkbenchAdvisor.this.getDefaultPageInput());
                    }
                    catch (WorkbenchException e) {
                        IDEWorkbenchPlugin.log("Error opening page", e);
                    }
                }
            }
        };
        toolBarManager.add((IAction)openPerspectiveAction);
        ToolBar toolBar = toolBarManager.createControl(composite);
        toolBar.setBackground(bgCol);
        return composite;
    }
}

