/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarOutputStream;

public class TarFileExporter
implements IFileExporter {
    private TarOutputStream outputStream;
    private GZIPOutputStream gzipOutputStream;

    public TarFileExporter(String filename, boolean compress) throws IOException {
        if (compress) {
            this.gzipOutputStream = new GZIPOutputStream(new FileOutputStream(filename));
            this.outputStream = new TarOutputStream(new BufferedOutputStream(this.gzipOutputStream));
        } else {
            this.outputStream = new TarOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        }
    }

    public void finished() throws IOException {
        this.outputStream.close();
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
        }
    }

    private void write(TarEntry entry, byte[] contents) throws IOException {
        entry.setSize(contents.length);
        this.outputStream.putNextEntry(entry);
        this.outputStream.write(contents);
        this.outputStream.closeEntry();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        InputStream contentStream;
        ByteArrayOutputStream output;
        block8: {
            output = null;
            contentStream = null;
            try {
                output = new ByteArrayOutputStream();
                contentStream = resource.getContents(false);
                int chunkSize = contentStream.available();
                byte[] readBuffer = new byte[chunkSize];
                int n = contentStream.read(readBuffer);
                while (n > 0) {
                    output.write(readBuffer);
                    n = contentStream.read(readBuffer);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (output != null) {
                    output.close();
                }
                if (contentStream != null) {
                    contentStream.close();
                }
                throw throwable;
            }
            {
                Object var8_11 = null;
                if (output == null) break block8;
            }
            output.close();
        }
        if (contentStream != null) {
            contentStream.close();
        }
        TarEntry newEntry = new TarEntry(destinationPath);
        if (resource.getLocalTimeStamp() != -1L) {
            newEntry.setTime(resource.getLocalTimeStamp() / 1000L);
        }
        this.write(newEntry, output.toByteArray());
    }
}

