/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardExportPage;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExportOperation;

public class WizardFileSystemExportPage1
extends WizardExportPage
implements Listener {
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    private Button overwriteExistingFilesCheckbox;
    private Button createDirectoryStructureCheckbox;
    private Button createDirectoriesForSelectedContainersCheckbox;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String STORE_DESTINATION_NAMES_ID = "WizardFileSystemExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardFileSystemExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardFileSystemExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String STORE_CREATE_DIRECTORIES_FOR_SPECIFIED_CONTAINER_ID = "WizardFileSystemExportPage1.STORE_CREATE_DIRECTORIES_FOR_SPECIFIED_CONTAINER_ID";

    protected WizardFileSystemExportPage1(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardFileSystemExportPage1(IStructuredSelection selection) {
        this("fileSystemExportPage1", selection);
        this.setTitle(DataTransferMessages.getString("DataTransfer.fileSystemTitle"));
        this.setDescription(DataTransferMessages.getString("FileExport.exportLocalFileSystem"));
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.giveFocusToDestination();
    }

    protected void createDestinationGroup(Composite parent) {
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        new Label(destinationSelectionGroup, 0).setText(this.getDestinationLabel());
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(DataTransferMessages.getString("DataTransfer.browse"));
        this.destinationBrowseButton.setLayoutData((Object)new GridData(256));
        this.destinationBrowseButton.addListener(13, (Listener)this);
        new Label(parent, 0);
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.overwriteExistingFilesCheckbox = new Button(optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(DataTransferMessages.getString("ExportFile.overwriteExisting"));
        this.createDirectoryStructureCheckbox = new Button(optionsGroup, 16416);
        this.createDirectoryStructureCheckbox.setText(DataTransferMessages.getString("ExportFile.createDirectoryStructure"));
        this.createDirectoryStructureCheckbox.addListener(13, (Listener)this);
        this.createDirectoriesForSelectedContainersCheckbox = new Button(optionsGroup, 16416);
        this.createDirectoriesForSelectedContainersCheckbox.setText(DataTransferMessages.getString("ExportFile.createDirectoriesForSelected"));
        this.createDirectoryStructureCheckbox.setSelection(true);
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(DataTransferMessages.getString("DataTransfer.createTargetDirectory"))) {
                return false;
            }
            if (!directory.mkdirs()) {
                this.displayErrorDialog(DataTransferMessages.getString("DataTransfer.directoryCreationError"));
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.getString("FileExport.directoryExists"));
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory);
    }

    protected boolean executeExportOperation(FileSystemExportOperation op) {
        op.setCreateContainerDirectories(this.createDirectoriesForSelectedContainersCheckbox.getSelection());
        op.setCreateLeadupStructure(this.createDirectoryStructureCheckbox.getSelection());
        op.setOverwriteFiles(this.overwriteExistingFilesCheckbox.getSelection());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException().getMessage());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.exportProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid(new File(this.getDestinationValue()))) {
            return false;
        }
        List resourcesToExport = this.getSelectedResources();
        this.saveWidgetValues();
        if (resourcesToExport.size() > 0) {
            return this.executeExportOperation(new FileSystemExportOperation(this.getSourceResource(), resourcesToExport, this.getDestinationValue(), this));
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)DataTransferMessages.getString("DataTransfer.information"), (String)DataTransferMessages.getString("FileExport.noneSelected"));
        return false;
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.getString("DataTransfer.directory");
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 8192);
        dialog.setMessage(DataTransferMessages.getString("DataTransfer.selectDestination"));
        dialog.setFilterPath(this.getDestinationValue());
        String selectedDirectoryName = dialog.open();
        if (selectedDirectoryName != null) {
            this.setDestinationValue(selectedDirectoryName);
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        super.handleEvent(e);
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureCheckbox.getSelection());
            settings.put(STORE_CREATE_DIRECTORIES_FOR_SPECIFIED_CONTAINER_ID, this.createDirectoriesForSelectedContainersCheckbox.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
            this.createDirectoryStructureCheckbox.setSelection(settings.getBoolean(STORE_CREATE_STRUCTURE_ID));
            this.createDirectoriesForSelectedContainersCheckbox.setSelection(settings.getBoolean(STORE_CREATE_DIRECTORIES_FOR_SPECIFIED_CONTAINER_ID));
        }
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected boolean validateDestinationGroup() {
        return !this.getDestinationValue().equals("");
    }
}

