/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.SelectAllAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.ui.IViewPart;

public class SelectAllBreakpointsAction
extends SelectAllAction
implements IBreakpointsListener {
    protected void update() {
        this.getAction().setEnabled(DebugPlugin.getDefault().getBreakpointManager().hasBreakpoints());
    }

    protected void doAction(Object element) {
        if (!(this.getView() instanceof BreakpointsView)) {
            return;
        }
        CheckboxTreeViewer viewer = ((BreakpointsView)this.getView()).getCheckboxViewer();
        viewer.getTree().selectAll();
        viewer.setSelection(viewer.getSelection());
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        if (this.getAction() != null && !this.getAction().isEnabled()) {
            this.update();
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.getAction() != null) {
            this.update();
        }
    }

    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        super.dispose();
    }

    protected String getActionId() {
        return IDebugView.SELECT_ALL_ACTION;
    }
}

