/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainerFactory;
import org.eclipse.debug.ui.IBreakpointContainerFactory;

public class BreakpointContainerFactoryManager {
    private static BreakpointContainerFactoryManager fgManager;
    private Map fFactories = new HashMap();

    public static BreakpointContainerFactoryManager getDefault() {
        if (fgManager == null) {
            fgManager = new BreakpointContainerFactoryManager();
        }
        return fgManager;
    }

    private BreakpointContainerFactoryManager() {
        this.loadContainerFactories();
    }

    private void loadContainerFactories() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "breakpointContainerFactories");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            BreakpointContainerFactory factory = new BreakpointContainerFactory(element);
            if (BreakpointContainerFactoryManager.validateFactory(factory)) {
                this.fFactories.put(factory.getIdentifier(), factory);
            }
            ++i;
        }
    }

    protected static boolean validateFactory(IBreakpointContainerFactory factory) {
        String id = factory.getIdentifier();
        String label = factory.getLabel();
        return id != null && id.length() > 0 && label != null && label.length() > 0;
    }

    public IBreakpointContainerFactory getFactory(String identifier) {
        return (IBreakpointContainerFactory)this.fFactories.get(identifier);
    }

    public IBreakpointContainerFactory[] getFactories() {
        return this.fFactories.values().toArray(new IBreakpointContainerFactory[0]);
    }
}

