/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointGroupContainer;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.debug.ui.IBreakpointContainerFactoryDelegate;

public class BreakpointGroupContainerFactoryDelegate
implements IBreakpointContainerFactoryDelegate {
    public IBreakpointContainer[] createContainers(IBreakpoint[] breakpoints, IBreakpointContainerFactory factory) {
        HashMap<String, ArrayList<IBreakpoint>> map = new HashMap<String, ArrayList<IBreakpoint>>();
        ArrayList<IBreakpoint> other = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            String group = null;
            try {
                group = breakpoint.getGroup();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            if (group != null) {
                ArrayList<IBreakpoint> list = (ArrayList<IBreakpoint>)map.get(group);
                if (list == null) {
                    list = new ArrayList<IBreakpoint>();
                    map.put(group, list);
                }
                list.add(breakpoint);
            } else {
                other.add(breakpoint);
            }
            ++i;
        }
        ArrayList<BreakpointGroupContainer> containers = new ArrayList<BreakpointGroupContainer>(map.size());
        Set groups = map.keySet();
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            String group = (String)iter.next();
            List list = (List)map.get(group);
            BreakpointGroupContainer container = new BreakpointGroupContainer(list.toArray(new IBreakpoint[0]), factory, group);
            containers.add(container);
        }
        if (other.size() > 0) {
            BreakpointGroupContainer container = new BreakpointGroupContainer(other.toArray(new IBreakpoint[0]), factory, DebugUIViewsMessages.getString("BreakpointGroupContainerFactory.0"));
            containers.add(container);
        }
        return containers.toArray(new IBreakpointContainer[containers.size()]);
    }

    public void dispose() {
    }
}

