/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.OpenBreakpointMarkerAction;
import org.eclipse.debug.internal.ui.actions.ShowSupportedBreakpointsAction;
import org.eclipse.debug.internal.ui.actions.SkipAllBreakpointsAction;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainerFactoryManager;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsSorter;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewContentProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewEventHandler;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IBreakpointContainer;
import org.eclipse.debug.ui.IBreakpointContainerFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.XMLMemento;

public class BreakpointsView
extends AbstractDebugView
implements ISelectionListener,
IBreakpointManagerListener,
IPerspectiveListener2 {
    private BreakpointsViewEventHandler fEventHandler;
    private ICheckStateListener fCheckListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            BreakpointsView.this.handleCheckStateChanged(event);
        }
    };
    private boolean fIsTrackingSelection = false;
    private static String KEY_IS_TRACKING_SELECTION = "isTrackingSelection";
    private static String KEY_BREAKPOINT_CONTAINER_FACTORIES = "breakpointContainerFactories";
    private static String KEY_VALUE = "value";
    private BreakpointsViewContentProvider fContentProvider;
    private static IMemento fgMemento;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.getSite().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    protected Viewer createViewer(Composite parent) {
        this.fContentProvider = new BreakpointsViewContentProvider();
        final CheckboxTreeViewer viewer = new CheckboxTreeViewer(new Tree(parent, 802)){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void refresh() {
                this.getControl().setRedraw(false);
                try {
                    BreakpointsViewContentProvider provider = (BreakpointsViewContentProvider)this.getContentProvider();
                    ArrayList<IBreakpoint> expanded = new ArrayList<IBreakpoint>();
                    IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                    int i = 0;
                    while (true) {
                        if (i >= breakpoints.length) break;
                        if (this.isFullyExpanded(breakpoints[i], provider)) {
                            expanded.add(breakpoints[i]);
                        }
                        ++i;
                    }
                    provider.recomputeContent();
                    super.refresh();
                    Iterator iter = expanded.iterator();
                    while (true) {
                        block6: {
                            if (iter.hasNext()) break block6;
                            BreakpointsView.this.initializeCheckedState(this, BreakpointsView.this.fContentProvider);
                            BreakpointsView.this.updateViewerBackground((TreeViewer)this);
                            break;
                        }
                        this.expandToLevel(iter.next(), -1);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.getControl().setRedraw(true);
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                }
                this.getControl().setRedraw(true);
            }

            private boolean isFullyExpanded(Object element, ITreeContentProvider provider) {
                Object elementParent = provider.getParent(element);
                if (elementParent == null || elementParent == this.getRoot()) {
                    if (element instanceof IBreakpoint) {
                        return true;
                    }
                    return this.getExpandedState(element);
                }
                boolean parentExpanded = this.getExpandedState(elementParent);
                if (!parentExpanded) {
                    return false;
                }
                return this.isFullyExpanded(elementParent, provider);
            }
        };
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setSorter((ViewerSorter)new BreakpointsSorter());
        viewer.setInput((Object)DebugPlugin.getDefault().getBreakpointManager());
        viewer.addCheckStateListener(this.fCheckListener);
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                BreakpointsView.this.initializeCheckedState(viewer, BreakpointsView.this.fContentProvider);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingModelPresentation(){

            public Image getImage(Object item) {
                if (item instanceof IBreakpointContainer) {
                    Image image = ((IBreakpointContainer)item).getContainerImage();
                    if (image == null) {
                        image = DebugPluginImages.getImage("IMG_OBJS_BREAKPOINT_GROUP");
                    }
                    return image;
                }
                return super.getImage(item);
            }

            public String getText(Object item) {
                if (item instanceof IBreakpointContainer) {
                    IBreakpointContainer container = (IBreakpointContainer)item;
                    return container.getName();
                }
                return super.getText(item);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.initIsTrackingSelection();
        this.initBreakpointContainerFactories();
        this.setEventHandler(new BreakpointsViewEventHandler(this));
        return viewer;
    }

    private void initIsTrackingSelection() {
        IMemento node;
        IMemento memento = this.getMemento();
        if (memento != null && (node = memento.getChild(KEY_IS_TRACKING_SELECTION)) != null) {
            this.setTrackSelection(Boolean.valueOf(node.getString(KEY_VALUE)));
            return;
        }
        this.setTrackSelection(false);
    }

    private void initBreakpointContainerFactories() {
        IMemento node;
        IMemento memento = this.getMemento();
        if (memento != null && (node = memento.getChild(KEY_BREAKPOINT_CONTAINER_FACTORIES)) != null) {
            String factoryIds = node.getString(KEY_VALUE);
            BreakpointContainerFactoryManager manager = BreakpointContainerFactoryManager.getDefault();
            ArrayList<IBreakpointContainerFactory> factories = new ArrayList<IBreakpointContainerFactory>();
            int start = 0;
            int index = factoryIds.indexOf(44);
            while (index != -1 && start < factoryIds.length() - 1) {
                IBreakpointContainerFactory factory;
                String factoryId = factoryIds.substring(start, index);
                if (factoryId.length() > 0 && (factory = manager.getFactory(factoryId)) != null) {
                    factories.add(factory);
                }
                start = index + 1;
                index = factoryIds.indexOf(44, start);
            }
            this.fContentProvider.setBreakpointContainerFactories(factories);
        }
    }

    protected IMemento getMemento() {
        if (fgMemento != null) {
            return fgMemento;
        }
        return super.getMemento();
    }

    public void initializeCheckedState(CheckboxTreeViewer viewer, ITreeContentProvider provider) {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        Object[] elements = provider.getElements((Object)manager);
        int i = 0;
        while (i < elements.length) {
            this.updateCheckedState(elements[i], viewer, provider);
            ++i;
        }
    }

    public void updateCheckedState(Object element, CheckboxTreeViewer viewer, ITreeContentProvider provider) {
        if (element instanceof IBreakpoint) {
            try {
                viewer.setChecked(element, ((IBreakpoint)element).isEnabled());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        } else if (element instanceof IBreakpointContainer) {
            IBreakpoint[] breakpoints = ((IBreakpointContainer)element).getBreakpoints();
            int enabledChildren = 0;
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                try {
                    if (breakpoint.isEnabled()) {
                        ++enabledChildren;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                ++i;
            }
            if (enabledChildren == 0) {
                viewer.setGrayChecked(element, false);
            } else if (enabledChildren == breakpoints.length) {
                viewer.setGrayed(element, false);
                viewer.setChecked(element, true);
            } else {
                viewer.setGrayChecked(element, true);
            }
            Object[] children = provider.getChildren(element);
            int i2 = 0;
            while (i2 < children.length) {
                this.updateCheckedState(children[i2], viewer, provider);
                ++i2;
            }
        }
    }

    protected void updateGroupCheckedState(String group) {
        ITreeContentProvider provider = this.getTreeContentProvider();
        CheckboxTreeViewer viewer = this.getCheckboxViewer();
        Object[] children = provider.getChildren((Object)group);
        int enabledChildren = 0;
        int i = 0;
        while (i < children.length) {
            try {
                if (((IBreakpoint)children[i]).isEnabled()) {
                    ++enabledChildren;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++i;
        }
        if (enabledChildren == 0) {
            viewer.setGrayChecked((Object)group, false);
        } else if (enabledChildren == children.length) {
            viewer.setGrayed((Object)group, false);
            viewer.setChecked((Object)group, true);
        } else {
            viewer.setGrayChecked((Object)group, true);
        }
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            viewer.setGrayed((Object)group, true);
        }
    }

    public CheckboxTreeViewer getCheckboxViewer() {
        return (CheckboxTreeViewer)this.getViewer();
    }

    public ITreeContentProvider getTreeContentProvider() {
        return (ITreeContentProvider)this.getCheckboxViewer().getContentProvider();
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        Object source = event.getElement();
        if (source instanceof IBreakpointContainer) {
            this.handleContainerChecked(event, (IBreakpointContainer)source);
        } else if (source instanceof IBreakpoint) {
            this.handleBreakpointChecked(event, (IBreakpoint)source);
        }
    }

    private void handleBreakpointChecked(CheckStateChangedEvent event, IBreakpoint breakpoint) {
        boolean enable = event.getChecked();
        CheckboxTreeViewer viewer = this.getCheckboxViewer();
        try {
            breakpoint.setEnabled(enable);
            viewer.update((Object)breakpoint, null);
            this.updateParents(breakpoint, enable);
        }
        catch (CoreException e) {
            String titleState = enable ? DebugUIViewsMessages.getString("BreakpointsView.6") : DebugUIViewsMessages.getString("BreakpointsView.7");
            String messageState = enable ? DebugUIViewsMessages.getString("BreakpointsView.8") : DebugUIViewsMessages.getString("BreakpointsView.9");
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), MessageFormat.format(DebugUIViewsMessages.getString("BreakpointsView.10"), titleState), MessageFormat.format(DebugUIViewsMessages.getString("BreakpointsView.11"), messageState), e);
            this.getCheckboxViewer().removeCheckStateListener(this.fCheckListener);
            event.getCheckable().setChecked((Object)breakpoint, !event.getChecked());
            this.getCheckboxViewer().addCheckStateListener(this.fCheckListener);
        }
    }

    public void updateParents(Object object, boolean enable) {
        Object parent = this.getTreeContentProvider().getParent(object);
        if (!(parent instanceof IBreakpointContainer)) {
            return;
        }
        CheckboxTreeViewer viewer = this.getCheckboxViewer();
        IBreakpointContainer container = (IBreakpointContainer)parent;
        if (DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            viewer.setGrayed((Object)container, false);
        }
        viewer.setChecked((Object)container, enable);
        IBreakpoint[] breakpoints = container.getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            try {
                if (breakpoints[i].isEnabled() != enable) {
                    viewer.setGrayChecked((Object)container, true);
                    break;
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        this.updateParents(parent, enable);
    }

    public void updateChildren(IBreakpointContainer container, boolean enabled) {
        IBreakpointContainer[] children = container.getContainers();
        int i = 0;
        while (i < children.length) {
            IBreakpointContainer childContainer = children[i];
            CheckboxTreeViewer viewer = this.getCheckboxViewer();
            viewer.setChecked((Object)childContainer, enabled);
            this.updateChildren(childContainer, enabled);
            ++i;
        }
    }

    private void handleContainerChecked(CheckStateChangedEvent event, IBreakpointContainer container) {
        CheckboxTreeViewer viewer = this.getCheckboxViewer();
        IBreakpoint[] breakpoints = container.getBreakpoints();
        boolean enable = event.getChecked();
        viewer.setGrayed((Object)container, false);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this.getEventHandler());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            try {
                viewer.setChecked((Object)breakpoint, enable);
                breakpoint.setEnabled(enable);
                viewer.update((Object)breakpoint, null);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++i;
        }
        this.updateParents(container, enable);
        this.updateChildren(container, enable);
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            viewer.setGrayed((Object)container, true);
        }
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this.getEventHandler());
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.BREAKPOINT_VIEW;
    }

    public void dispose() {
        IAction action;
        if (this.getCheckboxViewer() != null) {
            this.getCheckboxViewer().removeCheckStateListener(this.fCheckListener);
        }
        if ((action = this.getAction("ShowBreakpointsForModel")) != null) {
            ((ShowSupportedBreakpointsAction)action).dispose();
        }
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        super.dispose();
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
    }

    protected void createActions() {
        OpenBreakpointMarkerAction action = new OpenBreakpointMarkerAction((ISelectionProvider)this.getViewer());
        this.setAction("GotoMarker", (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        this.setAction("ShowBreakpointsForModel", (IAction)new ShowSupportedBreakpointsAction(this.getStructuredViewer(), this));
        this.setAction("SkipBreakpoints", (IAction)new SkipAllBreakpointsAction());
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.updateObjects();
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("navigationGroup"));
        menu.add(this.getAction("GotoMarker"));
        menu.add((IContributionItem)new Separator("emptyBreakpointGroup"));
        menu.add((IContributionItem)new Separator("breakpointGroup"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("selectGroup"));
        menu.add((IContributionItem)new Separator("breakpointGroupGroup"));
        menu.add((IContributionItem)new Separator("removeGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("breakpointGroup"));
        tbm.add(this.getAction("ShowBreakpointsForModel"));
        tbm.add(this.getAction("GotoMarker"));
        tbm.add(this.getAction("SkipBreakpoints"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    protected BreakpointsViewEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    private void setEventHandler(BreakpointsViewEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.getViewer().refresh();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (sel.isEmpty() || !this.isTrackingSelection()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Iterator iter = selection.iterator();
        Object firstElement = iter.next();
        if (firstElement == null || iter.hasNext()) {
            return;
        }
        IThread thread = null;
        if (firstElement instanceof IStackFrame) {
            thread = ((IStackFrame)firstElement).getThread();
        } else if (firstElement instanceof IThread) {
            thread = (IThread)firstElement;
        } else {
            return;
        }
        Object[] breakpoints = thread.getBreakpoints();
        this.getViewer().setSelection((ISelection)new StructuredSelection(breakpoints), true);
    }

    public boolean isTrackingSelection() {
        return this.fIsTrackingSelection;
    }

    public void setTrackSelection(boolean trackSelection) {
        this.fIsTrackingSelection = trackSelection;
        if (trackSelection) {
            this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        } else {
            this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento node = memento.createChild(KEY_IS_TRACKING_SELECTION);
        node.putString(KEY_VALUE, String.valueOf(this.fIsTrackingSelection));
        StringBuffer buffer = new StringBuffer();
        List breakpointContainerFactories = this.getBreakpointContainerFactories();
        Iterator iter = breakpointContainerFactories.iterator();
        while (iter.hasNext()) {
            IBreakpointContainerFactory factory = (IBreakpointContainerFactory)iter.next();
            buffer.append(factory.getIdentifier()).append(',');
        }
        node = memento.createChild(KEY_BREAKPOINT_CONTAINER_FACTORIES);
        node.putString(KEY_VALUE, buffer.toString());
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IAction action = BreakpointsView.this.getAction("SkipBreakpoints");
                if (action != null) {
                    ((SkipAllBreakpointsAction)action).updateActionCheckedState();
                }
                BreakpointsView.this.updateViewerBackground((TreeViewer)BreakpointsView.this.getCheckboxViewer());
            }
        });
    }

    protected void updateViewerBackground(TreeViewer viewer) {
        Color color = null;
        boolean enabled = true;
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            color = DebugUIPlugin.getStandardDisplay().getSystemColor(29);
            enabled = false;
        }
        Tree tree = viewer.getTree();
        this.updateTreeItems(tree.getItems(), color, !enabled);
        tree.setBackground(color);
        if (enabled) {
            this.setContentDescription("");
        } else {
            this.setContentDescription(DebugUIViewsMessages.getString("BreakpointsView.19"));
        }
    }

    private void updateTreeItems(TreeItem[] items, Color color, boolean gray) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            item.setBackground(color);
            item.setGrayed(gray);
            this.updateTreeItems(item.getItems(), color, gray);
            ++i;
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof IBreakpointContainer) {
            this.getCheckboxViewer().setExpandedState(element, !this.getCheckboxViewer().getExpandedState(element));
            return;
        }
        super.doubleClick(event);
    }

    public void setBreakpointContainerFactories(List selectedContainers) {
        this.fContentProvider.setBreakpointContainerFactories(selectedContainers);
        Viewer viewer = this.getViewer();
        viewer.refresh();
        viewer.setSelection(viewer.getSelection());
    }

    public List getBreakpointContainerFactories() {
        return this.fContentProvider.getBreakpointContainerFactories();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        String id;
        if (partRef instanceof IViewReference && changeId.equals("viewHide") && (id = ((IViewReference)partRef).getId()).equals(this.getViewSite().getId())) {
            fgMemento = XMLMemento.createWriteRoot((String)"BreakpointsViewMemento");
            this.saveState(fgMemento);
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

