/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.debug.ui.console.IConsoleLineTrackerExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;

public class ConsoleLineNotifier
implements IPatternMatchListener,
IPropertyChangeListener {
    private ListenerList fListeners = new ListenerList(2);
    private ProcessConsole fConsole = null;

    public void connect(IConsole console) {
        if (console instanceof ProcessConsole) {
            this.fConsole = (ProcessConsole)console;
            IConsoleLineTracker[] lineTrackers = DebugUIPlugin.getDefault().getProcessConsoleManager().getLineTrackers(this.fConsole.getProcess());
            int i = 0;
            while (i < lineTrackers.length) {
                lineTrackers[i].init(this.fConsole);
                this.addConsoleListener(lineTrackers[i]);
                ++i;
            }
            this.fConsole.addPropertyChangeListener(this);
        }
    }

    public synchronized void disconnect() {
        if (this.fConsole == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
            listener.dispose();
            ++i;
        }
        this.fConsole.removePropertyChangeListener(this);
        this.fListeners = null;
        this.fConsole = null;
    }

    public synchronized void streamsClosed() {
        try {
            int lastLine;
            IDocument document;
            if (this.fConsole != null && (document = this.fConsole.getDocument()) != null && document.getLineDelimiter(lastLine = document.getNumberOfLines() - 1) == null) {
                IRegion lineInformation = document.getLineInformation(lastLine);
                this.lineAppended(lineInformation);
            }
        }
        catch (BadLocationException badLocationException) {}
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            Object obj = listeners[i];
            if (obj instanceof IConsoleLineTrackerExtension) {
                ((IConsoleLineTrackerExtension)obj).consoleClosed();
            }
            ++i;
        }
    }

    public void addConsoleListener(IConsoleLineTracker listener) {
        this.fListeners.add((Object)listener);
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            IDocument document = this.fConsole.getDocument();
            String text = document.get(event.getOffset(), event.getLength());
            int strip = 1;
            int length = text.length();
            if (length >= 2) {
                char c = text.charAt(length - 2);
                if (c == '\r') {
                    strip = 2;
                }
                text = text.substring(0, length - strip);
            } else {
                text = "";
            }
            Region region = new Region(event.getOffset(), text.length());
            this.lineAppended((IRegion)region);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void lineAppended(IRegion region) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
            listener.lineAppended(region);
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
            this.streamsClosed();
        }
    }

    public String getPattern() {
        return ".*\\r(\\n?)|.*\\n";
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return null;
    }
}

