/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.RemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleRemoveAllTerminatedAction
extends Action
implements IUpdate,
IDebugEventSetListener,
ILaunchesListener {
    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (event.getKind() == 8 && (source instanceof IDebugTarget || source instanceof IProcess)) {
                DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ConsoleRemoveAllTerminatedAction.this.update();
                    }
                });
            }
            ++i;
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void update() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.isTerminated()) {
                this.setEnabled(true);
                return;
            }
            ++i;
        }
        this.setEnabled(false);
    }

    public void run() {
        Object[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        RemoveAllTerminatedAction.removeTerminatedLaunches(launches);
    }

    public ConsoleRemoveAllTerminatedAction() {
        super(ConsoleMessages.getString("ConsoleRemoveAllTerminatedAction.0"));
        this.setToolTipText(ConsoleMessages.getString("ConsoleRemoveAllTerminatedAction.1"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_ALL"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_ALL"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_ALL"));
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        this.update();
    }

    public void launchesRemoved(ILaunch[] launches) {
        if (this.isEnabled()) {
            this.update();
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }
}

