/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.TabItem;

public abstract class AbstractMemoryViewTab
implements IMemoryViewTab {
    protected IMemoryBlock fMemoryBlock;
    protected TabItem fTabItem;
    protected MenuManager fMenuMgr;
    protected IMemoryRendering fRendering;

    public AbstractMemoryViewTab(IMemoryBlock newMemory, TabItem newTab, MenuManager menuMgr, IMemoryRendering rendering) {
        this.fMemoryBlock = newMemory;
        this.fTabItem = newTab;
        this.fMenuMgr = menuMgr;
        this.fRendering = rendering;
        this.fTabItem.setData((Object)this);
        this.maintainRefAndEnablement(true);
    }

    public void setEnabled(boolean enabled) {
        this.maintainRefAndEnablement(enabled);
    }

    protected void maintainRefAndEnablement(boolean addReference) {
        if (addReference) {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                ((IMemoryBlockExtension)this.getMemoryBlock()).connect((Object)this);
            }
        } else if (!addReference && this.getMemoryBlock() instanceof IMemoryBlockExtension && this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            ((IMemoryBlockExtension)this.getMemoryBlock()).disconnect((Object)this);
        }
    }

    public void dispose() {
        this.maintainRefAndEnablement(false);
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    public String getRenderingId() {
        return this.fRendering.getRenderingId();
    }

    public IMemoryRendering getRendering() {
        return this.fRendering;
    }
}

