/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.IFixedLengthOutputRenderer;

public abstract class AbstractTextRenderer
extends AbstractMemoryRenderer
implements IFixedLengthOutputRenderer {
    String fCodePage;

    public void setCodePage(String codePage) {
        this.fCodePage = codePage;
    }

    public String getString(String dataType, BigInteger address, MemoryByte[] data, String paddedStr) {
        try {
            if (this.fCodePage == null) {
                return "";
            }
            boolean invalid = false;
            int i = 0;
            while (i < data.length) {
                if (!data[i].isValid()) {
                    invalid = true;
                    break;
                }
                ++i;
            }
            if (invalid) {
                StringBuffer strBuf = new StringBuffer();
                int i2 = 0;
                while (i2 < data.length) {
                    strBuf.append(paddedStr);
                    ++i2;
                }
                return strBuf.toString();
            }
            byte[] byteArray = new byte[data.length];
            int i3 = 0;
            while (i3 < byteArray.length) {
                byteArray[i3] = data[i3].getValue();
                ++i3;
            }
            return new String(byteArray, this.fCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "-- error --";
        }
    }

    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        try {
            if (this.fCodePage == null) {
                return new byte[0];
            }
            byte[] bytes = data.getBytes(this.fCodePage);
            return bytes;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    protected class RendererMemoryByte
    extends MemoryByte {
        protected RendererMemoryByte() {
        }
    }
}

