/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.BasicDebugViewContentProvider;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneSelectionProvider;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class MemoryBlocksTreeViewPane
implements ISelectionListener,
IMemoryViewPane {
    public static final String PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.MemoryBlocksTreeViewPane";
    private IViewPart fParent;
    private TreeViewer fTreeViewer;
    private MemoryBlocksViewerContentProvider fContentProvider;
    protected IDebugTarget fDebugTarget;
    private ViewPaneSelectionProvider fSelectionProvider;
    private AddMemoryBlockAction fAddMemoryBlockAction;
    private IAction fRemoveMemoryBlockAction;
    private Hashtable fTargetMemoryBlockMap = new Hashtable();
    private String fPaneId;
    private boolean fVisible = true;
    private ArrayList fMemoryBlocks = new ArrayList();

    public MemoryBlocksTreeViewPane(IViewPart parent) {
        this.fParent = parent;
        this.fSelectionProvider = new ViewPaneSelectionProvider();
    }

    public Control createViewPane(Composite parent, String paneId) {
        this.fPaneId = paneId;
        this.fTreeViewer = new TreeViewer(parent);
        this.fContentProvider = new MemoryBlocksViewerContentProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new MemoryBlocksViewerLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object mem;
                ISelection treeSelected = event.getSelection();
                MemoryBlocksTreeViewPane.this.fSelectionProvider.setSelection(treeSelected);
                if (treeSelected instanceof IStructuredSelection && (mem = ((IStructuredSelection)treeSelected).getFirstElement()) != null) {
                    MemoryBlocksTreeViewPane.this.fTargetMemoryBlockMap.put(MemoryBlocksTreeViewPane.this.fDebugTarget, mem);
                }
            }
        });
        this.populateViewPane();
        MenuManager mgr = this.createContextMenuManager();
        Menu menu = mgr.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(this.fDebugTarget);
        if (memoryBlocks.length > 0) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)memoryBlocks[0]));
        }
        this.maintainMemoryBlocksReference(this.fVisible);
        return this.fTreeViewer.getControl();
    }

    private void maintainMemoryBlocksReference(boolean add) {
        if (this.fMemoryBlocks == null) {
            return;
        }
        IMemoryBlock[] memoryBlocks = this.fMemoryBlocks.toArray(new IMemoryBlock[this.fMemoryBlocks.size()]);
        if (add) {
            int i = 0;
            while (i < memoryBlocks.length) {
                if (memoryBlocks[i] instanceof IMemoryBlockExtension) {
                    ((IMemoryBlockExtension)memoryBlocks[i]).connect((Object)this);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < memoryBlocks.length) {
                if (memoryBlocks[i] instanceof IMemoryBlockExtension) {
                    ((IMemoryBlockExtension)memoryBlocks[i]).disconnect((Object)this);
                }
                ++i;
            }
        }
    }

    private void populateViewPane() {
        Object obj;
        ISelection selected = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        if (selected instanceof IStructuredSelection && (obj = ((IStructuredSelection)selected).getFirstElement()) instanceof IDebugElement) {
            this.fTreeViewer.setInput((Object)((IDebugElement)obj).getDebugTarget());
        }
    }

    protected MenuManager createContextMenuManager() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)MemoryBlocksTreeViewPane.this.fAddMemoryBlockAction);
                manager.add(MemoryBlocksTreeViewPane.this.fRemoveMemoryBlockAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.fParent.getSite().registerContextMenu(this.getPaneId(), menuMgr, (ISelectionProvider)this.fSelectionProvider);
        return menuMgr;
    }

    public void dispose() {
        this.maintainMemoryBlocksReference(false);
        this.fMemoryBlocks.clear();
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fContentProvider.dispose();
        this.fAddMemoryBlockAction.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget debugTarget;
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IDebugElement && (debugTarget = ((IDebugElement)obj).getDebugTarget()) != null && this.fTreeViewer != null && this.fDebugTarget != debugTarget) {
            IMemoryBlock[] memBlks;
            this.fTreeViewer.setInput((Object)debugTarget);
            Object selectedObj = this.fTargetMemoryBlockMap.get(debugTarget);
            if (selectedObj == null && (memBlks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(debugTarget)).length > 0) {
                selectedObj = memBlks[0];
            }
            if (selectedObj != null) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(selectedObj));
            }
        }
    }

    public String getPaneId() {
        return this.fPaneId;
    }

    public IAction[] getActions() {
        if (this.fAddMemoryBlockAction == null) {
            this.fAddMemoryBlockAction = new AddMemoryBlockAction(this);
        }
        if (this.fRemoveMemoryBlockAction == null) {
            this.fRemoveMemoryBlockAction = new TreeViewerRemoveMemoryBlocksAction();
        }
        this.updateActionsEnablement();
        return new IAction[]{this.fAddMemoryBlockAction, this.fRemoveMemoryBlockAction};
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            this.fSelectionProvider = new ViewPaneSelectionProvider();
        }
        this.fSelectionProvider.addSelectionChangedListener(listener);
    }

    public void removeSelctionListener(ISelectionChangedListener listener) {
        if (this.fSelectionProvider == null) {
            return;
        }
        this.fSelectionProvider.removeSelectionChangedListener(listener);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    private IMemoryViewPane getInstance() {
        return this;
    }

    public void restoreViewPane() {
        this.populateViewPane();
        this.updateActionsEnablement();
    }

    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    public void setVisible(boolean visible) {
        if (this.fVisible != visible) {
            this.fVisible = visible;
            if (this.fVisible) {
                this.fTreeViewer.refresh();
            }
            this.maintainMemoryBlocksReference(this.fVisible);
        }
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    private void updateActionsEnablement() {
        if (this.fRemoveMemoryBlockAction == null) {
            return;
        }
        if (this.fMemoryBlocks == null) {
            return;
        }
        if (this.fMemoryBlocks.size() > 0) {
            this.fRemoveMemoryBlockAction.setEnabled(true);
        } else {
            this.fRemoveMemoryBlockAction.setEnabled(false);
        }
    }

    class TreeViewerRemoveMemoryBlocksAction
    extends Action {
        TreeViewerRemoveMemoryBlocksAction() {
            this.setText(DebugUIMessages.getString("RemoveMemoryBlockAction.title"));
            this.setToolTipText(DebugUIMessages.getString("RemoveMemoryBlockAction.tooltip"));
            this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_MEMORY"));
            this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_MEMORY"));
            this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_MEMORY"));
            WorkbenchHelp.setHelp((IAction)this, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".RemoveMemoryBlockAction_context"));
            this.setEnabled(true);
        }

        public void run() {
            Object selectedObj;
            ISelection selected = MemoryBlocksTreeViewPane.this.fTreeViewer.getSelection();
            if (selected != null && selected instanceof IStructuredSelection && (selectedObj = ((IStructuredSelection)selected).getFirstElement()) != null && selectedObj instanceof IMemoryBlock) {
                DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(new IMemoryBlock[]{(IMemoryBlock)selectedObj});
            }
        }
    }

    class MemoryBlocksViewerContentProvider
    extends BasicDebugViewContentProvider
    implements IMemoryBlockListener,
    ITreeContentProvider {
        public MemoryBlocksViewerContentProvider() {
            DebugPlugin.getDefault().getMemoryBlockManager().addListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != MemoryBlocksTreeViewPane.this.fDebugTarget && newInput instanceof IDebugTarget) {
                MemoryBlocksTreeViewPane.this.fDebugTarget = (IDebugTarget)newInput;
                MemoryBlocksTreeViewPane.this.maintainMemoryBlocksReference(false);
                MemoryBlocksTreeViewPane.this.fMemoryBlocks.clear();
                this.getMemoryBlocks();
                MemoryBlocksTreeViewPane.this.updateActionsEnablement();
            }
            super.inputChanged(viewer, oldInput, newInput);
        }

        private void getMemoryBlocks() {
            if (MemoryBlocksTreeViewPane.this.fDebugTarget == null) {
                return;
            }
            IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(MemoryBlocksTreeViewPane.this.fDebugTarget);
            int i = 0;
            while (i < memoryBlocks.length) {
                if (!MemoryBlocksTreeViewPane.this.fMemoryBlocks.contains(memoryBlocks[i])) {
                    MemoryBlocksTreeViewPane.this.fMemoryBlocks.add(memoryBlocks[i]);
                    if (memoryBlocks[i] instanceof IMemoryBlockExtension && MemoryBlocksTreeViewPane.this.fVisible) {
                        ((IMemoryBlockExtension)memoryBlocks[i]).connect((Object)MemoryBlocksTreeViewPane.this.getInstance());
                    }
                }
                ++i;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IDebugTarget) {
                MemoryBlocksTreeViewPane.this.fDebugTarget = (IDebugTarget)inputElement;
                return MemoryBlocksTreeViewPane.this.fMemoryBlocks.toArray(new IMemoryBlock[MemoryBlocksTreeViewPane.this.fMemoryBlocks.size()]);
            }
            return new Object[]{inputElement};
        }

        public void dispose() {
            super.dispose();
            DebugPlugin.getDefault().getMemoryBlockManager().removeListener((IMemoryBlockListener)this);
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            IMemoryBlock[] memoryBlocks = memory;
            int i = 0;
            while (i < memoryBlocks.length) {
                if (!MemoryBlocksTreeViewPane.this.fMemoryBlocks.contains(memoryBlocks[i])) {
                    MemoryBlocksTreeViewPane.this.fMemoryBlocks.add(memoryBlocks[i]);
                    if (memoryBlocks[i] instanceof IMemoryBlockExtension && MemoryBlocksTreeViewPane.this.fVisible) {
                        ((IMemoryBlockExtension)memoryBlocks[i]).connect((Object)MemoryBlocksTreeViewPane.this.getInstance());
                    }
                }
                ++i;
            }
            MemoryBlocksTreeViewPane.this.fTreeViewer.refresh();
            MemoryBlocksTreeViewPane.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object[])memory));
            MemoryBlocksTreeViewPane.this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object[])memory));
            MemoryBlocksTreeViewPane.this.updateActionsEnablement();
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
            DebugUIPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(this, memory){
                final /* synthetic */ MemoryBlocksViewerContentProvider this$1;
                private final /* synthetic */ IMemoryBlock[] val$memory;
                {
                    this.this$1 = memoryBlocksViewerContentProvider;
                    this.val$memory = iMemoryBlockArray;
                }

                public void run() {
                    int i = 0;
                    while (i < this.val$memory.length) {
                        if (this.val$memory[i] instanceof IMemoryBlockExtension) {
                            ((IMemoryBlockExtension)this.val$memory[i]).disconnect((Object)MemoryBlocksTreeViewPane.access$5(MemoryBlocksViewerContentProvider.access$0(this.this$1)));
                        }
                        MemoryBlocksTreeViewPane.access$2(MemoryBlocksViewerContentProvider.access$0(this.this$1)).remove(this.val$memory[i]);
                        ++i;
                    }
                    MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$0(this.this$1)).refresh();
                    IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(MemoryBlocksViewerContentProvider.access$0((MemoryBlocksViewerContentProvider)this.this$1).fDebugTarget);
                    if (memoryBlocks != null && memoryBlocks.length > 0) {
                        MemoryBlocksTreeViewPane.access$0(MemoryBlocksViewerContentProvider.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)memoryBlocks[0]));
                    }
                    MemoryBlocksTreeViewPane.access$3(MemoryBlocksViewerContentProvider.access$0(this.this$1));
                }
            });
        }

        protected void doHandleDebugEvent(DebugEvent event) {
            IDebugElement elem;
            if (event.getKind() == 8) {
                if (event.getSource() == MemoryBlocksTreeViewPane.this.fDebugTarget) {
                    MemoryBlocksTreeViewPane.this.fTreeViewer.setInput(null);
                } else if (event.getSource() instanceof IDebugTarget) {
                    IDebugTarget target = (IDebugTarget)event.getSource();
                    MemoryBlocksTreeViewPane.this.fTargetMemoryBlockMap.remove(target);
                }
            } else if (event.getKind() == 2 && event.getSource() instanceof IDebugElement && (elem = (IDebugElement)event.getSource()).getDebugTarget() == MemoryBlocksTreeViewPane.this.fDebugTarget && MemoryBlocksTreeViewPane.this.fVisible) {
                MemoryBlocksTreeViewPane.this.fTreeViewer.refresh();
            }
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IDebugTarget) {
                return null;
            }
            return MemoryBlocksTreeViewPane.this.fDebugTarget;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IDebugTarget;
        }

        static /* synthetic */ MemoryBlocksTreeViewPane access$0(MemoryBlocksViewerContentProvider memoryBlocksViewerContentProvider) {
            return memoryBlocksViewerContentProvider.MemoryBlocksTreeViewPane.this;
        }
    }

    class MemoryBlocksViewerLabelProvider
    extends LabelProvider {
        MemoryBlocksViewerLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IMemoryBlock) {
                return DebugPluginImages.getImage("IMG_OBJS_VARIABLE");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IMemoryBlock) {
                return this.getLabel((IMemoryBlock)element);
            }
            return element.toString();
        }

        private String getLabel(IMemoryBlock memoryBlock) {
            String memoryBlockLabel = " ";
            if (memoryBlock instanceof IMemoryBlockExtension) {
                try {
                    if (((IMemoryBlockExtension)memoryBlock).getExpression() != null) {
                        memoryBlockLabel = String.valueOf(memoryBlockLabel) + ((IMemoryBlockExtension)memoryBlock).getExpression();
                    }
                    if (((IMemoryBlockExtension)memoryBlock).getBigBaseAddress() != null) {
                        memoryBlockLabel = String.valueOf(memoryBlockLabel) + " = 0x" + ((IMemoryBlockExtension)memoryBlock).getBigBaseAddress().toString(16);
                    }
                }
                catch (DebugException debugException) {
                    memoryBlockLabel = memoryBlock.toString();
                }
            } else {
                long address = memoryBlock.getStartAddress();
                memoryBlockLabel = Long.toHexString(address);
            }
            return memoryBlockLabel;
        }
    }
}

