/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IDynamicRenderingFactory;
import org.eclipse.debug.internal.ui.views.memory.IDynamicRenderingType;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingFactory;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingManager;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingType;
import org.eclipse.debug.internal.ui.views.memory.MemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.MemoryRenderingType;

public class MemoryRenderingManager
implements IMemoryRenderingManager {
    private Hashtable fMemoryRenderingTypes = new Hashtable();
    private ArrayList fRenderingTypesOrderList = new ArrayList();
    private Hashtable fDynamicRenderingMap = new Hashtable();
    private Hashtable fDynamicRenderingFactory = new Hashtable();
    private Hashtable fRenderingsEnablement = new Hashtable();
    private Hashtable fDefaultsEnablement = new Hashtable();
    private static final String RENDERING_EXT = "memoryRenderingTypes";
    private static final String RENDERING_ELEMENT = "rendering";
    private static final String RENDERING_PROPERTY_ELEMENT = "renderingProperty";
    private static final String RENDERING_ID = "renderingId";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String DEFAULT_RENDERING = "defaultRenderings";
    private static final String RENDERINGS = "renderingIds";
    private static final String RENDERING_BIND = "renderingBinding";
    private static final String RENDERING_FACTORY = "renderingFactory";
    private static final String DYNAMIC_RENDERING_FACTORY = "dynamicRenderingFactory";
    private static final String ENABLEMENT = "enablement";
    private static final String VIEW_BINDING = "viewBinding";
    private static final String VIEW_IDS = "viewIds";
    private static MemoryRenderingManager fgMemoryRenderingManager;

    public MemoryRenderingManager() {
        this.buildMemoryRenderingTypes();
    }

    private void buildMemoryRenderingTypes() {
        this.processRenderingTypeExtensions();
    }

    private void processRenderingTypeExtensions() {
        IExtensionPoint rendering = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), RENDERING_EXT);
        IExtension[] extensions = rendering.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(RENDERING_ELEMENT)) {
                    this.addStaticRenderingType(elements[j]);
                } else if (elements[j].getName().equals(RENDERING_PROPERTY_ELEMENT)) {
                    this.addRenderingProperty(elements[j]);
                } else if (elements[j].getName().equals(DEFAULT_RENDERING)) {
                    this.addDefaultRenderingTypes(elements[j]);
                } else if (elements[j].getName().equals(RENDERING_BIND)) {
                    this.addRenderingBind(elements[j]);
                } else if (elements[j].getName().equals(VIEW_BINDING)) {
                    this.addViewBind(elements[j]);
                } else {
                    DebugUIPlugin.logErrorMessage("Unknown element in rendering extenstion: " + elements[j].getName());
                }
                ++j;
            }
            ++i;
        }
    }

    private void addStaticRenderingType(IConfigurationElement element) {
        String renderingId = element.getAttribute(RENDERING_ID);
        String name = element.getAttribute(NAME);
        if (renderingId == null || name == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugUIPlugin.logErrorMessage("Rendering defined is malformed: " + extension);
        } else {
            MemoryRenderingType info = new MemoryRenderingType(renderingId, name, element);
            if (this.fMemoryRenderingTypes.containsKey(renderingId)) {
                Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), 0, "Duplicated rendering definition: " + renderingId, null);
                DebugUIPlugin.log((IStatus)status);
            }
            this.fMemoryRenderingTypes.put(renderingId, info);
            this.fRenderingTypesOrderList.add(renderingId);
        }
        IConfigurationElement[] subElements = element.getChildren();
        int k = 0;
        while (k < subElements.length) {
            if (subElements[k].getName().equals(RENDERING_PROPERTY_ELEMENT)) {
                this.addRenderingProperty(subElements[k]);
            } else if (subElements[k].getName().equals(VIEW_BINDING)) {
                this.addViewBind(subElements[k]);
            } else {
                DebugUIPlugin.logErrorMessage("Unknown element in rendering extenstion: " + element.getName());
            }
            ++k;
        }
    }

    private void addRenderingProperty(IConfigurationElement element) {
        Object obj;
        String renderingId = element.getAttribute(RENDERING_ID);
        String propertyId = element.getAttribute(NAME);
        String propertyValue = element.getAttribute(VALUE);
        if (renderingId == null && (obj = element.getParent()) != null && obj instanceof IConfigurationElement) {
            IConfigurationElement parentElm = (IConfigurationElement)obj;
            renderingId = parentElm.getAttribute(RENDERING_ID);
        }
        if (renderingId == null || propertyId == null || propertyValue == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugUIPlugin.logErrorMessage("Rendering property defined is malformed: " + extension);
        } else {
            MemoryRenderingType info = (MemoryRenderingType)this.fMemoryRenderingTypes.get(renderingId);
            if (info == null) {
                DebugUIPlugin.logErrorMessage("Rendering info for this property is not found: " + propertyId);
            } else {
                info.addProperty(propertyId, element);
            }
        }
    }

    private void addDefaultRenderingTypes(IConfigurationElement element) {
        String renderings = element.getAttribute(RENDERINGS);
        IConfigurationElement[] enablementElms = element.getChildren(ENABLEMENT);
        if (renderings == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugUIPlugin.logErrorMessage("Default rendering defined is malformed: " + extension);
            return;
        }
        if (enablementElms == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugUIPlugin.logErrorMessage("Default rendering defined is malformed: " + extension);
            return;
        }
        ArrayList renderingsArray = this.breakStringIntoArray(renderings);
        if (enablementElms != null && enablementElms.length > 0) {
            int j = 0;
            while (j < enablementElms.length) {
                if (this.fDefaultsEnablement == null) {
                    this.fDefaultsEnablement = new Hashtable();
                }
                Expression enablementExp = null;
                try {
                    IConfigurationElement enablement = enablementElms[j];
                    if (enablement != null) {
                        enablementExp = ExpressionConverter.getDefault().perform(enablement);
                    }
                }
                catch (CoreException coreException) {
                    String extension = element.getDeclaringExtension().getUniqueIdentifier();
                    DebugUIPlugin.logErrorMessage("Cannot create eanblement expression of the default renderings from  " + extension);
                    return;
                }
                ArrayList definedrenderings = (ArrayList)this.fDefaultsEnablement.get(enablementExp);
                if (definedrenderings == null) {
                    this.fDefaultsEnablement.put(enablementExp, renderingsArray);
                } else {
                    int i = 0;
                    while (i < renderingsArray.size()) {
                        if (!definedrenderings.contains(renderingsArray.get(i))) {
                            definedrenderings.add(renderingsArray.get(i));
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    private void addRenderingBind(IConfigurationElement element) {
        String renderings = element.getAttribute(RENDERINGS);
        IConfigurationElement[] enablementElms = element.getChildren(ENABLEMENT);
        if (renderings == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugUIPlugin.logErrorMessage("Rendering bind defined is malformed: " + extension);
            return;
        }
        if (enablementElms == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugUIPlugin.logErrorMessage("Rendering bind defined is malformed: " + extension);
            return;
        }
        if (enablementElms != null && enablementElms.length > 0) {
            int j = 0;
            while (j < enablementElms.length) {
                if (this.fRenderingsEnablement == null) {
                    this.fRenderingsEnablement = new Hashtable();
                }
                Expression enablementExp = null;
                try {
                    IConfigurationElement enablement = enablementElms[j];
                    if (enablement != null) {
                        enablementExp = ExpressionConverter.getDefault().perform(enablement);
                    }
                }
                catch (CoreException coreException) {
                    String extension = element.getDeclaringExtension().getUniqueIdentifier();
                    DebugUIPlugin.logErrorMessage("Cannot create eanblement expression of the rendering bind from  " + extension);
                    return;
                }
                if (enablementExp != null) {
                    ArrayList renderingsArray = this.breakStringIntoArray(renderings);
                    ArrayList renderingIds = (ArrayList)this.fRenderingsEnablement.get(enablementExp);
                    if (renderingIds == null) {
                        this.fRenderingsEnablement.put(enablementExp, renderingsArray);
                    } else {
                        int i = 0;
                        while (i < renderingsArray.size()) {
                            if (!renderingIds.contains(renderingsArray.get(i))) {
                                renderingIds.add(renderingsArray.get(i));
                            }
                            ++i;
                        }
                    }
                }
                ++j;
            }
        }
    }

    private void addViewBind(IConfigurationElement element) {
        Object obj;
        String renderingId = element.getAttribute(RENDERING_ID);
        String viewIds = element.getAttribute(VIEW_IDS);
        if (renderingId == null && (obj = element.getParent()) != null && obj instanceof IConfigurationElement) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            renderingId = parent.getAttribute(RENDERING_ID);
        }
        if (renderingId == null) {
            DebugUIPlugin.logErrorMessage("renderingId not defined in view binding extension: " + element.getDeclaringExtension().getExtensionPointUniqueIdentifier());
            return;
        }
        if (viewIds == null) {
            DebugUIPlugin.logErrorMessage("viewIds not defined in view binding extension: " + element.getDeclaringExtension().getExtensionPointUniqueIdentifier());
            return;
        }
        ArrayList supportedViews = this.breakStringIntoArray(viewIds);
        MemoryRenderingType info = (MemoryRenderingType)this.fMemoryRenderingTypes.get(renderingId);
        if (info == null) {
            DebugUIPlugin.logErrorMessage("Rendering info for this rendering type is not found: " + renderingId);
        } else {
            info.addViewBindings(supportedViews.toArray(new String[supportedViews.size()]));
        }
    }

    private ArrayList breakStringIntoArray(String str) {
        ArrayList<String> returnedArray = new ArrayList<String>();
        int idx = str.indexOf(",");
        if (idx == -1) {
            returnedArray.add(str);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreElements()) {
                String rendering = tokenizer.nextToken();
                rendering = rendering.trim();
                returnedArray.add(rendering);
            }
        }
        return returnedArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IMemoryRendering createRendering(IMemoryBlock mem, String renderingId) throws DebugException {
        IMemoryRenderingType info = this.getRenderingTypeById(renderingId);
        if (info != null) {
            IConfigurationElement element = info.getConfigElement();
            if (element != null) {
                String factoryAtt = element.getAttribute(RENDERING_FACTORY);
                if (factoryAtt == null) return new MemoryRendering(mem, renderingId);
                Object obj = null;
                try {
                    obj = element.createExecutableExtension(RENDERING_FACTORY);
                }
                catch (CoreException e) {
                    IStatus stat = e.getStatus();
                    DebugException de = new DebugException(stat);
                    throw de;
                }
                if (obj == null) {
                    return new MemoryRendering(mem, renderingId);
                }
                if (!(obj instanceof IMemoryRenderingFactory)) return new MemoryRendering(mem, renderingId);
                IMemoryRenderingFactory factory = (IMemoryRenderingFactory)obj;
                IMemoryRendering rendering = null;
                return factory.createRendering(mem, renderingId);
            }
            String message = MessageFormat.format(DebugCoreMessages.getString((String)"MemoryRenderingManager.ErrorMsg"), renderingId);
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 0, message, null);
            DebugException de = new DebugException((IStatus)status);
            throw de;
        }
        String message = MessageFormat.format(DebugCoreMessages.getString((String)"MemoryRenderingManager.ErrorMsg"), renderingId);
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 0, message, null);
        DebugException de = new DebugException((IStatus)status);
        throw de;
    }

    public IMemoryRenderingType getRenderingTypeById(String renderingId) {
        MemoryRenderingType info = (MemoryRenderingType)this.fMemoryRenderingTypes.get(renderingId);
        if (info != null) {
            return info;
        }
        return null;
    }

    public IMemoryRenderingType[] getRenderingTypes(Object obj) {
        ArrayList renderingIds = new ArrayList();
        Enumeration enumeration = this.fRenderingsEnablement.keys();
        EvaluationContext evalContext = new EvaluationContext(null, obj);
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            try {
                ArrayList ids;
                Expression expression;
                EvaluationResult result;
                if (!(key instanceof Expression) || !(result = (expression = (Expression)key).evaluate((IEvaluationContext)evalContext)).equals(EvaluationResult.TRUE) || (ids = (ArrayList)this.fRenderingsEnablement.get(expression)) == null) continue;
                int j = 0;
                while (j < ids.size()) {
                    if (!renderingIds.contains(ids.get(j))) {
                        renderingIds.add(ids.get(j));
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return this.getRenderingTypesByIds(renderingIds.toArray(new String[renderingIds.size()]));
    }

    private IMemoryRenderingType[] getRenderingTypesByIds(String[] renderingIds) {
        ArrayList<IMemoryRenderingType> renderingTypes = new ArrayList<IMemoryRenderingType>();
        int i = 0;
        while (i < renderingIds.length) {
            IMemoryRenderingType info = (IMemoryRenderingType)this.fMemoryRenderingTypes.get(renderingIds[i]);
            IDynamicRenderingType[] dynamic = null;
            if (info != null) {
                dynamic = this.getDynamicRenderingType(info);
            }
            if (dynamic != null) {
                int j = 0;
                while (j < dynamic.length) {
                    IMemoryRenderingType dynamicInfo = (IMemoryRenderingType)this.fMemoryRenderingTypes.get(dynamic[j].getRenderingId());
                    renderingTypes.add(dynamicInfo);
                    ++j;
                }
            } else if (info != null) {
                renderingTypes.add(info);
            }
            ++i;
        }
        return renderingTypes.toArray(new IMemoryRenderingType[renderingTypes.size()]);
    }

    public IMemoryRenderingType[] getRenderingTypes(Object obj, String viewId) {
        IMemoryRenderingType[] renderingTypes = this.getRenderingTypes(obj);
        ArrayList<IMemoryRenderingType> returnList = new ArrayList<IMemoryRenderingType>();
        int i = 0;
        while (i < renderingTypes.length) {
            String[] viewIds = renderingTypes[i].getSupportedViewIds();
            int j = 0;
            while (j < viewIds.length) {
                if (viewIds[j].equals(viewId)) {
                    returnList.add(renderingTypes[i]);
                }
                ++j;
            }
            ++i;
        }
        return returnList.toArray(new IMemoryRenderingType[returnList.size()]);
    }

    private IDynamicRenderingType[] getDynamicRenderingType(IMemoryRenderingType rendering) {
        IConfigurationElement element = rendering.getPropertyConfigElement(DYNAMIC_RENDERING_FACTORY);
        try {
            if (element != null) {
                Object obj = this.fDynamicRenderingFactory.get(rendering.getRenderingId());
                if (obj == null) {
                    obj = element.createExecutableExtension(VALUE);
                }
                if (obj != null && obj instanceof IDynamicRenderingFactory) {
                    this.fDynamicRenderingFactory.put(rendering.getRenderingId(), obj);
                    IDynamicRenderingType[] dynamicRenderingTypes = ((IDynamicRenderingFactory)obj).getRenderingTypes();
                    if (dynamicRenderingTypes != null) {
                        this.addDynamicRenderingTypes(dynamicRenderingTypes);
                        Enumeration enumeration = this.fDynamicRenderingMap.keys();
                        while (enumeration.hasMoreElements()) {
                            String dynamicRenderingId = (String)enumeration.nextElement();
                            String staticRenderingId = (String)this.fDynamicRenderingMap.get(dynamicRenderingId);
                            if (!staticRenderingId.equals(rendering.getRenderingId())) continue;
                            boolean found = false;
                            int i = 0;
                            while (i < dynamicRenderingTypes.length) {
                                if (dynamicRenderingTypes[i].getRenderingId().equals(dynamicRenderingId)) {
                                    found = true;
                                    break;
                                }
                                ++i;
                            }
                            if (found) continue;
                            this.fMemoryRenderingTypes.remove(dynamicRenderingId);
                            this.fDynamicRenderingMap.remove(dynamicRenderingId);
                        }
                        String staticRenderingId = rendering.getRenderingId();
                        int i = 0;
                        while (i < dynamicRenderingTypes.length) {
                            this.fDynamicRenderingMap.put(dynamicRenderingTypes[i].getRenderingId(), staticRenderingId);
                            ++i;
                        }
                        return dynamicRenderingTypes;
                    }
                    return null;
                }
            }
        }
        catch (CoreException coreException) {
            DebugUIPlugin.logErrorMessage("Cannot create the dynamic rendering factory for " + element.getDeclaringExtension().getUniqueIdentifier());
            return null;
        }
        return null;
    }

    private IMemoryRenderingType createRenderingType(IDynamicRenderingType info) {
        if (info == null) {
            return null;
        }
        if (info.getParentRenderingType() == null) {
            DebugUIPlugin.logErrorMessage("Dynamic rendering info does not have a parent " + info.getRenderingId());
            return null;
        }
        IMemoryRenderingType parent = info.getParentRenderingType();
        MemoryRenderingType dynamicInfo = new MemoryRenderingType(info.getRenderingId(), info.getName(), info.getParentRenderingType().getConfigElement());
        IConfigurationElement[] properties = parent.getAllProperties();
        int i = 0;
        while (i < properties.length) {
            String name = properties[i].getAttribute(NAME);
            if (name != null && !name.equals(DYNAMIC_RENDERING_FACTORY)) {
                dynamicInfo.addProperty(name, properties[i]);
            }
            ++i;
        }
        String[] supportedViews = parent.getSupportedViewIds();
        dynamicInfo.addViewBindings(supportedViews);
        return dynamicInfo;
    }

    public IMemoryRenderingType[] getDefaultRenderingTypes(Object obj) {
        if (obj == null) {
            return new IMemoryRenderingType[0];
        }
        ArrayList results = new ArrayList();
        Enumeration enumeration = this.fDefaultsEnablement.keys();
        EvaluationContext evalContext = new EvaluationContext(null, obj);
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            try {
                ArrayList ids;
                Expression expression;
                EvaluationResult result;
                if (!(key instanceof Expression) || !(result = (expression = (Expression)key).evaluate((IEvaluationContext)evalContext)).equals(EvaluationResult.TRUE) || (ids = (ArrayList)this.fDefaultsEnablement.get(expression)) == null) continue;
                int j = 0;
                while (j < ids.size()) {
                    if (this.isValidRenderingType(obj, (String)ids.get(j)) && !results.contains(ids.get(j))) {
                        results.add(ids.get(j));
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return this.getRenderingTypesByIds(results.toArray(new String[results.size()]));
    }

    private boolean isValidRenderingType(Object obj, String renderingId) {
        IMemoryRenderingType[] supported = this.getRenderingTypes(obj);
        int i = 0;
        while (i < supported.length) {
            if (supported[i].getRenderingId().equals(renderingId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addDynamicRenderingTypes(IDynamicRenderingType[] dynamicRenderingTypes) {
        if (dynamicRenderingTypes != null) {
            int i = 0;
            while (i < dynamicRenderingTypes.length) {
                IMemoryRenderingType dynamicInfo;
                if (this.fMemoryRenderingTypes.get(dynamicRenderingTypes[i].getRenderingId()) == null && (dynamicInfo = this.createRenderingType(dynamicRenderingTypes[i])) != null) {
                    this.fMemoryRenderingTypes.put(dynamicRenderingTypes[i].getRenderingId(), dynamicInfo);
                }
                ++i;
            }
        }
    }

    public void shutdown() {
        if (this.fMemoryRenderingTypes != null) {
            this.fMemoryRenderingTypes.clear();
            this.fMemoryRenderingTypes = null;
        }
        if (this.fRenderingTypesOrderList != null) {
            this.fRenderingTypesOrderList.clear();
            this.fRenderingTypesOrderList = null;
        }
        if (this.fDynamicRenderingMap != null) {
            this.fDynamicRenderingMap.clear();
            this.fDynamicRenderingMap = null;
        }
        if (this.fDynamicRenderingFactory != null) {
            this.fDynamicRenderingFactory.clear();
            this.fDynamicRenderingFactory = null;
        }
    }

    public static IMemoryRenderingManager getMemoryRenderingManager() {
        if (fgMemoryRenderingManager == null) {
            fgMemoryRenderingManager = new MemoryRenderingManager();
        }
        return fgMemoryRenderingManager;
    }

    public static void pluginShutdown() {
        if (fgMemoryRenderingManager != null) {
            fgMemoryRenderingManager.shutdown();
        }
    }
}

