/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRenderingType;

public class MemoryRenderingType
implements IMemoryRenderingType {
    private String fRenderingId;
    private String fName;
    private Hashtable fProperties;
    private IConfigurationElement fElement;
    private ArrayList fViewBindings;
    private static final String VALUE = "value";

    public MemoryRenderingType(String renderingId, String name, IConfigurationElement element) {
        this.fRenderingId = renderingId;
        this.fName = name;
        this.fElement = element;
    }

    public String getRenderingId() {
        return this.fRenderingId;
    }

    public String getName() {
        return this.fName;
    }

    public void addProperty(String propertyId, IConfigurationElement element) {
        if (this.fProperties == null) {
            this.fProperties = new Hashtable();
        }
        if (propertyId != null && element != null) {
            this.fProperties.put(propertyId, element);
        }
    }

    public void addViewBindings(String[] viewIds) {
        if (viewIds == null) {
            return;
        }
        if (this.fViewBindings == null) {
            this.fViewBindings = new ArrayList();
        }
        int i = 0;
        while (i < viewIds.length) {
            if (!this.fViewBindings.contains(viewIds[i])) {
                this.fViewBindings.add(viewIds[i]);
            }
            ++i;
        }
    }

    public String[] getSupportedViewIds() {
        if (this.fViewBindings == null) {
            return new String[0];
        }
        return this.fViewBindings.toArray(new String[this.fViewBindings.size()]);
    }

    public String getProperty(String propertyId) {
        if (this.fProperties != null) {
            IConfigurationElement element = (IConfigurationElement)this.fProperties.get(propertyId);
            if (element != null) {
                String ret = element.getAttribute(VALUE);
                return ret;
            }
            return null;
        }
        return null;
    }

    public IConfigurationElement getConfigElement() {
        return this.fElement;
    }

    public IConfigurationElement getPropertyConfigElement(String propertyId) {
        if (this.fProperties != null) {
            IConfigurationElement element = (IConfigurationElement)this.fProperties.get(propertyId);
            return element;
        }
        return null;
    }

    public IConfigurationElement[] getAllProperties() {
        Enumeration enumeration = this.fProperties.elements();
        IConfigurationElement[] elements = new IConfigurationElement[this.fProperties.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            elements[i] = (IConfigurationElement)enumeration.nextElement();
            ++i;
        }
        return elements;
    }
}

