/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockExtensionRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.BasicDebugViewContentProvider;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewLine;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TabItem;

public class MemoryViewContentProvider
extends BasicDebugViewContentProvider {
    private static final String PREFIX = "MemoryViewContentProvider.";
    private static final String UNABLE_TO_RETRIEVE_CONTENT = "MemoryViewContentProvider.Unable_to_retrieve_content";
    private static final String DEFAULT_PADDED_STR = "--";
    protected Vector lineCache;
    protected Hashtable contentCache;
    private BigInteger fBufferTopAddress;
    private BigInteger fBaseAddress;
    private IMemoryBlock fMemoryBlock;
    private TabItem fTabItem;
    private MemoryViewTab fViewTab;
    private boolean fLockRefresh = false;

    public MemoryViewContentProvider(IMemoryBlock memoryBlock, TabItem newTab) {
        this.fMemoryBlock = memoryBlock;
        this.fTabItem = newTab;
        this.lineCache = new Vector();
        this.contentCache = new Hashtable();
        this.fViewTab = (MemoryViewTab)this.fTabItem.getData();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    public Object[] getElements(Object parent) {
        if (this.lineCache.isEmpty()) {
            try {
                if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
                    BigInteger address = ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress();
                    if (address == null) {
                        address = new BigInteger("0");
                    }
                    MemoryViewTab viewTab = (MemoryViewTab)this.fTabItem.getData();
                    BigInteger bigInt = address;
                    viewTab.TABLE_PREBUFFER = bigInt.compareTo(BigInteger.valueOf(32L)) <= 0 ? 0 : bigInt.divide(BigInteger.valueOf(32L)).min(BigInteger.valueOf(viewTab.TABLE_DEFAULTBUFFER)).intValue();
                    int addressibleUnit = this.fViewTab.getAddressibleUnitPerLine();
                    address = bigInt.subtract(BigInteger.valueOf(addressibleUnit * viewTab.TABLE_PREBUFFER));
                    this.getMemoryToFitTable(address, this.fViewTab.getNumberOfVisibleLines() + viewTab.TABLE_PREBUFFER + viewTab.TABLE_POSTBUFFER, true);
                } else {
                    MemoryViewTab viewTab = (MemoryViewTab)this.fTabItem.getData();
                    viewTab.TABLE_PREBUFFER = 0;
                    viewTab.TABLE_POSTBUFFER = 0;
                    viewTab.TABLE_DEFAULTBUFFER = 0;
                    long startAddress = this.fMemoryBlock.getStartAddress();
                    BigInteger address = BigInteger.valueOf(startAddress);
                    long length = this.fMemoryBlock.getLength();
                    long numLines = length / (long)this.fViewTab.getBytesPerLine();
                    this.getMemoryToFitTable(address, numLines, true);
                }
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e.getStatus());
                ((MemoryViewTab)this.fTabItem.getData()).displayError(e);
                return this.lineCache.toArray();
            }
        }
        return this.lineCache.toArray();
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    public void getMemoryToFitTable(BigInteger startingAddress, long numberOfLines, boolean updateDelta) throws DebugException {
        int i;
        boolean error = false;
        DebugException dbgEvt = null;
        String adjustedAddress = startingAddress.toString(16);
        int addressSize = this.getAddressSize(startingAddress);
        int addressLength = addressSize * 2;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension && !adjustedAddress.endsWith("0")) {
            adjustedAddress = adjustedAddress.substring(0, adjustedAddress.length() - 1);
            adjustedAddress = String.valueOf(adjustedAddress) + "0";
            startingAddress = new BigInteger(adjustedAddress, 16);
        }
        IMemoryBlockExtension extMemoryBlock = null;
        MemoryByte[] memoryBuffer = null;
        String paddedString = DEFAULT_PADDED_STR;
        long reqNumBytes = 0L;
        try {
            if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
                reqNumBytes = (long)this.fViewTab.getBytesPerLine() * numberOfLines;
                extMemoryBlock = (IMemoryBlockExtension)this.fMemoryBlock;
                IMemoryBlockRetrieval retrieval = extMemoryBlock.getMemoryBlockRetrieval();
                long reqNumberOfUnits = (long)this.fViewTab.getAddressibleUnitPerLine() * numberOfLines;
                memoryBuffer = extMemoryBlock.getBytesFromAddress(startingAddress, reqNumberOfUnits);
                if (memoryBuffer == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                paddedString = ((IMemoryBlockExtensionRetrieval)retrieval).getPaddedString();
                if (paddedString == null) {
                    paddedString = DEFAULT_PADDED_STR;
                }
            } else {
                MByte tmp;
                byte[] memory = this.fMemoryBlock.getBytes();
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                int prefillNumBytes = 0;
                if (!startingAddress.toString(16).endsWith("0")) {
                    adjustedAddress = startingAddress.toString(16).substring(0, adjustedAddress.length() - 1);
                    adjustedAddress = String.valueOf(adjustedAddress) + "0";
                    BigInteger adjustedStart = new BigInteger(adjustedAddress, 16);
                    prefillNumBytes = startingAddress.subtract(adjustedStart).intValue();
                    startingAddress = adjustedStart;
                }
                reqNumBytes = memory.length + prefillNumBytes;
                while (reqNumBytes % (long)this.fViewTab.getBytesPerLine() != 0L) {
                    ++reqNumBytes;
                }
                numberOfLines = reqNumBytes / (long)this.fViewTab.getBytesPerLine();
                memoryBuffer = new MemoryByte[(int)reqNumBytes];
                i = 0;
                while (i < prefillNumBytes) {
                    MByte tmp2 = new MByte();
                    tmp2.setValue((byte)0);
                    tmp2.setReadonly(true);
                    tmp2.setValid(false);
                    memoryBuffer[i] = tmp2;
                    ++i;
                }
                int j = prefillNumBytes;
                int i2 = 0;
                while (i2 < memory.length) {
                    tmp = new MByte();
                    tmp.setValue(memory[i2]);
                    tmp.setValid(true);
                    memoryBuffer[j] = tmp;
                    ++j;
                    ++i2;
                }
                i2 = j;
                while (i2 < memoryBuffer.length) {
                    tmp = new MByte();
                    tmp.setValue((byte)0);
                    tmp.setReadonly(true);
                    tmp.setValid(false);
                    memoryBuffer[i2] = tmp;
                    ++i2;
                }
                paddedString = DEFAULT_PADDED_STR;
            }
        }
        catch (DebugException e) {
            memoryBuffer = this.makeDummyContent(numberOfLines);
            error = true;
            dbgEvt = e;
        }
        if ((long)memoryBuffer.length < reqNumBytes) {
            ArrayList<MemoryByte> newBuffer = new ArrayList<MemoryByte>();
            int i3 = 0;
            while (i3 < memoryBuffer.length) {
                newBuffer.add(memoryBuffer[i3]);
                ++i3;
            }
            i3 = memoryBuffer.length;
            while ((long)i3 < reqNumBytes) {
                byte value = 0;
                byte flags = 0;
                flags = (byte)(flags | 1);
                newBuffer.add(new MByte(value, flags));
                ++i3;
            }
            memoryBuffer = newBuffer.toArray(new MemoryByte[newBuffer.size()]);
        }
        if (!this.lineCache.isEmpty()) {
            this.lineCache.clear();
        }
        String address = startingAddress.toString(16);
        this.fBufferTopAddress = startingAddress;
        this.fBaseAddress = this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
        if (this.fBaseAddress == null) {
            this.fBaseAddress = new BigInteger("0");
        }
        this.fViewTab.setTabName(this.fMemoryBlock, true);
        boolean manageDelta = true;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            manageDelta = !((IMemoryBlockExtension)this.fMemoryBlock).supportsChangeManagement();
        }
        i = 0;
        while ((long)i < numberOfLines) {
            String tmpAddress = address.toUpperCase();
            if (tmpAddress.length() < addressLength) {
                int j = 0;
                while (tmpAddress.length() < addressLength) {
                    tmpAddress = "0" + tmpAddress;
                    ++j;
                }
            }
            MemoryByte[] memory = new MemoryByte[this.fViewTab.getBytesPerLine()];
            boolean isMonitored = true;
            int k = 0;
            int j = i * this.fViewTab.getBytesPerLine();
            while (j < i * this.fViewTab.getBytesPerLine() + this.fViewTab.getBytesPerLine()) {
                byte changeFlag = memoryBuffer[j].getFlags();
                if (manageDelta) {
                    changeFlag = (byte)(changeFlag | 8);
                    changeFlag = (byte)(changeFlag ^ 8);
                    changeFlag = (byte)(changeFlag | 4);
                    changeFlag = (byte)(changeFlag ^ 4);
                }
                MByte newByteObj = new MByte(memoryBuffer[j].getValue(), changeFlag);
                memory[k] = newByteObj;
                ++k;
                if (!manageDelta && !memoryBuffer[j].isKnown()) {
                    isMonitored = false;
                }
                ++j;
            }
            MemoryViewLine newLine = new MemoryViewLine(tmpAddress, memory, this.lineCache.size(), paddedString);
            MemoryViewLine oldLine = (MemoryViewLine)this.contentCache.get(newLine.getAddress());
            newLine.isMonitored = manageDelta ? oldLine != null : isMonitored;
            if (manageDelta && !this.fViewTab.isDisplayingError()) {
                if (updateDelta) {
                    if (oldLine != null) {
                        newLine.markDeltas(oldLine);
                    }
                } else if (oldLine != null) {
                    if (newLine.isLineChanged(oldLine)) {
                        newLine.markDeltas(oldLine);
                    } else {
                        newLine.copyDeltas(oldLine);
                    }
                }
            } else if (manageDelta && this.fViewTab.isDisplayingError()) {
                newLine.isMonitored = false;
            }
            this.lineCache.add(newLine);
            BigInteger bigInt = new BigInteger(address, 16);
            int addressibleUnit = this.fViewTab.getBytesPerLine() / this.fViewTab.getAddressibleSize();
            address = bigInt.add(BigInteger.valueOf(addressibleUnit)).toString(16);
            ++i;
        }
        if (error) {
            throw dbgEvt;
        }
    }

    private MemoryByte[] makeDummyContent(long numberOfLines) {
        int numBytes = (int)((long)this.fViewTab.getBytesPerLine() * numberOfLines);
        MemoryByte[] memoryBuffer = new MemoryByte[numBytes];
        int i = 0;
        while (i < memoryBuffer.length) {
            memoryBuffer[i] = new MByte();
            memoryBuffer[i].setValue((byte)0);
            memoryBuffer[i].setReadonly(true);
            ++i;
        }
        return memoryBuffer;
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        if (!(event.getSource() instanceof IDebugElement)) {
            return;
        }
        IDebugElement src = (IDebugElement)event.getSource();
        if (event.getKind() == 16 && event.getSource() == this.fMemoryBlock) {
            if (event.getDetail() == 256) {
                this.fViewTab.updateLabels();
            } else {
                this.updateContent();
            }
        }
        if (event.getKind() == 2 && src.getDebugTarget() == this.fMemoryBlock.getDebugTarget()) {
            this.updateContent();
        }
    }

    protected boolean isRefreshNeeded() {
        boolean refreshNeeded = false;
        try {
            if (this.isBaseAddressChanged()) {
                return true;
            }
            MemoryViewLine[] cached = this.lineCache.toArray(new MemoryViewLine[this.lineCache.size()]);
            ArrayList<MemoryByte> newMemory = new ArrayList<MemoryByte>();
            if (!(this.fMemoryBlock instanceof IMemoryBlockExtension)) {
                byte[] memory = this.fMemoryBlock.getBytes();
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                int i = 0;
                while (i < memory.length) {
                    MByte tmp = new MByte();
                    tmp.setValue(memory[i]);
                    tmp.setValid(true);
                    newMemory.add(tmp);
                    ++i;
                }
            } else {
                IMemoryBlockExtension extMB = (IMemoryBlockExtension)this.fMemoryBlock;
                long reqNumUnits = this.fViewTab.getAddressibleUnitPerLine();
                MemoryByte[] memory = extMB.getBytesFromAddress(this.fBufferTopAddress, (long)this.lineCache.size() * reqNumUnits);
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                int i = 0;
                while (i < memory.length) {
                    newMemory.add(memory[i]);
                    ++i;
                }
            }
            int i = 0;
            while (i < newMemory.size()) {
                MemoryByte newByte = (MemoryByte)newMemory.get(i);
                if (i / this.fViewTab.getBytesPerLine() >= cached.length) {
                    refreshNeeded = true;
                    break;
                }
                MemoryViewLine lineToCheck = cached[i / this.fViewTab.getBytesPerLine()];
                MemoryByte oldByte = lineToCheck.getByte(i % this.fViewTab.getBytesPerLine());
                if ((newByte.getFlags() & 2) != (oldByte.getFlags() & 2)) {
                    refreshNeeded = true;
                    break;
                }
                if (newByte.isValid() && oldByte.isValid() && newByte.getValue() != oldByte.getValue()) {
                    refreshNeeded = true;
                    break;
                }
                ++i;
            }
        }
        catch (DebugException e) {
            this.fViewTab.displayError(e);
            return false;
        }
        return refreshNeeded;
    }

    private boolean isBaseAddressChanged() {
        if (!(this.fMemoryBlock instanceof IMemoryBlockExtension)) {
            return false;
        }
        IMemoryBlockExtension extMB = (IMemoryBlockExtension)this.fMemoryBlock;
        BigInteger newBaseAddress = extMB.getBigBaseAddress();
        if (newBaseAddress == null) {
            newBaseAddress = new BigInteger("0");
        }
        return newBaseAddress.compareTo(this.fBaseAddress) != 0;
    }

    public void forceRefresh() {
        if (!this.fLockRefresh) {
            this.fLockRefresh = true;
            this.refresh();
            this.fLockRefresh = false;
        }
    }

    protected void refresh() {
        super.refresh();
    }

    public void updateContent() {
        IDebugTarget dt = this.fMemoryBlock.getDebugTarget();
        if (dt.isDisconnected() || dt.isTerminated()) {
            return;
        }
        MemoryViewLine[] lines = this.lineCache.toArray(new MemoryViewLine[this.lineCache.size()]);
        if (this.contentCache != null) {
            this.contentCache.clear();
        }
        if (!this.fViewTab.isEnabled()) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            this.contentCache.put(lines[i].getAddress(), lines[i]);
            lines[i].isMonitored = true;
            ++i;
        }
        boolean updateTopAddress = false;
        if (this.isBaseAddressChanged()) {
            updateTopAddress = true;
            if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
                BigInteger address = ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress();
                if (address == null) {
                    address = this.fViewTab.getSelectedAddress() != null ? this.fViewTab.getSelectedAddress() : new BigInteger("0");
                }
                this.fViewTab.setSelectedAddress(address, true);
            } else {
                BigInteger address = BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
                this.fViewTab.setSelectedAddress(address, true);
            }
        }
        this.resetDeltas();
        this.fViewTab.refresh();
        if (updateTopAddress) {
            this.fViewTab.updateSyncTopAddress(true);
        }
    }

    public BigInteger getBufferTopAddress() {
        return this.fBufferTopAddress;
    }

    public int getAddressSize(BigInteger address) {
        String adjustedAddress = address.toString(16);
        int addressSize = 0;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            addressSize = ((IMemoryBlockExtension)this.fMemoryBlock).getAddressSize();
        }
        if (addressSize <= 0) {
            addressSize = adjustedAddress.length() > 8 ? 8 : 4;
        }
        return addressSize;
    }

    public BigInteger getContentBaseAddress() {
        return this.fBaseAddress;
    }

    public void resetDeltas() {
        Enumeration enumeration = this.contentCache.elements();
        while (enumeration.hasMoreElements()) {
            MemoryViewLine line = (MemoryViewLine)enumeration.nextElement();
            line.unmarkDeltas();
        }
    }

    protected boolean isAddressOutOfRange(BigInteger address) {
        if (this.lineCache != null) {
            MemoryViewLine first = (MemoryViewLine)this.lineCache.firstElement();
            MemoryViewLine last = (MemoryViewLine)this.lineCache.lastElement();
            if (first == null || last == null) {
                return true;
            }
            BigInteger startAddress = new BigInteger(first.getAddress(), 16);
            BigInteger lastAddress = new BigInteger(last.getAddress(), 16);
            int addressibleUnit = this.fViewTab.getAddressibleUnitPerLine();
            lastAddress = lastAddress.add(BigInteger.valueOf(addressibleUnit));
            return startAddress.compareTo(address) > 0 || lastAddress.compareTo(address) < 0;
        }
        return true;
    }

    private class MByte
    extends MemoryByte {
        protected MByte(byte value, byte flags) {
            super(value, flags);
        }

        protected MByte() {
        }
    }
}

