/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.CopyViewTabToClipboardAction;
import org.eclipse.debug.internal.ui.views.memory.HexRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTabFactory;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.PrintViewTabAction;
import org.eclipse.debug.internal.ui.views.memory.RemoveMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.ResetMemoryBlockAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class MemoryViewPane
extends AbstractMemoryViewPane {
    public static final String MEMORY_VIEW_PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.MemoryViewPane";
    private AddMemoryBlockAction fAddMemoryBlockAction;
    private IAction fRemoveMemoryBlockAction;
    private IAction fResetMemoryBlockAction;
    private IAction fCopyViewToClipboardAction;
    private IAction fPrintViewTabAction;
    static /* synthetic */ Class class$0;

    public MemoryViewPane(IViewPart parent) {
        super(parent);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        try {
            if (part == this) {
                return;
            }
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IMemoryViewTab lastViewTab = this.getTopMemoryTab();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            Object[] selections = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < selections.length) {
                Object selectedObj = selections[i];
                if (selectedObj instanceof IMemoryRendering) {
                    this.handleMemoryBlockSelection(lastViewTab, ((IMemoryRendering)selectedObj).getBlock());
                } else if (selectedObj instanceof IMemoryBlock) {
                    this.handleMemoryBlockSelection(lastViewTab, (IMemoryBlock)selectedObj);
                } else if (selectedObj instanceof IDebugElement) {
                    this.handleDebugElementSelection(lastViewTab, (IDebugElement)selectedObj);
                } else {
                    if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                        if (lastViewTab != null) {
                            lastViewTab.setEnabled(false);
                        }
                        this.emptyFolder();
                    }
                    this.fKey = null;
                    return;
                }
                ++i;
            }
        }
        catch (SWTException se) {
            DebugUIPlugin.log(se);
        }
    }

    private void handleMemoryBlockSelection(IMemoryViewTab lastViewTab, IMemoryBlock memoryBlock) {
        if (this.getTopMemoryTab() != null) {
            if (this.getTopMemoryTab().getMemoryBlock() == memoryBlock) {
                return;
            }
            TabFolder folder = (TabFolder)this.fStackLayout.topControl;
            TabItem[] items = folder.getItems();
            int i = 0;
            while (i < items.length) {
                IMemoryViewTab viewTab = (IMemoryViewTab)items[i].getData();
                if (viewTab.getMemoryBlock() == memoryBlock) {
                    boolean isEnabled = lastViewTab.isEnabled();
                    lastViewTab.setEnabled(false);
                    folder.setSelection(i);
                    this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)memoryBlock));
                    this.getTopMemoryTab().setEnabled(isEnabled && this.fVisible);
                    break;
                }
                ++i;
            }
        }
    }

    private void handleDebugElementSelection(IMemoryViewTab lastViewTab, IDebugElement elem) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMemoryBlockRetrieval retrieve = (IMemoryBlockRetrieval)elem.getAdapter((Class)clazz);
        IDebugTarget debugTarget = elem.getDebugTarget();
        if (retrieve == null) {
            retrieve = debugTarget;
        }
        this.fKey = retrieve;
        if (this.fKey == null) {
            return;
        }
        if (debugTarget == null || debugTarget.isTerminated() || debugTarget.isDisconnected()) {
            this.emptyFolder();
            if (this.fTabFolderForDebugView != null && this.fTabFolderForDebugView.containsKey(this.fKey)) {
                TabFolder deleteFolder = (TabFolder)this.fTabFolderForDebugView.get(this.fKey);
                if (!deleteFolder.isDisposed()) {
                    deleteFolder.dispose();
                }
                this.fTabFolderForDebugView.remove(this.fKey);
            }
            this.fKey = null;
            return;
        }
        if (this.fTabFolderForDebugView == null) {
            this.emptyFolder();
            this.fKey = null;
            return;
        }
        if (this.fTabFolderForDebugView.containsKey(retrieve)) {
            if (this.fStackLayout.topControl != (TabFolder)this.fTabFolderForDebugView.get(retrieve)) {
                this.setTabFolder((TabFolder)this.fTabFolderForDebugView.get(retrieve));
                this.fViewPaneCanvas.layout();
            }
        } else {
            this.fTabFolderForDebugView.put(retrieve, new TabFolder(this.fViewPaneCanvas, 0));
            this.setTabFolder((TabFolder)this.fTabFolderForDebugView.get(retrieve));
            this.fViewPaneCanvas.layout();
        }
        IMemoryBlock[] memoryBlocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve);
        TabFolder toDisplay = (TabFolder)this.fStackLayout.topControl;
        if (toDisplay.getItemCount() == 0) {
            this.restoreViewTabs(memoryBlocks);
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null && !newViewTab.isEnabled() && this.fVisible) {
            newViewTab.setEnabled(this.fVisible);
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)newViewTab.getMemoryBlock()));
        }
        this.updateToolBarActionsEnablement();
    }

    private void restoreViewTabs(IMemoryBlock[] memoryBlocks) {
        this.memoryBlocksAdded(memoryBlocks);
    }

    public void memoryBlocksRemoved(final IMemoryBlock[] memoryBlocks) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                int j = 0;
                while (j < memoryBlocks.length) {
                    IMemoryViewTab viewTab;
                    IMemoryBlock memory = memoryBlocks[j];
                    TabFolder tabFolder = (TabFolder)MemoryViewPane.this.fStackLayout.topControl;
                    if (tabFolder.isDisposed()) {
                        return;
                    }
                    TabItem[] tabs = tabFolder.getItems();
                    boolean foundTab = false;
                    int i = 0;
                    while (i < tabs.length) {
                        viewTab = (IMemoryViewTab)tabs[i].getData();
                        if (viewTab.getMemoryBlock() == memory) {
                            MemoryViewPane.this.disposeViewTab(viewTab, tabs[i]);
                            foundTab = true;
                            break;
                        }
                        ++i;
                    }
                    if (foundTab && tabFolder.getItemCount() == 0) {
                        MemoryViewPane.this.fRemoveMemoryBlockAction.setEnabled(false);
                        MemoryViewPane.this.fResetMemoryBlockAction.setEnabled(false);
                        MemoryViewPane.this.fCopyViewToClipboardAction.setEnabled(false);
                        MemoryViewPane.this.fPrintViewTabAction.setEnabled(false);
                        MemoryViewPane.this.fSelectionProvider.setSelection((ISelection)new StructuredSelection(new Object[0]));
                        IDebugTarget dt = memory.getDebugTarget();
                        if (dt.isTerminated() || dt.isDisconnected()) {
                            if (MemoryViewPane.this.fKey != null) {
                                MemoryViewPane.this.fTabFolderForDebugView.remove(MemoryViewPane.this.fKey);
                            }
                            if (!tabFolder.isDisposed()) {
                                tabFolder.dispose();
                            }
                            MemoryViewPane.this.emptyFolder();
                        }
                    }
                    if (!foundTab) {
                        Enumeration enumeration = MemoryViewPane.this.fTabFolderForDebugView.elements();
                        while (enumeration.hasMoreElements()) {
                            IDebugTarget dt;
                            tabFolder = (TabFolder)enumeration.nextElement();
                            tabs = tabFolder.getItems();
                            viewTab = null;
                            int i2 = 0;
                            while (i2 < tabs.length) {
                                viewTab = (IMemoryViewTab)tabs[i2].getData();
                                if (viewTab.getMemoryBlock() == memory) {
                                    MemoryViewPane.this.disposeViewTab(viewTab, tabs[i2]);
                                    foundTab = true;
                                    break;
                                }
                                ++i2;
                            }
                            if (!foundTab) continue;
                            if (tabFolder.getItemCount() != 0 || !(dt = memory.getDebugTarget()).isTerminated() && !dt.isDisconnected()) break;
                            Enumeration keyEnum = MemoryViewPane.this.fTabFolderForDebugView.keys();
                            Object tabKey = null;
                            while (keyEnum.hasMoreElements()) {
                                tabKey = keyEnum.nextElement();
                                if (MemoryViewPane.this.fTabFolderForDebugView.get(tabKey) == tabFolder) break;
                            }
                            if (!tabFolder.isDisposed()) {
                                tabFolder.dispose();
                            }
                            if (tabKey != null) {
                                MemoryViewPane.this.fTabFolderForDebugView.remove(tabKey);
                            }
                            MemoryViewPane.this.emptyFolder();
                            break;
                        }
                    }
                    ++j;
                }
            }
        });
    }

    public void memoryBlocksAdded(IMemoryBlock[] memoryBlocks) {
        int i = 0;
        while (i < memoryBlocks.length) {
            IMemoryBlock memory = memoryBlocks[i];
            if (this.getTopMemoryTab() != null) {
                this.getTopMemoryTab().setEnabled(false);
            }
            TabFolder tabFolder = (TabFolder)this.fStackLayout.topControl;
            TabItem tab = new TabItem(tabFolder, 0);
            MenuManager menuMgr = this.createContextMenuManager();
            HexRendering hexRendering = new HexRendering(memory, "org.eclipse.debug.ui.rendering.raw_memory");
            IMemoryViewTabFactory factory = this.getViewTabFactory("org.eclipse.debug.ui.rendering.raw_memory");
            AbstractMemoryRenderer renderer = this.getRenderer("org.eclipse.debug.ui.rendering.raw_memory");
            IMemoryViewTab memoryTab = factory.createViewTab(memory, tab, menuMgr, hexRendering, renderer);
            this.fMenuMgr.put(memoryTab, menuMgr);
            tabFolder.setSelection(tabFolder.indexOf(tab));
            this.updateToolBarActionsEnablement();
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)memoryTab.getMemoryBlock()));
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        IMemoryBlock blk;
        Object selectedItem = e.item.getData();
        if (selectedItem instanceof IMemoryViewTab && (blk = ((IMemoryViewTab)e.item.getData()).getMemoryBlock()) != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)blk));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Object getCurrentSelection() {
        if (this.getTopMemoryTab() != null) {
            return this.getTopMemoryTab().getMemoryBlock();
        }
        return new Object();
    }

    public IMemoryViewTab[] getAllViewTabs() {
        TabFolder folder = (TabFolder)this.fStackLayout.topControl;
        TabItem[] items = folder.getItems();
        IMemoryViewTab[] viewTabs = new IMemoryViewTab[folder.getItemCount()];
        int i = 0;
        while (i < items.length) {
            viewTabs[i] = (IMemoryViewTab)items[i].getData();
            ++i;
        }
        return viewTabs;
    }

    public void moveToTop(IMemoryViewTab viewTab) {
        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
        if (viewTab == lastViewTab) {
            return;
        }
        TabFolder folder = (TabFolder)this.fStackLayout.topControl;
        TabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            IMemoryViewTab tab = (IMemoryViewTab)items[i].getData();
            if (viewTab == tab) {
                boolean isEnabled = lastViewTab.isEnabled();
                lastViewTab.setEnabled(false);
                folder.setSelection(i);
                this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.getTopMemoryTab().getMemoryBlock()));
                this.getTopMemoryTab().setEnabled(isEnabled && this.fVisible);
                break;
            }
            ++i;
        }
    }

    public void restoreViewPane() {
        ISelection selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        if (MemoryViewUtil.isValidSelection(selection)) {
            IMemoryViewTab top;
            TabFolder toDisplay;
            IMemoryBlockRetrieval memRetrieval;
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
            IDebugElement iDebugElement = (IDebugElement)elem;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((memRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
                memRetrieval = debugTarget;
            }
            if (memRetrieval == null) {
                return;
            }
            if (this.fTabFolderForDebugView.containsKey(memRetrieval) && (toDisplay = (TabFolder)this.fTabFolderForDebugView.get(memRetrieval)) != null) {
                this.setTabFolder(toDisplay);
                this.fViewPaneCanvas.layout();
                IMemoryBlock[] memoryBlocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(debugTarget);
                if (toDisplay.getItemCount() == 0) {
                    this.restoreViewTabs(memoryBlocks);
                }
            }
            if ((top = this.getTopMemoryTab()) != null && !top.isEnabled() && this.fVisible) {
                top.setEnabled(this.fVisible);
            }
        }
    }

    public void dispose() {
        this.fAddMemoryBlockAction.dispose();
        super.dispose();
    }

    public IAction[] getActions() {
        ArrayList<AddMemoryBlockAction> actions = new ArrayList<AddMemoryBlockAction>();
        if (this.fAddMemoryBlockAction == null) {
            this.fAddMemoryBlockAction = new AddMemoryBlockAction(this);
        }
        actions.add(this.fAddMemoryBlockAction);
        if (this.fRemoveMemoryBlockAction == null) {
            this.fRemoveMemoryBlockAction = new RemoveMemoryBlockAction();
        }
        this.fRemoveMemoryBlockAction.setEnabled(false);
        actions.add((AddMemoryBlockAction)this.fRemoveMemoryBlockAction);
        if (this.fResetMemoryBlockAction == null) {
            this.fResetMemoryBlockAction = new ResetMemoryBlockAction();
        }
        this.fResetMemoryBlockAction.setEnabled(false);
        actions.add((AddMemoryBlockAction)this.fResetMemoryBlockAction);
        if (this.fCopyViewToClipboardAction == null) {
            this.fCopyViewToClipboardAction = new CopyViewTabToClipboardAction();
        }
        this.fCopyViewToClipboardAction.setEnabled(false);
        actions.add((AddMemoryBlockAction)this.fCopyViewToClipboardAction);
        if (this.fPrintViewTabAction == null) {
            this.fPrintViewTabAction = new PrintViewTabAction();
        }
        this.fPrintViewTabAction.setEnabled(false);
        actions.add((AddMemoryBlockAction)this.fPrintViewTabAction);
        return actions.toArray(new IAction[actions.size()]);
    }

    protected void updateToolBarActionsEnablement() {
        TabFolder folder = (TabFolder)this.fStackLayout.topControl;
        int index = folder.getSelectionIndex();
        if (index >= 0) {
            this.fRemoveMemoryBlockAction.setEnabled(true);
            this.fResetMemoryBlockAction.setEnabled(true);
            this.fCopyViewToClipboardAction.setEnabled(true);
            this.fPrintViewTabAction.setEnabled(true);
        } else {
            this.fRemoveMemoryBlockAction.setEnabled(false);
            this.fResetMemoryBlockAction.setEnabled(false);
            this.fCopyViewToClipboardAction.setEnabled(false);
            this.fPrintViewTabAction.setEnabled(false);
        }
    }

    protected void emptyFolder() {
        super.emptyFolder();
        this.updateToolBarActionsEnablement();
        this.fSelectionProvider.setSelection((ISelection)new StructuredSelection(new Object[0]));
    }
}

