/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.CopyViewTabToClipboardAction;
import org.eclipse.debug.internal.ui.views.memory.CopyViewTabToClipboardContextAction;
import org.eclipse.debug.internal.ui.views.memory.EmptyRenderer;
import org.eclipse.debug.internal.ui.views.memory.FormatColumnAction;
import org.eclipse.debug.internal.ui.views.memory.GoToAddressAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryBlockModelPresentation;
import org.eclipse.debug.internal.ui.views.memory.IMemoryBlockViewSynchronizer;
import org.eclipse.debug.internal.ui.views.memory.IMemoryRendering;
import org.eclipse.debug.internal.ui.views.memory.ISynchronizedMemoryBlockView;
import org.eclipse.debug.internal.ui.views.memory.ISynchronizerListener;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryRenderingManager;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewCellModifier;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewContentProvider;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewLine;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTabLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.PrintViewTabAction;
import org.eclipse.debug.internal.ui.views.memory.PrintViewTabContextAction;
import org.eclipse.debug.internal.ui.views.memory.ReformatAction;
import org.eclipse.debug.internal.ui.views.memory.ResetMemoryBlockAction;
import org.eclipse.debug.internal.ui.views.memory.ResetMemoryBlockContextAction;
import org.eclipse.debug.internal.ui.views.memory.SetColumnSizeDefaultAction;
import org.eclipse.debug.internal.ui.views.memory.ShowAddressColumnAction;
import org.eclipse.debug.internal.ui.views.memory.ViewTabCursorManager;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MemoryViewTab
extends AbstractMemoryViewTab
implements SelectionListener,
ControlListener,
KeyListener,
ITableMemoryViewTab,
ISynchronizedMemoryBlockView,
ISynchronizerListener {
    private static final String PREFIX = "MemoryViewTab.";
    private static final String ADDRESS = "MemoryViewTab.Address";
    private static final String ERROR = "MemoryViewTab.Error";
    private static final String FORMAT_IS_INVALID = "MemoryViewTab.Format_is_invalid";
    private static final String ADDRESS_IS_OUT_OF_RANGE = "MemoryViewTab.Address_is_out_of_range";
    private static final String COLUMN_SIZE = "MemoryViewTab.Column_size";
    private static final String UNABLE_TO_GET_BASE_ADDRESS = "MemoryViewTab.Unable_to_retrieve_base_address";
    private static final String UNKNOWN = "MemoryViewTab.Unknown";
    private static final String MEMORY_ACTIONS_GROUP = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryViewActionsGroup";
    private static final String MEMORY_ACTIONS_FORMAT_GROUP = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryViewActionsGroup.format";
    private MemoryViewContentProvider contentProvider;
    private TableViewer fTableViewer = null;
    private boolean fEnabled;
    private ViewTabCursorManager fCursorManager;
    private boolean fShowAddressColumn = true;
    public int TABLE_PREBUFFER = 20;
    public int TABLE_POSTBUFFER = 20;
    public int TABLE_DEFAULTBUFFER = 20;
    private TextViewer fTextViewer = null;
    private boolean errorOccurred = false;
    protected BigInteger fSelectedAddress = null;
    private boolean fTabCreated = false;
    private CellEditor[] fEditors;
    private ICellModifier fCellModifier;
    private CopyViewTabToClipboardAction fCopyToClipboardAction;
    private GoToAddressAction fGoToAddressAction;
    private ResetMemoryBlockAction fResetMemoryBlockAction;
    private PrintViewTabAction fPrintViewTabAction;
    private Action[] fFormatColumnActions;
    private ReformatAction fReformatAction;
    private ShowAddressColumnAction fShowAddColumnAction;
    private boolean fIsDisposed = false;
    private int fBytePerLine;
    private int fColumnSize;
    private FontChangeListener fFontChangeListener;
    private TabFolderDisposeListener fTabFolderDisposeListener;
    private boolean fUpdateTabLabel = true;
    private static final int[] ignoreEvents = new int[]{0x1000001, 0x1000002, 0x1000003, 0x1000004, 0x1000005, 0x1000006, 0x1000007, 0x1000008, 0x1000009, 0x100000A, 0x100000B, 0x100000C, 0x100000D, 0x100000E, 0x100000F, 0x1000010, 0x1000011, 0x1000012, 0x1000013, 0x1000014, 0x1000015, 0x1000016, 0x1000017, 0x1000018, 0x1000051, 16777298, 16777299, 16777300, 0x1000055, 16777302, 16777303, 27, 262144, 65536};
    private int fAddressibleSize;

    public MemoryViewTab(IMemoryBlock newMemory, TabItem newTab, MenuManager menuMgr, IMemoryRendering rendering, AbstractMemoryRenderer renderer) {
        super(newMemory, newTab, menuMgr, rendering);
        this.setTabName(newMemory, true);
        this.fTabItem.setControl(this.createFolderPage(renderer));
        if (!(newMemory instanceof IMemoryBlockExtension)) {
            this.TABLE_PREBUFFER = 0;
            this.TABLE_POSTBUFFER = 0;
            this.TABLE_DEFAULTBUFFER = 0;
        }
        if (this.fTableViewer != null) {
            this.fTableViewer.getTable().setTopIndex(this.TABLE_PREBUFFER);
        }
        this.addViewTabToSynchronizer();
        DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer().addSynchronizerListener(this);
        this.fEnabled = true;
        this.fTabCreated = true;
        this.synchronize();
        this.createActions();
        this.packColumns();
        if (this.fTableViewer != null) {
            this.fTableViewer.getTable().addSelectionListener((SelectionListener)this);
            this.fTabFolderDisposeListener = new TabFolderDisposeListener(this);
            this.fTabItem.addDisposeListener((DisposeListener)this.fTabFolderDisposeListener);
        }
        if (this.fMemoryBlock instanceof IMemoryBlockExtension && ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() == null) {
            DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_GET_BASE_ADDRESS), null));
            this.displayError(e);
        }
    }

    private void addViewTabToSynchronizer() {
        this.getMemoryBlockViewSynchronizer().addView(this, null);
        Object selectedAddress = this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.selectedAddress");
        Object size = this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.columnSize");
        Object topAddress = this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.topAddress");
        if (selectedAddress == null) {
            this.updateSyncSelectedAddress(true);
        }
        if (size == null) {
            this.updateSyncColSize();
        }
        if (topAddress == null) {
            this.updateSyncTopAddress(true);
        }
    }

    private void updateSyncSelectedAddress(boolean update) {
        if (update) {
            this.getMemoryBlockViewSynchronizer().setSynchronizedProperty(this.getMemoryBlock(), "org.eclipse.debug.ui.MemoryViewTab.selectedAddress", this.fSelectedAddress);
        }
    }

    private void updateSyncColSize() {
        this.getMemoryBlockViewSynchronizer().setSynchronizedProperty(this.getMemoryBlock(), "org.eclipse.debug.ui.MemoryViewTab.columnSize", new Integer(this.fColumnSize));
    }

    protected void updateSyncTopAddress(boolean updateToSynchronizer) {
        if (updateToSynchronizer) {
            this.getMemoryBlockViewSynchronizer().setSynchronizedProperty(this.getMemoryBlock(), "org.eclipse.debug.ui.MemoryViewTab.topAddress", this.getTopVisibleAddress());
        }
    }

    protected void setTabName(IMemoryBlock newMemory, boolean showAddress) {
        if (!this.fUpdateTabLabel) {
            return;
        }
        String tabName = null;
        IDebugModelPresentation presentation = DebugUIPlugin.getModelPresentation();
        if (presentation instanceof IMemoryBlockModelPresentation) {
            tabName = ((IMemoryBlockModelPresentation)presentation).getTabLabel(newMemory, this.getRenderingId());
        }
        if (tabName == null) {
            String preName;
            tabName = "";
            try {
                if (newMemory instanceof IMemoryBlockExtension) {
                    tabName = ((IMemoryBlockExtension)newMemory).getExpression();
                    if (tabName.startsWith("&")) {
                        tabName = "&" + tabName;
                    }
                    if (tabName == null) {
                        tabName = DebugUIMessages.getString(UNKNOWN);
                    }
                    if (showAddress && ((IMemoryBlockExtension)newMemory).getBigBaseAddress() != null) {
                        tabName = String.valueOf(tabName) + " : 0x";
                        tabName = String.valueOf(tabName) + ((IMemoryBlockExtension)newMemory).getBigBaseAddress().toString(16);
                    }
                } else {
                    long address = newMemory.getStartAddress();
                    tabName = Long.toHexString(address);
                }
            }
            catch (DebugException e) {
                tabName = DebugUIMessages.getString(UNKNOWN);
                DebugUIPlugin.log(e.getStatus());
            }
            if ((preName = MemoryRenderingManager.getMemoryRenderingManager().getRenderingTypeById(this.getRenderingId()).getName()) != null) {
                tabName = String.valueOf(tabName) + " <" + preName + ">";
            }
        }
        this.fTabItem.setText(tabName);
    }

    protected void createActions() {
        this.fCopyToClipboardAction = new CopyViewTabToClipboardContextAction(this);
        this.fGoToAddressAction = new GoToAddressAction(this);
        this.fResetMemoryBlockAction = new ResetMemoryBlockContextAction(this);
        this.fPrintViewTabAction = new PrintViewTabContextAction(this);
        this.fFormatColumnActions = new Action[6];
        this.fFormatColumnActions[0] = new FormatColumnAction(1, this.fAddressibleSize, this);
        this.fFormatColumnActions[1] = new FormatColumnAction(2, this.fAddressibleSize, this);
        this.fFormatColumnActions[2] = new FormatColumnAction(4, this.fAddressibleSize, this);
        this.fFormatColumnActions[3] = new FormatColumnAction(8, this.fAddressibleSize, this);
        this.fFormatColumnActions[4] = new FormatColumnAction(16, this.fAddressibleSize, this);
        this.fFormatColumnActions[5] = new SetColumnSizeDefaultAction(this);
        this.fReformatAction = new ReformatAction(this);
        this.fShowAddColumnAction = new ShowAddressColumnAction(this);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(MEMORY_ACTIONS_GROUP));
        menu.add((IAction)this.fResetMemoryBlockAction);
        menu.add((IAction)this.fGoToAddressAction);
        menu.add((IContributionItem)new Separator());
        if (this.fFormatColumnActions.length > 0) {
            MenuManager formatMenu = new MenuManager(DebugUIMessages.getString(COLUMN_SIZE), MEMORY_ACTIONS_FORMAT_GROUP);
            menu.appendToGroup(MEMORY_ACTIONS_GROUP, (IContributionItem)formatMenu);
            int i = 0;
            while (i < this.fFormatColumnActions.length) {
                formatMenu.add((IAction)this.fFormatColumnActions[i]);
                if (this.fFormatColumnActions[i] instanceof FormatColumnAction) {
                    if (((FormatColumnAction)this.fFormatColumnActions[i]).getColumnSize() == this.getBytesPerColumn()) {
                        this.fFormatColumnActions[i].setChecked(true);
                    } else {
                        this.fFormatColumnActions[i].setChecked(false);
                    }
                }
                ++i;
            }
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fReformatAction);
        menu.add((IAction)this.fShowAddColumnAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fCopyToClipboardAction);
        menu.add((IAction)this.fPrintViewTabAction);
    }

    private Control createFolderPage(AbstractMemoryRenderer renderer) {
        boolean ok;
        int syncColSize;
        MemoryViewTabLabelProvider labelProvider;
        this.contentProvider = new MemoryViewContentProvider(this.fMemoryBlock, this.fTabItem);
        this.fTableViewer = new TableViewer((Composite)this.fTabItem.getParent(), 101124);
        this.fTableViewer.setContentProvider((IContentProvider)this.contentProvider);
        if (renderer != null) {
            renderer.setRenderingId(this.getRenderingId());
            labelProvider = new MemoryViewTabLabelProvider(this, renderer);
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            labelProvider.setViewTab(this);
        } else {
            renderer = new EmptyRenderer();
            renderer.setRenderingId(this.getRenderingId());
            renderer.setViewTab(this);
            labelProvider = new MemoryViewTabLabelProvider(this, renderer);
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Renderer property is not defined for: " + this.getRenderingId(), null));
        }
        this.contentProvider.setViewer((StructuredViewer)this.fTableViewer);
        ScrollBar scroll = ((Table)this.fTableViewer.getControl()).getVerticalBar();
        scroll.addSelectionListener((SelectionListener)this);
        scroll.setMinimum(-100);
        scroll.setMaximum(200);
        this.fTableViewer.getControl().addControlListener((ControlListener)this);
        this.fTableViewer.getControl().addKeyListener((KeyListener)this);
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        this.fAddressibleSize = -1;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            this.fAddressibleSize = ((IMemoryBlockExtension)this.fMemoryBlock).getAddressibleSize();
        }
        if (this.fAddressibleSize < 1) {
            this.fAddressibleSize = 1;
        }
        int bytePerLine = 16 * this.fAddressibleSize;
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        int columnSize = prefStore.getInt("org.eclipse.debug.ui.memory.columnSize");
        columnSize *= this.getAddressibleSize();
        Integer colSize = (Integer)this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.columnSize");
        if (colSize != null && (syncColSize = colSize.intValue()) > 0) {
            columnSize = syncColSize;
        }
        if (!(ok = this.format(bytePerLine, columnSize))) {
            DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(FORMAT_IS_INVALID), null));
            this.displayError(e);
            return this.fTextViewer.getControl();
        }
        this.fTableViewer.setInput((Object)this.fMemoryBlock);
        this.fCellModifier = new MemoryViewCellModifier(this);
        this.fTableViewer.setCellModifier(this.fCellModifier);
        this.fTableViewer.getTable().setFont(JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME));
        int row = 0;
        int col = 1;
        this.fCursorManager = new ViewTabCursorManager(this, row, col, this.fMenuMgr);
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            BigInteger syncAddress;
            BigInteger address = ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress();
            if (address == null) {
                address = new BigInteger("0");
            }
            if ((syncAddress = (BigInteger)this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.selectedAddress")) != null) {
                this.setSelectedAddress(syncAddress, false);
            } else {
                this.setSelectedAddress(address, true);
            }
            this.updateCursorPosition();
        } else {
            long address = this.fMemoryBlock.getStartAddress();
            BigInteger syncAddress = (BigInteger)this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.selectedAddress");
            if (syncAddress != null) {
                this.setSelectedAddress(syncAddress, false);
            } else {
                this.setSelectedAddress(BigInteger.valueOf(address), true);
            }
            this.updateCursorPosition();
        }
        this.fFontChangeListener = new FontChangeListener();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fFontChangeListener);
        if (this.errorOccurred) {
            return this.fTextViewer.getControl();
        }
        return this.fTableViewer.getControl();
    }

    public boolean format(int bytesPerLine, int columnSize) {
        int addressibleUnit;
        if (bytesPerLine / this.fAddressibleSize != 16) {
            return false;
        }
        if (bytesPerLine % columnSize != 0) {
            return false;
        }
        if (this.fBytePerLine == bytesPerLine && this.fColumnSize == columnSize) {
            return false;
        }
        this.fBytePerLine = bytesPerLine;
        this.fColumnSize = columnSize;
        if (this.fTabCreated) {
            this.getTopVisibleAddress();
            if (this.fTableViewer == null) {
                return false;
            }
            if (this.fTableViewer.getTable() == null) {
                return false;
            }
            TableColumn[] oldColumns = this.fTableViewer.getTable().getColumns();
            int i = 0;
            while (i < oldColumns.length) {
                oldColumns[i].dispose();
                ++i;
            }
            CellEditor[] oldCellEditors = this.fTableViewer.getCellEditors();
            int i2 = 0;
            while (i2 < oldCellEditors.length) {
                oldCellEditors[i2].dispose();
                ++i2;
            }
        }
        TableColumn column0 = new TableColumn(this.fTableViewer.getTable(), 16384, 0);
        column0.setText(DebugUIMessages.getString(ADDRESS));
        TableColumn[] byteColumns = new TableColumn[bytesPerLine / columnSize];
        String[] columnLabels = new String[]{};
        IDebugModelPresentation presentation = DebugUIPlugin.getModelPresentation();
        if (presentation instanceof IMemoryBlockModelPresentation) {
            columnLabels = ((IMemoryBlockModelPresentation)presentation).getColumnLabels(this.getMemoryBlock(), bytesPerLine, columnSize);
        }
        if (columnLabels == null) {
            columnLabels = new String[]{};
        }
        int i = 0;
        while (i < byteColumns.length) {
            TableColumn column = new TableColumn(this.fTableViewer.getTable(), 16384, i + 1);
            if (columnLabels.length == byteColumns.length) {
                column.setText(columnLabels[i]);
            } else {
                addressibleUnit = columnSize / this.fAddressibleSize;
                if (this.getAddressibleUnitPerColumn() >= 4) {
                    column.setText(String.valueOf(Integer.toHexString(i * addressibleUnit).toUpperCase()) + " - " + Integer.toHexString(i * addressibleUnit + addressibleUnit - 1).toUpperCase());
                } else {
                    column.setText(Integer.toHexString(i * addressibleUnit).toUpperCase());
                }
            }
            ++i;
        }
        TableColumn emptyCol = new TableColumn(this.fTableViewer.getTable(), 16384, byteColumns.length + 1);
        emptyCol.setText(" ");
        emptyCol.setWidth(1);
        emptyCol.setResizable(false);
        String[] columnProperties = new String[byteColumns.length + 2];
        columnProperties[0] = "address";
        addressibleUnit = columnSize / this.getAddressibleSize();
        int i3 = 1;
        while (i3 < columnProperties.length - 1) {
            columnProperties[i3] = Integer.toHexString((i3 - 1) * addressibleUnit);
            ++i3;
        }
        columnProperties[columnProperties.length - 1] = " ";
        this.fTableViewer.setColumnProperties(columnProperties);
        this.fTableViewer.setCellEditors(this.getCellEditors());
        if (this.fTabCreated) {
            this.refreshTableViewer();
            if (this.isAddressVisible(this.fSelectedAddress)) {
                this.updateCursorPosition();
            }
        }
        this.packColumns();
        this.updateSyncColSize();
        return true;
    }

    private void refreshTableViewer() {
        int i = this.fTableViewer.getTable().getTopIndex();
        this.fTableViewer.refresh();
        if (i != this.fTableViewer.getTable().getTopIndex()) {
            this.fTableViewer.getTable().setTopIndex(i);
        }
    }

    private void setColumnHeadings() {
        String[] columnLabels = new String[]{};
        IDebugModelPresentation presentation = DebugUIPlugin.getModelPresentation();
        if (presentation instanceof IMemoryBlockModelPresentation) {
            columnLabels = ((IMemoryBlockModelPresentation)presentation).getColumnLabels(this.getMemoryBlock(), this.fBytePerLine, this.fColumnSize);
        }
        if (columnLabels == null) {
            columnLabels = new String[]{};
        }
        int numByteColumns = this.fBytePerLine / this.fColumnSize;
        TableColumn[] columns = this.fTableViewer.getTable().getColumns();
        int j = 0;
        int i = 1;
        while (i < columns.length - 1) {
            if (columnLabels.length == numByteColumns) {
                columns[i].setText(columnLabels[j]);
                ++j;
            } else if (this.fColumnSize >= 4) {
                columns[i].setText(String.valueOf(Integer.toHexString(i * this.fColumnSize).toUpperCase()) + " - " + Integer.toHexString(i * this.fColumnSize + this.fColumnSize - 1).toUpperCase());
            } else {
                columns[i].setText(Integer.toHexString(i * this.fColumnSize).toUpperCase());
            }
            ++i;
        }
    }

    public void packColumns() {
        Table table = this.fTableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length - 1) {
            columns[i].pack();
            ++i;
        }
        if (this.fCursorManager != null && this.isAddressVisible(this.fSelectedAddress)) {
            this.fCursorManager.redrawCursors();
        }
        if (!this.fShowAddressColumn) {
            columns[0].setWidth(0);
        }
    }

    protected TabItem getTab() {
        return this.fTabItem;
    }

    protected void setCursorFocus() {
        if (!this.isAddressOutOfRange(this.fSelectedAddress) && this.fCursorManager != null) {
            this.fCursorManager.setCursorFocus();
        }
    }

    public IMemoryBlock getMemoryBlock() {
        IMemoryBlock mem = this.fMemoryBlock;
        return mem;
    }

    public void dispose() {
        try {
            ScrollBar scroll;
            this.fIsDisposed = true;
            if (this.fTableViewer != null) {
                this.fTableViewer.getControl().removeControlListener((ControlListener)this);
                this.fTableViewer.getControl().removeKeyListener((KeyListener)this);
                this.fTableViewer.getTable().removeSelectionListener((SelectionListener)this);
            }
            if (this.contentProvider != null) {
                this.contentProvider.dispose();
            }
            if ((scroll = ((Table)this.fTableViewer.getControl()).getVerticalBar()) != null) {
                scroll.removeSelectionListener((SelectionListener)this);
            }
            if (this.fCursorManager != null) {
                this.fCursorManager.dispose();
            }
            this.fTabItem.removeDisposeListener((DisposeListener)this.fTabFolderDisposeListener);
            this.fTabItem.dispose();
            this.fTextViewer = null;
            this.fTableViewer = null;
            int i = 0;
            while (i < this.fEditors.length) {
                this.fEditors[i].dispose();
                ++i;
            }
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fFontChangeListener);
            this.getMemoryBlockViewSynchronizer().removeView(this);
            DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer().removeSynchronizerListener(this);
            super.dispose();
        }
        catch (Exception exception) {}
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() instanceof ScrollBar) {
            this.handleScrollBarSelection(event);
        }
    }

    protected void updateTableSelection() {
        if (this.isAddressOutOfRange(this.fSelectedAddress)) {
            return;
        }
        int index = this.findAddressIndex(this.getTopVisibleAddress());
        this.fTableViewer.getTable().setSelection(this.fCursorManager.fRow);
        if (this.fTableViewer.getTable().getTopIndex() != index) {
            this.fTableViewer.getTable().setTopIndex(index);
        }
    }

    protected void updateSelectedAddress(TableItem row, int col) {
        int offset;
        String temp = ((MemoryViewLine)row.getData()).getAddress();
        BigInteger rowAddress = new BigInteger(temp, 16);
        if (col > 0) {
            int addressibleUnit = this.getAddressibleUnitPerColumn();
            offset = (col - 1) * addressibleUnit;
        } else {
            offset = 0;
        }
        this.setSelectedAddress(rowAddress.add(BigInteger.valueOf(offset)), true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.fTabCreated) {
            this.resizeTable();
        }
    }

    protected void handleKeyPressed(KeyEvent evt) {
        final KeyEvent event = evt;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (event.stateMask != 0) {
                    return;
                }
                if (event.getSource() instanceof Text) {
                    return;
                }
                if (event.character == '\r' && event.getSource() instanceof TableCursor) {
                    MemoryViewTab.this.fCursorManager.activateCellEditor(null);
                    return;
                }
                try {
                    switch (event.keyCode) {
                        case 0x1000001: 
                        case 0x1000002: 
                        case 0x1000003: 
                        case 0x1000004: 
                        case 0x1000005: 
                        case 0x1000006: 
                        case 0x1000007: 
                        case 0x1000008: {
                            if (MemoryViewTab.this.fMemoryBlock instanceof IMemoryBlockExtension) {
                                if (MemoryViewTab.this.isAddressOutOfRange(MemoryViewTab.this.fSelectedAddress)) {
                                    MemoryViewTab.this.reloadTable(MemoryViewTab.this.fSelectedAddress, false);
                                    MemoryViewTab.this.updateSyncTopAddress(true);
                                    MemoryViewTab.this.updateSyncSelectedAddress(true);
                                    MemoryViewTab.this.fCursorManager.setCursorFocus();
                                    break;
                                }
                                if (MemoryViewTab.this.needMoreLines()) {
                                    BigInteger topAddress = MemoryViewTab.this.getTopVisibleAddress();
                                    if (topAddress.compareTo(BigInteger.valueOf(96L)) <= 0) {
                                        if (topAddress.equals(BigInteger.valueOf(0L))) break;
                                        MemoryViewTab.this.reloadTable(BigInteger.valueOf(0L), false);
                                        MemoryViewTab.this.fCursorManager.setCursorFocus();
                                        break;
                                    }
                                    MemoryViewTab.this.reloadTable(topAddress, false);
                                    MemoryViewTab.this.fCursorManager.setCursorFocus();
                                    break;
                                }
                                if (!MemoryViewTab.this.isAddressVisible(MemoryViewTab.this.fSelectedAddress)) {
                                    MemoryViewTab.this.goToAddress(MemoryViewTab.this.fSelectedAddress);
                                    MemoryViewTab.this.fCursorManager.setCursorFocus();
                                    MemoryViewTab.this.updateSyncTopAddress(true);
                                    break;
                                }
                                MemoryViewTab.this.updateCursorPosition();
                                MemoryViewTab.this.fCursorManager.setCursorFocus();
                            }
                            break;
                        }
                        default: {
                            if (MemoryViewTab.this.isValidEditEvent(event.keyCode) && event.getSource() instanceof TableCursor) {
                                String initialValue = String.valueOf(event.character);
                                MemoryViewTab.this.fCursorManager.activateCellEditor(initialValue);
                            }
                            break;
                        }
                    }
                }
                catch (DebugException e) {
                    MemoryViewTab.this.displayError(e);
                    DebugUIPlugin.log(e.getStatus());
                }
            }
        });
    }

    public BigInteger getTopVisibleAddress() {
        if (this.fTableViewer == null) {
            return BigInteger.valueOf(0L);
        }
        Table table = this.fTableViewer.getTable();
        int topIndex = table.getTopIndex();
        if (topIndex < 1) {
            topIndex = 0;
        }
        if (table.getItemCount() > topIndex) {
            MemoryViewLine topItem = (MemoryViewLine)table.getItem(topIndex).getData();
            String calculatedAddress = null;
            calculatedAddress = topItem == null ? table.getItem(topIndex).getText() : topItem.getAddress();
            BigInteger bigInt = new BigInteger(calculatedAddress, 16);
            return bigInt;
        }
        return BigInteger.valueOf(0L);
    }

    protected synchronized void reloadTable(BigInteger topAddress, boolean updateDelta) throws DebugException {
        if (this.fTableViewer == null) {
            return;
        }
        Table table = (Table)this.fTableViewer.getControl();
        BigInteger topBufferAddress = topAddress;
        this.TABLE_PREBUFFER = topBufferAddress.compareTo(BigInteger.valueOf(32L)) <= 0 ? 0 : topBufferAddress.divide(BigInteger.valueOf(32L)).min(BigInteger.valueOf(this.TABLE_DEFAULTBUFFER)).intValue();
        int addressibleUnit = this.getAddressibleUnitPerLine();
        topBufferAddress = topAddress.subtract(BigInteger.valueOf(addressibleUnit * this.TABLE_PREBUFFER));
        long numLines = 0L;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            numLines = this.getNumberOfVisibleLines() + this.TABLE_PREBUFFER + this.TABLE_POSTBUFFER;
        }
        this.contentProvider.getMemoryToFitTable(topBufferAddress, numLines, updateDelta);
        this.contentProvider.forceRefresh();
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            int topIdx = this.findAddressIndex(topAddress);
            if (topIdx != -1) {
                table.setTopIndex(topIdx);
            }
            if (this.isAddressVisible(this.fSelectedAddress) && this.findAddressIndex(this.fSelectedAddress) != -1) {
                this.updateCursorPosition();
                int newIdx = this.findAddressIndex(this.getTopVisibleAddress());
                if (newIdx != topIdx && topIdx != -1) {
                    table.setTopIndex(topIdx);
                }
                if (this.isAddressVisible(this.fSelectedAddress)) {
                    this.fCursorManager.showCursor();
                } else {
                    this.fCursorManager.hideCursor();
                }
            } else {
                this.fCursorManager.hideCursor();
            }
        }
        this.displayTable();
    }

    private int findAddressIndex(BigInteger address) {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                MemoryViewLine line = (MemoryViewLine)items[i].getData();
                BigInteger lineAddress = new BigInteger(line.getAddress(), 16);
                int addressibleUnit = this.getAddressibleUnitPerLine();
                BigInteger endLineAddress = lineAddress.add(BigInteger.valueOf(addressibleUnit));
                if (lineAddress.compareTo(address) <= 0 && endLineAddress.compareTo(address) > 0) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private boolean updateCursorPosition() {
        if (this.fSelectedAddress.compareTo(this.contentProvider.getBufferTopAddress()) < 0) {
            return false;
        }
        int addressibleUnit = this.getAddressibleUnitPerLine();
        int numOfRows = this.fSelectedAddress.subtract(this.contentProvider.getBufferTopAddress()).intValue() / addressibleUnit;
        BigInteger rowAddress = this.contentProvider.getBufferTopAddress().add(BigInteger.valueOf(numOfRows * addressibleUnit));
        int row = this.findAddressIndex(this.fSelectedAddress);
        if (row == -1) {
            return false;
        }
        BigInteger offset = this.fSelectedAddress.subtract(rowAddress);
        int colAddressibleUnit = this.getAddressibleUnitPerColumn();
        int col = offset.intValue() / colAddressibleUnit + 1;
        int oldTop = this.fTableViewer.getTable().getTopIndex();
        this.fCursorManager.updateCursorPosition(row, col, this.isAddressVisible(this.fSelectedAddress));
        this.updateTableSelection();
        this.fTableViewer.getTable().setTopIndex(oldTop);
        if (this.isAddressVisible(this.fSelectedAddress)) {
            this.fCursorManager.showCursor();
            this.fTableViewer.getTable().deselectAll();
        } else {
            this.fCursorManager.hideCursor();
        }
        return true;
    }

    public int getNumberOfVisibleLines() {
        if (this.fTableViewer == null) {
            return -1;
        }
        Table table = this.fTableViewer.getTable();
        int height = this.fTableViewer.getTable().getSize().y;
        if (height == 0) {
            height = this.fTableViewer.getTable().getParent().getSize().y;
        }
        int border = this.fTableViewer.getTable().getHeaderHeight();
        int scroll = this.fTableViewer.getTable().getHorizontalBar().getSize().y;
        height = height - border - scroll;
        int lineHeight = table.getItemHeight();
        int numberOfLines = height / lineHeight;
        return numberOfLines;
    }

    public void refresh() {
        try {
            IMemoryBlock mem = this.fMemoryBlock;
            if (mem instanceof IMemoryBlockExtension) {
                BigInteger address = ((IMemoryBlockExtension)mem).getBigBaseAddress();
                if (address == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_GET_BASE_ADDRESS), null));
                    this.displayError(e);
                    return;
                }
                this.setTabName(mem, true);
                if (address.compareTo(this.contentProvider.getContentBaseAddress()) != 0) {
                    this.reloadTable(address, true);
                } else {
                    address = this.getTopVisibleAddress();
                    this.reloadTable(address, true);
                }
            } else {
                BigInteger address = BigInteger.valueOf(mem.getStartAddress());
                this.reloadTable(address, true);
            }
            if (this.isAddressVisible(this.fSelectedAddress)) {
                this.getCursorManager().redrawCursors();
            }
        }
        catch (DebugException e) {
            this.displayError(e);
            DebugUIPlugin.log(e.getStatus());
        }
    }

    private void resizeTable() {
        if (!(this.fMemoryBlock instanceof IMemoryBlockExtension)) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                boolean reloaded = false;
                if (MemoryViewTab.this.fTableViewer == null) {
                    return;
                }
                Table table = MemoryViewTab.this.fTableViewer.getTable();
                if (table.isDisposed()) {
                    return;
                }
                int topIndex = table.getTopIndex();
                if (topIndex < 0) {
                    return;
                }
                BigInteger oldTopAddress = MemoryViewTab.this.getTopVisibleAddress();
                MemoryViewTab.this.TABLE_PREBUFFER = oldTopAddress.compareTo(BigInteger.valueOf(32L)) <= 0 ? 0 : oldTopAddress.divide(BigInteger.valueOf(32L)).min(BigInteger.valueOf(MemoryViewTab.this.TABLE_DEFAULTBUFFER)).intValue();
                if (table.getItemCount() > topIndex) {
                    try {
                        if (MemoryViewTab.this.needMoreLines()) {
                            MemoryViewTab.this.reloadTable(oldTopAddress, false);
                            reloaded = true;
                        }
                        if (oldTopAddress.compareTo(BigInteger.valueOf(96L)) <= 0) {
                            MemoryViewTab.this.reloadTable(BigInteger.valueOf(0L), false);
                            reloaded = true;
                        }
                    }
                    catch (DebugException e) {
                        MemoryViewTab.this.displayError(e);
                        DebugUIPlugin.log(e.getStatus());
                    }
                }
                if (!reloaded) {
                    int i;
                    MemoryViewTab.this.updateCursorPosition();
                    MemoryViewTab.this.fTableViewer.getTable().deselectAll();
                    if (!MemoryViewTab.this.getTopVisibleAddress().equals(oldTopAddress) && (i = MemoryViewTab.this.findAddressIndex(oldTopAddress)) != -1) {
                        MemoryViewTab.this.fTableViewer.getTable().setTopIndex(i);
                    }
                }
                MemoryViewTab.this.updateSyncTopAddress(true);
            }
        });
    }

    private void handleScrollBarSelection(SelectionEvent event) {
        if (!(this.fMemoryBlock instanceof IMemoryBlockExtension)) {
            this.updateSyncTopAddress(true);
        }
        final SelectionEvent evt = event;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    switch (evt.detail) {
                        case 1: 
                        case 0x1000001: 
                        case 0x1000002: 
                        case 0x1000005: 
                        case 0x1000006: 
                        case 0x1000007: 
                        case 0x1000008: {
                            if (MemoryViewTab.this.fMemoryBlock instanceof IMemoryBlockExtension) {
                                MemoryViewTab.this.updateSyncTopAddress(true);
                                if (MemoryViewTab.this.needMoreLines()) {
                                    BigInteger topAddress = MemoryViewTab.this.getTopVisibleAddress();
                                    if (topAddress.compareTo(BigInteger.valueOf(96L)) <= 0) {
                                        if (topAddress.equals(BigInteger.valueOf(0L))) break;
                                        MemoryViewTab.this.reloadTable(BigInteger.valueOf(0L), false);
                                    } else {
                                        MemoryViewTab.this.reloadTable(topAddress, false);
                                    }
                                }
                            }
                            if (MemoryViewTab.this.isAddressVisible(MemoryViewTab.this.fSelectedAddress)) {
                                MemoryViewTab.this.updateCursorPosition();
                                MemoryViewTab.this.fCursorManager.setCursorFocus();
                            }
                            break;
                        }
                    }
                }
                catch (DebugException e) {
                    MemoryViewTab.this.displayError(e);
                    DebugUIPlugin.log(e.getStatus());
                }
            }
        });
    }

    public void setEnabled(boolean enable) {
        if (this.fEnabled == enable) {
            return;
        }
        super.setEnabled(enable);
        this.fEnabled = enable;
        IMemoryBlock mem = this.fMemoryBlock;
        if (this.fEnabled) {
            BigInteger oldBase = this.contentProvider.getContentBaseAddress();
            this.refresh();
            if (mem instanceof IMemoryBlockExtension) {
                BigInteger baseAddress = ((IMemoryBlockExtension)mem).getBigBaseAddress();
                if (baseAddress == null) {
                    baseAddress = this.fSelectedAddress != null ? this.fSelectedAddress : new BigInteger("0");
                }
                Object[] connected = ((IMemoryBlockExtension)mem).getConnected();
                if (!baseAddress.equals(oldBase) && connected.length == 1) {
                    this.setSelectedAddress(baseAddress, true);
                    this.updateCursorPosition();
                    this.updateSyncTopAddress(true);
                    this.updateSyncSelectedAddress(true);
                } else {
                    this.synchronize();
                }
            } else {
                this.synchronize();
            }
        } else {
            if (mem instanceof IMemoryBlockExtension) {
                this.setTabName(mem, false);
            }
            this.contentProvider.resetDeltas();
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    protected void displayError(DebugException e) {
        StyledText styleText = null;
        this.errorOccurred = true;
        if (this.fTextViewer == null) {
            this.fTextViewer = new TextViewer((Composite)this.fTabItem.getParent(), 0);
            this.fTabItem.setControl(this.fTextViewer.getControl());
            this.fTextViewer.setDocument((IDocument)new Document());
            styleText = this.fTextViewer.getTextWidget();
            styleText.setEditable(false);
            styleText.setEnabled(false);
        } else if (this.fTextViewer.getControl() != this.fTabItem.getControl()) {
            this.fTabItem.setControl(this.fTextViewer.getControl());
        }
        styleText = this.fTextViewer.getTextWidget();
        if (styleText != null) {
            styleText.setText(String.valueOf(DebugUIMessages.getString(ERROR)) + (Object)((Object)e));
        }
    }

    public boolean isDisplayingError() {
        if (this.fTextViewer == null) {
            return false;
        }
        return this.fTabItem.getControl() == this.fTextViewer.getControl();
    }

    public void displayTable() {
        if (this.fTableViewer != null && this.fTabItem.getControl() != this.fTableViewer.getControl()) {
            this.errorOccurred = false;
            this.fTabItem.setControl(this.fTableViewer.getControl());
        }
    }

    public void keyPressed(KeyEvent e) {
        this.handleKeyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
    }

    private CellEditor[] getCellEditors() {
        Table table = this.fTableViewer.getTable();
        this.fEditors = new CellEditor[table.getColumnCount()];
        int i = 0;
        while (i < this.fEditors.length) {
            this.fEditors[i] = new TextCellEditor((Composite)table);
            ++i;
        }
        return this.fEditors;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected ViewTabCursorManager getCursorManager() {
        return this.fCursorManager;
    }

    protected synchronized void setSelectedAddress(BigInteger address, boolean updateSynchronizer) {
        this.fSelectedAddress = address;
        this.updateSyncSelectedAddress(updateSynchronizer);
    }

    protected long getOffset(IMemoryBlock memory, String lineAddress, int lineOffset) {
        BigInteger lineAddr = new BigInteger(lineAddress, 16);
        BigInteger memoryAddr = memory instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)memory).getBigBaseAddress() : BigInteger.valueOf(memory.getStartAddress());
        if (memoryAddr == null) {
            memoryAddr = new BigInteger("0");
        }
        long offset = lineAddr.subtract(memoryAddr).longValue();
        return offset + (long)lineOffset;
    }

    public void resetAtBaseAddress() throws DebugException {
        IMemoryBlock mem = this.getMemoryBlock();
        if (mem instanceof IMemoryBlockExtension) {
            this.setCursorFocus();
            BigInteger address = ((IMemoryBlockExtension)mem).getBigBaseAddress();
            if (address == null) {
                Shell shell = DebugUIPlugin.getShell();
                MessageDialog.openError((Shell)shell, (String)DebugUIMessages.getString("DebugUITools.Error_1"), (String)DebugUIMessages.getString(UNABLE_TO_GET_BASE_ADDRESS));
                return;
            }
            this.setSelectedAddress(address, true);
            this.reloadTable(address, false);
            this.setCursorFocus();
        } else {
            BigInteger address = BigInteger.valueOf(mem.getStartAddress());
            this.setSelectedAddress(address, true);
            this.getTableViewer().getTable().setTopIndex(0);
            this.updateCursorPosition();
            this.updateTableSelection();
            this.setCursorFocus();
        }
        this.updateSyncTopAddress(true);
    }

    public void goToAddress(BigInteger address) throws DebugException {
        this.goToAddress(address, true);
        this.fCursorManager.setCursorFocus();
    }

    private void goToAddress(BigInteger address, boolean updateSynchronizer) throws DebugException {
        if (!this.isAddressOutOfRange(address)) {
            this.setSelectedAddress(address, false);
            this.updateCursorPosition();
            this.updateTableSelection();
            if (!this.isAddressVisible(this.fSelectedAddress)) {
                int i = this.findAddressIndex(this.fSelectedAddress);
                this.fTableViewer.getTable().showItem(this.fTableViewer.getTable().getItem(i));
                this.getCursorManager().showCursor();
                this.updateSyncTopAddress(updateSynchronizer);
            }
            this.updateSyncSelectedAddress(updateSynchronizer);
        } else {
            if (!(this.fMemoryBlock instanceof IMemoryBlockExtension)) {
                Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5011, DebugUIMessages.getString(ADDRESS_IS_OUT_OF_RANGE), null);
                DebugException e = new DebugException((IStatus)stat);
                throw e;
            }
            this.setSelectedAddress(address, updateSynchronizer);
            this.reloadTable(address, false);
            this.updateSyncTopAddress(updateSynchronizer);
        }
    }

    public int getBytesPerColumn() {
        return this.fColumnSize;
    }

    public int getBytesPerLine() {
        return this.fBytePerLine;
    }

    public int getAddressibleUnitPerLine() {
        return this.fBytePerLine / this.fAddressibleSize;
    }

    public int getAddressibleUnitPerColumn() {
        return this.fColumnSize / this.fAddressibleSize;
    }

    public void setFont(Font font) {
        int oldIdx = this.fTableViewer.getTable().getTopIndex();
        this.fTableViewer.getTable().setTopIndex(0);
        this.fTableViewer.getTable().setFont(font);
        this.fCursorManager.setFont(font);
        this.fTableViewer.getTable().setTopIndex(oldIdx);
        this.packColumns();
        this.updateCursorPosition();
    }

    public void setTabLabel(String label) {
        if (label != null) {
            this.fUpdateTabLabel = false;
            this.fTabItem.setText(label);
        }
    }

    public String getTabLabel() {
        if (this.fTabItem != null) {
            return this.fTabItem.getText();
        }
        return null;
    }

    private void columnSizeChanged(final int newColumnSize) {
        if (!this.isEnabled()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MemoryViewTab.this.format(MemoryViewTab.this.getBytesPerLine(), newColumnSize);
            }
        });
    }

    private void selectedAddressChanged(BigInteger address) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            if (!this.fSelectedAddress.equals(address)) {
                if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                    this.goToAddress(address, false);
                } else if (!this.isAddressOutOfRange(address)) {
                    this.goToAddress(address, false);
                }
            }
        }
        catch (DebugException e) {
            this.displayError(e);
        }
    }

    private void topVisibleAddressChanged(BigInteger address) {
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (!address.equals(this.getTopVisibleAddress())) {
                if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                    if (!this.isAddressOutOfRange(address)) {
                        int index = -1;
                        Table table = this.getTableViewer().getTable();
                        int i = 0;
                        while (i < table.getItemCount()) {
                            BigInteger lineAddress;
                            MemoryViewLine line = (MemoryViewLine)table.getItem(i).getData();
                            if (line != null && (lineAddress = new BigInteger(line.getAddress(), 16)).equals(address)) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                        if (index >= 3 && table.getItemCount() - (index + this.getNumberOfVisibleLines()) >= 3) {
                            table.setTopIndex(index);
                            if (!this.isAddressVisible(this.fSelectedAddress)) {
                                this.fCursorManager.hideCursor();
                            } else {
                                this.updateCursorPosition();
                                this.updateTableSelection();
                                table.setTopIndex(index);
                                this.fCursorManager.getLeadCursor().setVisible(false);
                                this.fCursorManager.getLeadCursor().setVisible(true);
                            }
                        } else {
                            this.reloadTable(address, false);
                        }
                    } else {
                        this.reloadTable(address, false);
                    }
                } else {
                    int index = -1;
                    Table table = this.getTableViewer().getTable();
                    int i = 0;
                    while (i < table.getItemCount()) {
                        BigInteger lineAddress;
                        MemoryViewLine line = (MemoryViewLine)table.getItem(i).getData();
                        if (line != null && (lineAddress = new BigInteger(line.getAddress(), 16)).equals(address)) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index >= 0) {
                        table.setTopIndex(index);
                        if (!this.isAddressVisible(this.fSelectedAddress)) {
                            this.fCursorManager.hideCursor();
                        } else {
                            this.updateCursorPosition();
                            this.updateTableSelection();
                            table.setTopIndex(index);
                            this.fCursorManager.getLeadCursor().setVisible(false);
                            this.fCursorManager.getLeadCursor().setVisible(true);
                        }
                    }
                }
            }
        }
        catch (DebugException e) {
            this.displayError(e);
        }
    }

    private boolean isAddressOutOfRange(BigInteger address) {
        return this.contentProvider.isAddressOutOfRange(address);
    }

    protected boolean isAddressVisible(BigInteger address) {
        if (!this.fTabCreated) {
            return true;
        }
        BigInteger topVisible = this.getTopVisibleAddress();
        int addressibleUnit = this.getAddressibleUnitPerLine();
        BigInteger lastVisible = this.getTopVisibleAddress().add(BigInteger.valueOf(this.getNumberOfVisibleLines() * addressibleUnit + addressibleUnit));
        return topVisible.compareTo(address) <= 0 && lastVisible.compareTo(address) > 0;
    }

    private void synchronize() {
        int colSize;
        IMemoryBlockViewSynchronizer synchronizer = DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer();
        if (!synchronizer.isEnabled()) {
            return;
        }
        Integer columnSize = (Integer)this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.columnSize");
        BigInteger selectedAddress = (BigInteger)this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.selectedAddress");
        BigInteger topAddress = (BigInteger)this.getSynchronizedProperty("org.eclipse.debug.ui.MemoryViewTab.topAddress");
        if (columnSize != null && (colSize = columnSize.intValue()) > 0 && colSize != this.fColumnSize) {
            this.columnSizeChanged(colSize);
        }
        if (topAddress != null && !topAddress.equals(this.getTopVisibleAddress())) {
            if (!this.fSelectedAddress.equals(selectedAddress)) {
                this.setSelectedAddress(selectedAddress, true);
            }
            this.topVisibleAddressChanged(topAddress);
        }
        if (selectedAddress != null && selectedAddress.compareTo(this.fSelectedAddress) != 0) {
            this.selectedAddressChanged(selectedAddress);
        }
    }

    public void propertyChanged(String propertyName, Object value) {
        if (this.isDisplayingError()) {
            return;
        }
        if (propertyName.equals("org.eclipse.debug.ui.MemoryViewTab.selectedAddress") && value instanceof BigInteger) {
            try {
                if (this.needMoreLines()) {
                    this.reloadTable(this.getTopVisibleAddress(), false);
                }
            }
            catch (DebugException e) {
                this.displayError(e);
            }
            this.selectedAddressChanged((BigInteger)value);
        } else if (propertyName.equals("org.eclipse.debug.ui.MemoryViewTab.columnSize") && value instanceof Integer) {
            this.columnSizeChanged((Integer)value);
        } else if (propertyName.equals("org.eclipse.debug.ui.MemoryViewTab.topAddress") && value instanceof BigInteger) {
            try {
                if (this.needMoreLines()) {
                    this.reloadTable(this.getTopVisibleAddress(), false);
                }
            }
            catch (DebugException e) {
                this.displayError(e);
            }
            this.topVisibleAddressChanged((BigInteger)value);
            return;
        }
    }

    public Object getProperty(String propertyId) {
        if (propertyId.equals("org.eclipse.debug.ui.MemoryViewTab.selectedAddress")) {
            return this.fSelectedAddress;
        }
        if (propertyId.equals("org.eclipse.debug.ui.MemoryViewTab.columnSize")) {
            return new Integer(this.fColumnSize);
        }
        if (propertyId.equals("org.eclipse.debug.ui.MemoryViewTab.topAddress")) {
            return this.getTopVisibleAddress();
        }
        return null;
    }

    public BigInteger getSelectedAddress() {
        return this.fSelectedAddress;
    }

    public String getSelectedContent() {
        if (this.fCursorManager.fCol == 0 || this.fCursorManager.fCol > this.getBytesPerLine() / this.getBytesPerColumn()) {
            return "";
        }
        TableItem tableItem = this.getTableViewer().getTable().getItem(this.fCursorManager.fRow);
        return tableItem.getText(this.fCursorManager.fCol);
    }

    protected void updateLabels() {
        this.setTabName(this.getMemoryBlock(), true);
        if (this.fTableViewer != null) {
            this.setColumnHeadings();
            this.refreshTableViewer();
        }
    }

    protected boolean needMoreLines() {
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            Table table = this.fTableViewer.getTable();
            TableItem firstItem = table.getItem(0);
            TableItem lastItem = table.getItem(table.getItemCount() - 1);
            if (firstItem == null || lastItem == null) {
                return true;
            }
            MemoryViewLine first = (MemoryViewLine)firstItem.getData();
            MemoryViewLine last = (MemoryViewLine)lastItem.getData();
            if (first == null || last == null) {
                return true;
            }
            BigInteger startAddress = new BigInteger(first.getAddress(), 16);
            BigInteger lastAddress = new BigInteger(last.getAddress(), 16);
            int addressibleUnit = this.getAddressibleUnitPerLine();
            lastAddress = lastAddress.add(BigInteger.valueOf(addressibleUnit));
            BigInteger topVisibleAddress = this.getTopVisibleAddress();
            long numVisibleLines = this.getNumberOfVisibleLines();
            long numOfBytes = numVisibleLines * (long)addressibleUnit;
            BigInteger lastVisibleAddrss = topVisibleAddress.add(BigInteger.valueOf(numOfBytes));
            BigInteger numTopLine = topVisibleAddress.subtract(startAddress).divide(BigInteger.valueOf(addressibleUnit));
            if (numTopLine.compareTo(BigInteger.valueOf(3L)) <= 0) {
                return true;
            }
            BigInteger numBottomLine = lastAddress.subtract(lastVisibleAddrss).divide(BigInteger.valueOf(addressibleUnit));
            return numBottomLine.compareTo(BigInteger.valueOf(3L)) <= 0;
        }
        return false;
    }

    private Object getSynchronizedProperty(String propertyId) {
        return this.getMemoryBlockViewSynchronizer().getSynchronizedProperty(this.getMemoryBlock(), propertyId);
    }

    public boolean isValidEditEvent(int event) {
        int i = 0;
        while (i < ignoreEvents.length) {
            if (event == ignoreEvents[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IMemoryBlockViewSynchronizer getMemoryBlockViewSynchronizer() {
        return DebugUIPlugin.getDefault().getMemoryBlockViewSynchronizer();
    }

    public void showAddressColumn(boolean show) {
        this.fShowAddressColumn = show;
        this.packColumns();
    }

    public boolean isShowAddressColumn() {
        return this.fShowAddressColumn;
    }

    public int getAddressibleSize() {
        return this.fAddressibleSize;
    }

    public void setAddressibleSize(int addressibleSize) {
        this.fAddressibleSize = addressibleSize;
    }

    public void synchronizerEnablementChanged(boolean enabled) {
        if (!this.isDisplayingError() && enabled && this.fEnabled) {
            this.synchronize();
        }
    }

    private final class TabFolderDisposeListener
    implements DisposeListener {
        MemoryViewTab fViewTab;

        TabFolderDisposeListener(MemoryViewTab viewTab) {
            this.fViewTab = viewTab;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (!this.fViewTab.fIsDisposed) {
                if (MemoryViewTab.this.contentProvider != null) {
                    MemoryViewTab.this.contentProvider.dispose();
                }
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)MemoryViewTab.this.fFontChangeListener);
                MemoryViewTab.this.getMemoryBlockViewSynchronizer().removeView(this.fViewTab);
            }
        }
    }

    class FontChangeListener
    implements IPropertyChangeListener {
        FontChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(IInternalDebugUIConstants.FONT_NAME) && !MemoryViewTab.this.fIsDisposed) {
                Font memoryViewFont = JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME);
                MemoryViewTab.this.setFont(memoryViewFont);
            }
        }
    }
}

