/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class RemoveMemoryBlockAction
extends AbstractMemoryAction {
    public RemoveMemoryBlockAction() {
        this.setText(DebugUIMessages.getString("RemoveMemoryBlockAction.title"));
        this.setToolTipText(DebugUIMessages.getString("RemoveMemoryBlockAction.tooltip"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_REMOVE_MEMORY"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_REMOVE_MEMORY"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_REMOVE_MEMORY"));
        WorkbenchHelp.setHelp((IAction)this, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".RemoveMemoryBlockAction_context"));
    }

    public void run() {
        if (this.getViewTab() == null) {
            return;
        }
        IMemoryViewTab topTab = this.getViewTab();
        if (topTab != null) {
            IMemoryBlock mem = topTab.getMemoryBlock();
            MemoryViewUtil.getMemoryBlockManager().removeMemoryBlocks(new IMemoryBlock[]{mem});
        }
    }

    IMemoryViewTab getViewTab() {
        String viewId = "org.eclipse.debug.ui.MemoryView";
        return super.getTopViewTabFromView(viewId);
    }
}

