/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.eclipse.ant.internal.ui.antsupport.logger.AntProcessBuildLogger;
import org.eclipse.ant.internal.ui.debug.IAntDebugController;
import org.eclipse.ant.internal.ui.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.ui.debug.model.AntThread;
import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IProcess;

public class AntProcessDebugBuildLogger
extends AntProcessBuildLogger
implements IAntDebugController {
    private boolean fStepOverSuspend = false;
    private boolean fStepIntoSuspend = false;
    private boolean fClientSuspend = false;
    private boolean fShouldSuspend = false;
    private Stack fTasks = new Stack();
    private Task fCurrentTask;
    private Task fStepOverTask;
    private Task fLastTaskFinished;
    private List fBreakpoints = null;
    private Map fProperties = null;
    private AntDebugTarget fTarget;

    public void buildStarted(BuildEvent event) {
        super.buildStarted(event);
        AntProcess process = this.getAntProcess(event.getProject().getUserProperty("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID"));
        ILaunch launch = process.getLaunch();
        this.fTarget = new AntDebugTarget(launch, (IProcess)process, (IAntDebugController)this);
        launch.addDebugTarget((IDebugTarget)this.fTarget);
        this.fTarget.buildStarted();
    }

    public void taskFinished(BuildEvent event) {
        super.taskFinished(event);
        this.fLastTaskFinished = (Task)this.fTasks.pop();
        this.fCurrentTask = null;
        this.waitIfSuspended();
    }

    public void taskStarted(BuildEvent event) {
        super.taskStarted(event);
        this.fCurrentTask = event.getTask();
        this.fTasks.push(this.fCurrentTask);
        this.waitIfSuspended();
    }

    private synchronized void waitIfSuspended() {
        if (this.fCurrentTask != null) {
            int detail = -1;
            boolean shouldSuspend = true;
            IBreakpoint breakpoint = this.breakpointAtLineNumber(this.fCurrentTask.getLocation());
            if (breakpoint != null) {
                detail = -2;
                this.fTarget.breakpointHit(breakpoint);
            } else if (this.fStepIntoSuspend) {
                detail = 8;
                this.fStepIntoSuspend = false;
            } else if (this.fStepOverSuspend) {
                if (this.fLastTaskFinished == this.fStepOverTask) {
                    detail = 8;
                    this.fStepOverSuspend = false;
                    this.fStepOverTask = null;
                } else {
                    shouldSuspend = false;
                }
            } else if (this.fClientSuspend) {
                detail = 32;
                this.fClientSuspend = false;
            } else {
                shouldSuspend = false;
            }
            if (shouldSuspend) {
                if (detail != -2) {
                    this.fTarget.suspended(detail);
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (this.fShouldSuspend) {
            try {
                this.fShouldSuspend = false;
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void resume() {
        this.notifyAll();
    }

    public synchronized void suspend() {
        this.fClientSuspend = true;
    }

    public synchronized void stepInto() {
        this.fStepIntoSuspend = true;
        this.notifyAll();
    }

    public synchronized void stepOver() {
        this.fStepOverSuspend = true;
        this.fStepOverTask = this.fCurrentTask;
        this.notifyAll();
    }

    public void handleBreakpoint(IBreakpoint breakpoint, boolean added) {
        if (added) {
            if (this.fBreakpoints == null) {
                this.fBreakpoints = new ArrayList();
            }
            this.fBreakpoints.add(breakpoint);
        } else {
            this.fBreakpoints.remove(breakpoint);
        }
    }

    public void getProperties() {
        StringBuffer propertiesRepresentation = new StringBuffer();
        propertiesRepresentation.append("prop");
        propertiesRepresentation.append(",");
        Hashtable currentProperties = null;
        if (!this.fTasks.isEmpty()) {
            currentProperties = ((Task)this.fTasks.peek()).getProject().getProperties();
            if (this.fProperties != null && currentProperties.size() == this.fProperties.size()) {
                ((AntThread)this.fTarget.getThreads()[0]).newProperties("no");
                return;
            }
            Iterator iter = currentProperties.keySet().iterator();
            while (iter.hasNext()) {
                String propertyName = (String)iter.next();
                if (propertyName.equals("line.separator") || this.fProperties != null && this.fProperties.get(propertyName) != null) continue;
                propertiesRepresentation.append(propertyName.length());
                propertiesRepresentation.append(",");
                propertiesRepresentation.append(propertyName);
                propertiesRepresentation.append(",");
                String propertyValue = (String)currentProperties.get(propertyName);
                propertiesRepresentation.append(propertyValue.length());
                propertiesRepresentation.append(",");
                propertiesRepresentation.append(propertyValue);
                propertiesRepresentation.append(",");
            }
        }
        this.fProperties = currentProperties;
        ((AntThread)this.fTarget.getThreads()[0]).newProperties(propertiesRepresentation.toString());
    }

    public void getStackFrames() {
        StringBuffer stackRepresentation = new StringBuffer();
        stackRepresentation.append("stack");
        stackRepresentation.append(",");
        int i = this.fTasks.size() - 1;
        while (i >= 0) {
            Task task = (Task)this.fTasks.get(i);
            stackRepresentation.append(task.getOwningTarget().getName());
            stackRepresentation.append(",");
            stackRepresentation.append(task.getTaskName());
            stackRepresentation.append(",");
            Location location = task.getLocation();
            stackRepresentation.append(location.getFileName());
            stackRepresentation.append(",");
            stackRepresentation.append(location.getLineNumber());
            stackRepresentation.append(",");
            --i;
        }
        ((AntThread)this.fTarget.getThreads()[0]).buildStack(stackRepresentation.toString());
    }

    private IBreakpoint breakpointAtLineNumber(Location location) {
        if (this.fBreakpoints == null) {
            return null;
        }
        int i = 0;
        while (i < this.fBreakpoints.size()) {
            int lineNumber;
            ILineBreakpoint breakpoint = (ILineBreakpoint)this.fBreakpoints.get(i);
            try {
                lineNumber = breakpoint.getLineNumber();
            }
            catch (CoreException coreException) {
                return null;
            }
            IFile resource = (IFile)breakpoint.getMarker().getResource();
            if (lineNumber == location.getLineNumber() && resource.getLocation().toFile().equals(new File(location.getFileName()))) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }
}

