/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;

public class CaseAction
extends TextEditorAction
implements IUpdate {
    private boolean fToUpper;

    public CaseAction(ResourceBundle bundle, String prefix, AbstractTextEditor editor, boolean toUpper) {
        super(bundle, prefix, editor);
        this.fToUpper = toUpper;
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer viewer = ((AbstractTextEditor)editor).getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText st = viewer.getTextWidget();
        if (st == null) {
            return;
        }
        Point sel = viewer.getSelectedRange();
        if (sel == null) {
            return;
        }
        try {
            String replacement;
            if (sel.y == 0 && sel.y == 0) {
                return;
            }
            String target = document.get(sel.x, sel.y);
            String string = replacement = this.fToUpper ? target.toUpperCase() : target.toLowerCase();
            if (!target.equals(replacement)) {
                document.replace(sel.x, target.length(), replacement);
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        viewer.setSelectedRange(sel.x, sel.y);
        st.showSelection();
    }
}

