/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.inputhandler;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.eclipse.ant.internal.ui.antsupport.RemoteAntMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SWTInputHandler
extends DefaultInputHandler {
    private Text fText;
    private Text fErrorMessageText;
    private Button fOkButton;
    private Shell fDialog;
    private FontMetrics fFontMetrics;
    protected InputRequest fRequest;
    private boolean fFirstValidation = true;

    public void handleInput(InputRequest request) throws BuildException {
        if (System.getProperty("eclipse.ant.noInput") != null) {
            throw new BuildException(RemoteAntMessages.getString("SWTInputHandler.0"));
        }
        this.fFirstValidation = true;
        this.fRequest = request;
        BuildException[] problem = new BuildException[1];
        Runnable runnable = this.getHandleInputRunnable(problem);
        Display.getDefault().syncExec(runnable);
        if (problem[0] != null) {
            throw problem[0];
        }
    }

    protected Runnable getHandleInputRunnable(final BuildException[] problem) {
        return new Runnable(){

            public void run() {
                String prompt = SWTInputHandler.this.getPrompt(SWTInputHandler.this.fRequest);
                String title = RemoteAntMessages.getString("SWTInputHandler.1");
                boolean[] result = new boolean[1];
                SWTInputHandler.this.open(title, prompt, result);
                if (!result[0]) {
                    problem[0] = new BuildException(RemoteAntMessages.getString("SWTInputHandler.2"));
                }
            }
        };
    }

    protected void open(String title, String prompt, boolean[] result) {
        this.createDialog(title, prompt, result);
        this.validateInput();
        this.fDialog.open();
        while (!this.fDialog.isDisposed()) {
            if (this.fDialog.getDisplay().readAndDispatch()) continue;
            this.fDialog.getDisplay().sleep();
        }
        Display.getDefault().dispose();
    }

    private void createDialog(String title, String prompt, boolean[] result) {
        Display display = Display.getDefault();
        this.fDialog = new Shell(display, 67680);
        this.initializeDialogUnits((Control)this.fDialog);
        this.fDialog.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4);
        gd.horizontalSpan = 2;
        this.fDialog.setLayoutData((Object)gd);
        this.fDialog.setText(title);
        Label label = new Label((Composite)this.fDialog, 64);
        label.setText(prompt);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(this.fDialog.getFont());
        this.fText = new Text((Composite)this.fDialog, 2052);
        this.fText.setLayoutData((Object)new GridData(768));
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SWTInputHandler.this.validateInput();
            }
        });
        this.fErrorMessageText = new Text((Composite)this.fDialog, 8);
        this.fErrorMessageText.setLayoutData((Object)new GridData(768));
        this.fErrorMessageText.setBackground(display.getSystemColor(22));
        this.createButtonBar((Composite)this.fDialog, result);
        this.fDialog.pack();
    }

    protected void setErrorMessage(String errorMessage) {
        this.fErrorMessageText.setText(errorMessage == null ? "" : errorMessage);
        this.fOkButton.setEnabled(errorMessage == null);
        this.fErrorMessageText.getParent().update();
    }

    protected void validateInput() {
        String errorMessage = null;
        this.fRequest.setInput(this.fText.getText());
        if (!this.fRequest.isInputValid()) {
            if (this.fFirstValidation) {
                errorMessage = "";
                this.fFirstValidation = false;
            } else {
                errorMessage = RemoteAntMessages.getString("SWTInputHandler.3");
            }
        }
        this.setErrorMessage(errorMessage);
    }

    protected Control createButtonBar(Composite parent, boolean[] result) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite, result);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent, final boolean[] result) {
        this.fOkButton = new Button(parent, 8);
        this.fOkButton.setText(RemoteAntMessages.getString("SWTInputHandler.4"));
        this.setButtonLayoutData(this.fOkButton);
        Button cancel = new Button(parent, 8);
        cancel.setText(RemoteAntMessages.getString("SWTInputHandler.5"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                result[0] = event.widget == SWTInputHandler.this.fOkButton;
                SWTInputHandler.this.fDialog.close();
            }
        };
        this.setButtonLayoutData(cancel);
        this.fOkButton.addListener(13, listener);
        this.fDialog.setDefaultButton(this.fOkButton);
        cancel.addListener(13, listener);
        this.fText.setFocus();
    }

    private void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    private int convertHorizontalDLUsToPixels(int dlus) {
        return (this.fFontMetrics.getAverageCharWidth() * dlus + 2) / 4;
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }
}

