/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Location;
import org.eclipse.ant.internal.ui.antsupport.AntSecurityException;
import org.eclipse.ant.internal.ui.antsupport.RemoteAntMessages;

public class RemoteAntBuildLogger
extends DefaultLogger {
    private long fStartTime = System.currentTimeMillis();
    private Socket fEventSocket;
    private PrintWriter fWriter;
    protected String fHost = "";
    private int fEventPort = -1;
    protected boolean fDebugMode = false;
    protected boolean fSentProcessId = false;
    private List fEventQueue;

    protected void printMessage(String message, PrintStream stream, int priority) {
        this.marshalMessage(priority, message);
    }

    protected void connect() {
        if (this.fDebugMode) {
            System.out.println("RemoteAntBuildLogger: trying to connect" + this.fHost + ":" + this.fEventPort);
        }
        int i = 1;
        while (i < 5) {
            try {
                this.fEventSocket = new Socket(this.fHost, this.fEventPort);
                this.fWriter = new PrintWriter(this.fEventSocket.getOutputStream(), true);
                return;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        this.shutDown();
    }

    protected void shutDown() {
        if (this.fEventQueue != null) {
            this.fEventQueue.clear();
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fEventSocket != null) {
                this.fEventSocket.close();
                this.fEventSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    private void sendMessage(String msg) {
        if (this.fWriter == null) {
            return;
        }
        this.fWriter.println(msg);
    }

    public void buildFinished(BuildEvent event) {
        if (!this.fSentProcessId) {
            this.establishConnection(event);
        }
        this.handleException(event);
        this.printMessage(this.getTimeString(System.currentTimeMillis() - this.fStartTime), this.out, 2);
        this.shutDown();
    }

    protected void handleException(BuildEvent event) {
        Throwable exception = event.getException();
        if (exception == null || exception instanceof AntSecurityException) {
            return;
        }
        this.printMessage(MessageFormat.format(RemoteAntMessages.getString("RemoteAntBuildLogger.BUILD_FAILED__{0}_1"), exception.toString()), this.out, 0);
    }

    private String getTimeString(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        StringBuffer result = new StringBuffer(RemoteAntMessages.getString("RemoteAntBuildLogger.Total_time"));
        if (minutes > 0L) {
            result.append(minutes);
            if (minutes > 1L) {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._minutes_2"));
            } else {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._minute_3"));
            }
        }
        if (seconds > 0L) {
            if (minutes > 0L) {
                result.append(' ');
            }
            result.append(seconds);
            if (seconds > 1L) {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._seconds_4"));
            } else {
                result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._second_5"));
            }
        }
        if (seconds == 0L && minutes == 0L) {
            result.append(milliseconds);
            result.append(RemoteAntMessages.getString("RemoteAntBuildLogger._milliseconds_6"));
        }
        return result.toString();
    }

    public void targetStarted(BuildEvent event) {
        if (!this.fSentProcessId) {
            this.establishConnection(event);
        }
        if (2 <= this.msgOutputLevel) {
            String msg = String.valueOf(event.getTarget().getName()) + ":";
            this.printMessage(msg, this.out, 2);
        }
    }

    protected void establishConnection(BuildEvent event) {
        String portProperty = event.getProject().getProperty("eclipse.connect.port");
        if (portProperty == null) {
            this.shutDown();
            return;
        }
        this.fEventPort = Integer.parseInt(portProperty);
        this.connect();
        this.fSentProcessId = true;
        StringBuffer message = new StringBuffer("processID");
        message.append(event.getProject().getProperty("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID"));
        this.sendMessage(message.toString());
        if (this.fEventQueue != null) {
            Iterator iter = this.fEventQueue.iterator();
            while (iter.hasNext()) {
                this.processEvent((BuildEvent)iter.next());
            }
            this.fEventQueue = null;
        }
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() > this.msgOutputLevel && event.getPriority() != 5) {
            return;
        }
        if (!this.fSentProcessId) {
            if (event.getPriority() == 5) {
                if (2 > this.msgOutputLevel) {
                    return;
                }
                this.establishConnection(event);
                return;
            }
            if (this.fEventQueue == null) {
                this.fEventQueue = new ArrayList(10);
            }
            this.fEventQueue.add(event);
            return;
        }
        this.processEvent(event);
    }

    private void processEvent(BuildEvent event) {
        if (event.getTask() != null & !this.emacsMode) {
            try {
                this.marshalTaskMessage(event);
            }
            catch (IOException iOException) {}
        } else {
            this.marshalMessage(event);
        }
    }

    private void marshalMessage(BuildEvent event) {
        String eventMessage = event.getMessage().trim();
        if (eventMessage.length() == 0) {
            return;
        }
        this.marshalMessage(event.getPriority(), eventMessage);
    }

    protected void marshalMessage(int priority, String message) {
        try {
            BufferedReader r = new BufferedReader(new StringReader(message));
            String line = r.readLine();
            while (line != null) {
                StringBuffer messageLine = new StringBuffer();
                if (priority != -1) {
                    messageLine.append(priority);
                    messageLine.append(',');
                }
                messageLine.append(line);
                this.sendMessage(messageLine.toString());
                line = r.readLine();
            }
        }
        catch (IOException iOException) {}
    }

    private void marshalTaskMessage(BuildEvent event) throws IOException {
        String eventMessage = event.getMessage().trim();
        if (eventMessage.length() == 0) {
            return;
        }
        BufferedReader r = new BufferedReader(new StringReader(eventMessage));
        String line = r.readLine();
        String taskName = event.getTask().getTaskName();
        StringBuffer labelBuff = new StringBuffer();
        labelBuff.append('[');
        labelBuff.append(taskName);
        labelBuff.append("] ");
        String label = labelBuff.toString();
        Location location = event.getTask().getLocation();
        int priority = event.getPriority();
        while (line != null) {
            StringBuffer message = new StringBuffer("task");
            message.append(priority);
            message.append(',');
            message.append(taskName);
            message.append(',');
            line = (String.valueOf(label) + line).trim();
            message.append(line.length());
            message.append(',');
            message.append(line);
            message.append(',');
            message.append(location);
            this.sendMessage(message.toString());
            line = r.readLine();
        }
    }

    public void buildStarted(BuildEvent event) {
        this.establishConnection(event);
        super.buildStarted(event);
    }
}

