/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.eclipse.ant.internal.ui.antsupport.logger.RemoteAntBuildLogger;
import org.eclipse.ant.internal.ui.antsupport.logger.debug.RemoteAntBreakpoint;

public class RemoteAntDebugBuildLogger
extends RemoteAntBuildLogger {
    private ServerSocket fServerSocket;
    private Socket fRequestSocket;
    private PrintWriter fRequestWriter;
    private BufferedReader fRequestReader;
    protected boolean fStepOverSuspend = false;
    protected boolean fStepIntoSuspend = false;
    protected boolean fClientSuspend = false;
    protected boolean fShouldSuspend = false;
    private Stack fTasks = new Stack();
    private Task fCurrentTask;
    private Task fStepOverTask;
    private Task fLastTaskFinished;
    private List fBreakpoints = null;
    private Map fProperties = null;
    protected int fRequestPort = -1;

    private void requestConnect() {
        if (this.fDebugMode) {
            System.out.println("RemoteAntDebugBuildLogger: trying to connect" + this.fHost + ":" + this.fRequestPort);
        }
        try {
            this.fRequestSocket = this.fServerSocket.accept();
            this.fRequestWriter = new PrintWriter(this.fRequestSocket.getOutputStream(), true);
            this.fRequestReader = new BufferedReader(new InputStreamReader(this.fRequestSocket.getInputStream()));
            ReaderThread readerThread = new ReaderThread();
            readerThread.setDaemon(true);
            readerThread.start();
            return;
        }
        catch (IOException iOException) {
            this.shutDown();
            return;
        }
    }

    protected void shutDown() {
        if (this.fRequestWriter != null) {
            this.fRequestWriter.close();
            this.fRequestWriter = null;
        }
        if (this.fRequestReader != null) {
            try {
                this.fRequestReader.close();
            }
            catch (IOException iOException) {}
            this.fRequestReader = null;
        }
        if (this.fRequestSocket != null) {
            try {
                this.fRequestSocket.close();
            }
            catch (IOException iOException) {}
        }
        this.fRequestSocket = null;
        super.shutDown();
    }

    public void buildStarted(BuildEvent event) {
        super.buildStarted(event);
        this.marshalMessage(-1, "build_started");
        String requestPortProperty = event.getProject().getProperty("eclipse.connect.request_port");
        if (requestPortProperty != null) {
            this.fRequestPort = Integer.parseInt(requestPortProperty);
            try {
                this.fServerSocket = new ServerSocket(this.fRequestPort);
            }
            catch (IOException iOException) {
                this.shutDown();
            }
            this.requestConnect();
        } else {
            this.shutDown();
        }
        this.fShouldSuspend = true;
        this.waitIfSuspended();
    }

    public void taskStarted(BuildEvent event) {
        super.taskStarted(event);
        this.fCurrentTask = event.getTask();
        this.fTasks.push(this.fCurrentTask);
        this.waitIfSuspended();
    }

    public void taskFinished(BuildEvent event) {
        super.taskFinished(event);
        this.fLastTaskFinished = (Task)this.fTasks.pop();
        this.fCurrentTask = null;
        this.waitIfSuspended();
    }

    private synchronized void waitIfSuspended() {
        if (this.fCurrentTask != null) {
            String detail = null;
            boolean shouldSuspend = true;
            RemoteAntBreakpoint breakpoint = this.breakpointAtLineNumber(this.fCurrentTask.getLocation());
            if (breakpoint != null) {
                detail = breakpoint.toMarshallString();
            } else if (this.fStepIntoSuspend) {
                detail = "step";
                this.fStepIntoSuspend = false;
            } else if (this.fStepOverSuspend) {
                if (this.fLastTaskFinished == this.fStepOverTask) {
                    detail = "step";
                    this.fStepOverSuspend = false;
                    this.fStepOverTask = null;
                } else {
                    shouldSuspend = false;
                }
            } else if (this.fClientSuspend) {
                detail = "client";
                this.fClientSuspend = false;
            } else {
                shouldSuspend = false;
            }
            if (shouldSuspend) {
                StringBuffer message = new StringBuffer("suspended");
                message.append(detail);
                this.sendRequestResponse(message.toString());
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (this.fShouldSuspend) {
            try {
                this.fShouldSuspend = false;
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private RemoteAntBreakpoint breakpointAtLineNumber(Location location) {
        if (this.fBreakpoints == null) {
            return null;
        }
        int i = 0;
        while (i < this.fBreakpoints.size()) {
            RemoteAntBreakpoint breakpoint = (RemoteAntBreakpoint)this.fBreakpoints.get(i);
            if (breakpoint.isAt(location)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    private void sendRequestResponse(String message) {
        if (this.fRequestWriter == null) {
            return;
        }
        this.fRequestWriter.println(message);
    }

    protected void marshallStack() {
        StringBuffer stackRepresentation = new StringBuffer();
        stackRepresentation.append("stack");
        stackRepresentation.append(",");
        int i = this.fTasks.size() - 1;
        while (i >= 0) {
            Task task = (Task)this.fTasks.get(i);
            stackRepresentation.append(task.getOwningTarget().getName());
            stackRepresentation.append(",");
            stackRepresentation.append(task.getTaskName());
            stackRepresentation.append(",");
            Location location = task.getLocation();
            stackRepresentation.append(location.getFileName());
            stackRepresentation.append(",");
            stackRepresentation.append(location.getLineNumber());
            stackRepresentation.append(",");
            --i;
        }
        this.sendRequestResponse(stackRepresentation.toString());
    }

    protected void marshallProperties() {
        StringBuffer propertiesRepresentation = new StringBuffer();
        propertiesRepresentation.append("prop");
        propertiesRepresentation.append(",");
        Hashtable currentProperties = null;
        if (!this.fTasks.isEmpty()) {
            currentProperties = ((Task)this.fTasks.peek()).getProject().getProperties();
            if (this.fProperties != null && currentProperties.size() == this.fProperties.size()) {
                this.sendRequestResponse(propertiesRepresentation.toString());
                return;
            }
            Iterator iter = currentProperties.keySet().iterator();
            while (iter.hasNext()) {
                String propertyName = (String)iter.next();
                if (propertyName.equals("line.separator") || this.fProperties != null && this.fProperties.get(propertyName) != null) continue;
                propertiesRepresentation.append(propertyName.length());
                propertiesRepresentation.append(",");
                propertiesRepresentation.append(propertyName);
                propertiesRepresentation.append(",");
                String propertyValue = (String)currentProperties.get(propertyName);
                propertiesRepresentation.append(propertyValue.length());
                propertiesRepresentation.append(",");
                propertiesRepresentation.append(propertyValue);
                propertiesRepresentation.append(",");
            }
        }
        propertiesRepresentation.deleteCharAt(propertiesRepresentation.length() - 1);
        this.fProperties = currentProperties;
        this.sendRequestResponse(propertiesRepresentation.toString());
    }

    protected void addBreakpoint(String breakpointRepresentation) {
        if (this.fBreakpoints == null) {
            this.fBreakpoints = new ArrayList();
        }
        this.fBreakpoints.add(new RemoteAntBreakpoint(breakpointRepresentation));
    }

    protected void removeBreakpoint(String breakpointRepresentation) {
        if (this.fBreakpoints == null) {
            return;
        }
        RemoteAntBreakpoint equivalentBreakpoint = new RemoteAntBreakpoint(breakpointRepresentation);
        Iterator iter = this.fBreakpoints.iterator();
        while (iter.hasNext()) {
            RemoteAntBreakpoint breakpoint = (RemoteAntBreakpoint)iter.next();
            if (!breakpoint.equals(equivalentBreakpoint)) continue;
            iter.remove();
            return;
        }
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("ReaderThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String message = null;
                while (RemoteAntDebugBuildLogger.this.fRequestReader != null) {
                    RemoteAntDebugBuildLogger remoteAntDebugBuildLogger;
                    message = RemoteAntDebugBuildLogger.this.fRequestReader.readLine();
                    if (message == null) continue;
                    if (message.startsWith("step_into")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            RemoteAntDebugBuildLogger.this.fStepIntoSuspend = true;
                            ((Object)((Object)RemoteAntDebugBuildLogger.this)).notifyAll();
                        }
                    }
                    if (message.startsWith("step_over")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            RemoteAntDebugBuildLogger.this.fStepOverSuspend = true;
                            RemoteAntDebugBuildLogger.this.fStepOverTask = RemoteAntDebugBuildLogger.this.fCurrentTask;
                            ((Object)((Object)RemoteAntDebugBuildLogger.this)).notifyAll();
                            continue;
                        }
                    }
                    if (message.startsWith("suspend")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            RemoteAntDebugBuildLogger.this.fClientSuspend = true;
                            continue;
                        }
                    }
                    if (message.startsWith("resume")) {
                        remoteAntDebugBuildLogger = RemoteAntDebugBuildLogger.this;
                        synchronized (remoteAntDebugBuildLogger) {
                            ((Object)((Object)RemoteAntDebugBuildLogger.this)).notifyAll();
                            continue;
                        }
                    }
                    if (message.startsWith("terminate")) {
                        RemoteAntDebugBuildLogger.this.sendRequestResponse("terminated");
                        RemoteAntDebugBuildLogger.this.shutDown();
                        continue;
                    }
                    if (message.startsWith("stack")) {
                        RemoteAntDebugBuildLogger.this.marshallStack();
                        continue;
                    }
                    if (message.startsWith("add")) {
                        RemoteAntDebugBuildLogger.this.addBreakpoint(message);
                        continue;
                    }
                    if (message.startsWith("remove")) {
                        RemoteAntDebugBuildLogger.this.removeBreakpoint(message);
                        continue;
                    }
                    if (!message.startsWith("prop")) continue;
                    RemoteAntDebugBuildLogger.this.marshallProperties();
                }
            }
            catch (Exception exception) {
                RemoteAntDebugBuildLogger.this.shutDown();
            }
        }
    }
}

