/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.internal.core.AntCoreUtil;
import org.eclipse.ant.internal.ui.AntUIModelMessages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.launchConfigurations.AntHomeClasspathEntry;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class AntUtil {
    public static final String ATTRIBUTE_SEPARATOR = ",";
    public static final char ANT_CLASSPATH_DELIMITER = '*';
    public static final String ANT_HOME_CLASSPATH_PLACEHOLDER = "G";
    public static final String ANT_GLOBAL_USER_CLASSPATH_PLACEHOLDER = "UG";

    private AntUtil() {
    }

    public static String combineStrings(String[] strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strings.length - 1) {
            buf.append(strings[i]);
            buf.append(ATTRIBUTE_SEPARATOR);
            ++i;
        }
        buf.append(strings[strings.length - 1]);
        return buf.toString();
    }

    public static String[] getTargetNames(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
        if (attribute == null) {
            return null;
        }
        return AntUtil.parseRunTargets(attribute);
    }

    public static Map getProperties(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
        return map;
    }

    public static String getAntHome(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry2 entry2;
            IRuntimeClasspathEntry entry = entries[i];
            if (entry.getType() == 5 && (entry2 = (IRuntimeClasspathEntry2)entry).getTypeId().equals("org.eclipse.ant.ui.classpathentry.antHome")) {
                return ((AntHomeClasspathEntry)entry2).getAntHome();
            }
            ++i;
        }
        return null;
    }

    public static String[] getPropertyFiles(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        if (attribute == null) {
            return null;
        }
        String[] propertyFiles = AntUtil.parseString(attribute, ATTRIBUTE_SEPARATOR);
        int i = 0;
        while (i < propertyFiles.length) {
            String propertyFile = propertyFiles[i];
            propertyFiles[i] = propertyFile = AntUtil.expandVariableString(propertyFile, AntUIModelMessages.getString("AntUtil.6"));
            ++i;
        }
        return propertyFiles;
    }

    public static AntTargetNode[] getTargets(String path, ILaunchConfiguration config) throws CoreException {
        File buildfile = AntUtil.getBuildFile(path);
        if (buildfile == null) {
            return null;
        }
        URL[] urls = AntUtil.getCustomClasspath(config);
        IAntModel model = AntUtil.getAntModel(buildfile, urls, false, false, false);
        model.setProperties(AntUtil.getAllProperties(config));
        model.setPropertyFiles(AntUtil.getPropertyFiles(config));
        AntProjectNode project = model.getProjectNode();
        model.dispose();
        return AntUtil.getTargets(project);
    }

    private static Map getAllProperties(ILaunchConfiguration config) throws CoreException {
        Map configProperties;
        String[] arguments = ExternalToolsUtil.getArguments((ILaunchConfiguration)config);
        HashMap properties = new HashMap();
        if (arguments != null) {
            AntCoreUtil.processMinusDProperties((List)AntCoreUtil.getArrayList((String[])arguments), properties);
        }
        if ((configProperties = AntUtil.getProperties(config)) != null) {
            Iterator keys = configProperties.keySet().iterator();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                if (properties.get(name) != null) continue;
                properties.put(name, configProperties.get(name));
            }
        }
        return properties;
    }

    private static AntTargetNode[] getTargets(AntProjectNode project) {
        if (project == null || !project.hasChildren()) {
            return null;
        }
        ArrayList<AntElementNode> targets = new ArrayList<AntElementNode>();
        Iterator possibleTargets = project.getChildNodes().iterator();
        while (possibleTargets.hasNext()) {
            AntElementNode node = (AntElementNode)possibleTargets.next();
            if (!(node instanceof AntTargetNode)) continue;
            targets.add(node);
        }
        if (targets.size() == 0) {
            return null;
        }
        return targets.toArray(new AntTargetNode[targets.size()]);
    }

    public static AntTargetNode[] getTargets(String path) {
        File buildfile = AntUtil.getBuildFile(path);
        if (buildfile == null) {
            return null;
        }
        IAntModel model = AntUtil.getAntModel(buildfile, null, false, true, true);
        AntProjectNode project = model.getProjectNode();
        if (project == null) {
            model.dispose();
            return null;
        }
        return AntUtil.getTargets(project);
    }

    public static IAntModel getAntModel(String buildFilePath, boolean needsLexicalResolution, boolean needsPositionResolution, boolean needsTaskResolution) {
        IAntModel model = AntUtil.getAntModel(AntUtil.getBuildFile(buildFilePath), null, needsLexicalResolution, needsPositionResolution, needsTaskResolution);
        return model;
    }

    private static File getBuildFile(String path) {
        File buildFile = new File(path);
        if (!buildFile.isFile() || !buildFile.exists()) {
            return null;
        }
        return buildFile;
    }

    private static IAntModel getAntModel(final File buildFile, URL[] urls, boolean needsLexical, boolean needsPosition, boolean needsTask) {
        if (buildFile == null || !buildFile.exists()) {
            return null;
        }
        IDocument doc = AntUtil.getDocument(buildFile);
        if (doc == null) {
            return null;
        }
        final IFile file = AntUtil.getFileForLocation(buildFile.getAbsolutePath(), null);
        LocationProvider provider = new LocationProvider(null){

            public IFile getFile() {
                return file;
            }

            public IPath getLocation() {
                if (file == null) {
                    return new Path(buildFile.getAbsolutePath());
                }
                return file.getLocation();
            }
        };
        AntModel model = new AntModel(doc, null, provider, needsLexical, needsPosition, needsTask);
        if (urls != null) {
            model.setClassLoader(AntCorePlugin.getPlugin().getNewClassLoader(urls));
        }
        return model;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IDocument getDocument(File buildFile) {
        IDocument iDocument;
        FileInputStream in;
        block11: {
            Document document;
            block10: {
                in = null;
                try {
                    try {
                        in = new FileInputStream(buildFile);
                        String content = AntUtil.getStreamContentAsString(in);
                        if (content != null) {
                            document = new Document(content);
                            Object var3_6 = null;
                            if (in == null) return document;
                            break block10;
                        }
                        iDocument = null;
                        break block11;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        IDocument iDocument2 = null;
                        Object var3_8 = null;
                        if (in == null) return iDocument2;
                        try {
                            ((InputStream)in).close();
                            return iDocument2;
                        }
                        catch (IOException iOException) {}
                        return iDocument2;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    if (in == null) throw throwable;
                    try {}
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    ((InputStream)in).close();
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)in).close();
            return document;
        }
        Object var3_7 = null;
        if (in == null) return iDocument;
        try {}
        catch (IOException iOException) {}
        ((InputStream)in).close();
        return iDocument;
    }

    private static String getStreamContentAsString(InputStream inputStream) {
        String string;
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(inputStream, ResourcesPlugin.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            AntUIPlugin.log(e);
            return "";
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            string = AntUtil.getReaderContentAsString(bufferedReader);
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    private static String getReaderContentAsString(BufferedReader bufferedReader) {
        StringBuffer result = new StringBuffer();
        try {
            char[] readBuffer = new char[2048];
            int n = bufferedReader.read(readBuffer);
            while (n > 0) {
                result.append(readBuffer, 0, n);
                n = bufferedReader.read(readBuffer);
            }
        }
        catch (IOException e) {
            AntUIPlugin.log(e);
            return null;
        }
        return result.toString();
    }

    public static URL[] getCustomClasspath(ILaunchConfiguration config) throws CoreException {
        boolean useDefault = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            return null;
        }
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
        ArrayList<IRuntimeClasspathEntry> userEntries = new ArrayList<IRuntimeClasspathEntry>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[i];
            if (entry.getClasspathProperty() == 3) {
                userEntries.add(entry);
            }
            ++i;
        }
        IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])userEntries.toArray(new IRuntimeClasspathEntry[userEntries.size()]), (ILaunchConfiguration)config);
        URL[] urls = new URL[entries.length];
        int i2 = 0;
        while (i2 < entries.length) {
            IRuntimeClasspathEntry entry = entries[i2];
            try {
                urls[i2] = new URL("file:" + entry.getLocation());
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, AntUIPlugin.getUniqueIdentifier(), 120, AntUIModelMessages.getString("AntUtil.7"), (Throwable)e));
            }
            ++i2;
        }
        return urls;
    }

    private static String expandVariableString(String variableString, String invalidMessage) throws CoreException {
        String expandedString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(variableString);
        if (expandedString == null || expandedString.length() == 0) {
            String msg = MessageFormat.format(invalidMessage, variableString);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ant.ui", 0, msg, null));
        }
        return expandedString;
    }

    public static String[] parseRunTargets(String extraAttibuteValue) {
        return AntUtil.parseString(extraAttibuteValue, ATTRIBUTE_SEPARATOR);
    }

    public static String[] parseString(String delimString, String delim) {
        if (delimString == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(delimString, delim);
        String[] results = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < results.length) {
            results[i] = tokenizer.nextToken();
            ++i;
        }
        return results;
    }

    public static IFile getFile(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFile((IPath)new Path(fullPath));
    }

    public static IHyperlink getTaskLink(String path, File buildFileParent) {
        String fileName;
        IFile file;
        int index;
        if ((path = path.trim()).length() == 0) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5, path.length());
        }
        if ((index = path.lastIndexOf(58)) == path.length() - 1) {
            path = path.substring(0, index);
            index = path.lastIndexOf(58);
        }
        if ((file = AntUtil.getFileForLocation(fileName = path.substring(0, index), buildFileParent)) != null) {
            try {
                String lineNumber = path.substring(index + 1);
                int line = Integer.parseInt(lineNumber);
                return new FileLink(file, null, -1, -1, line);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public static IFile getFileForLocation(String path, File buildFileParent) {
        Path filePath = new Path(path);
        IFile file = null;
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
        if (files.length > 0) {
            file = files[0];
        }
        if (file == null) {
            File relativeFile = null;
            try {
                relativeFile = FileUtils.newFileUtils().resolveFile(buildFileParent, path);
                filePath = new Path(relativeFile.getAbsolutePath());
                files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
                if (files.length <= 0) {
                    return null;
                }
                file = files[0];
            }
            catch (BuildException buildException) {
                return null;
            }
        }
        if (file.exists()) {
            return file;
        }
        File ioFile = file.getLocation().toFile();
        if (ioFile.exists()) {
            try {
                files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(ioFile.getCanonicalPath()));
                if (files.length > 0) {
                    return files[0];
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static void migrateToNewClasspathFormat(ILaunchConfiguration configuration) throws CoreException {
        String oldClasspath = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        String oldAntHome = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
        String provider = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        if (oldClasspath != null || oldAntHome != null || provider == null) {
            ILaunchConfigurationWorkingCopy workingCopy = null;
            workingCopy = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            if (oldAntHome != null) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
                ArrayList<String> mementos = new ArrayList<String>(entries.length);
                int i = 0;
                while (i < entries.length) {
                    IRuntimeClasspathEntry2 entry2;
                    IRuntimeClasspathEntry entry = entries[i];
                    if (entry.getType() == 5 && (entry2 = (IRuntimeClasspathEntry2)entry).getTypeId().equals("org.eclipse.ant.ui.classpathentry.antHome")) {
                        AntHomeClasspathEntry homeEntry = new AntHomeClasspathEntry(oldAntHome);
                        mementos.add(homeEntry.getMemento());
                    } else {
                        mementos.add(entry.getMemento());
                    }
                    ++i;
                }
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
            }
            workingCopy.doSave();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getOffset(int line, int column, ITextEditor editor) {
        IEditorInput input;
        IDocumentProvider provider;
        block8: {
            int n;
            block10: {
                int n2;
                block9: {
                    provider = editor.getDocumentProvider();
                    input = editor.getEditorInput();
                    try {
                        provider.connect((Object)input);
                    }
                    catch (CoreException coreException) {
                        return -1;
                    }
                    try {
                        try {
                            IDocument document = provider.getDocument((Object)input);
                            if (document == null) break block8;
                            if (column > -1) {
                                n2 = document.getLineOffset(line - 1) + column - 1 - 2;
                                Object var6_8 = null;
                                break block9;
                            }
                            n = document.getLineOffset(line - 1);
                            break block10;
                        }
                        catch (BadLocationException badLocationException) {
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        provider.disconnect((Object)input);
                        throw throwable;
                    }
                }
                provider.disconnect((Object)input);
                return n2;
            }
            Object var6_9 = null;
            provider.disconnect((Object)input);
            return n;
        }
        Object var6_11 = null;
        provider.disconnect((Object)input);
        return -1;
    }

    public static void openInEditor(IWorkbenchPage page, IEditorDescriptor editorDescriptor, AntElementNode node) {
        IEditorPart editorPart = null;
        IFile fileResource = node.getIFile();
        try {
            editorPart = editorDescriptor == null ? page.openEditor((IEditorInput)new FileEditorInput(fileResource), "org.eclipse.ui.systemExternalEditor") : page.openEditor((IEditorInput)new FileEditorInput(fileResource), editorDescriptor.getId());
        }
        catch (PartInitException e) {
            AntUIPlugin.log(MessageFormat.format(AntUIModelMessages.getString("AntUtil.0"), fileResource.getLocation().toOSString()), e);
        }
        if (editorPart instanceof AntEditor) {
            AntEditor editor = (AntEditor)editorPart;
            if (node.getImportNode() != null) {
                AntModel model = editor.getAntModel();
                AntProjectNode project = model.getProjectNode();
                if (project == null) {
                    return;
                }
                int[] info = node.getExternalInfo();
                int offset = AntUtil.getOffset(info[0], info[1], (ITextEditor)editor);
                node = project.getNode(offset);
            }
            editor.setSelection(node, true);
        }
    }

    public static void openInEditor(IWorkbenchPage page, AntElementNode node) {
        IEditorDescriptor editorDesc;
        IFile file = node.getIFile();
        try {
            editorDesc = IDE.getEditorDescriptor((IFile)file);
        }
        catch (PartInitException partInitException) {
            return;
        }
        AntUtil.openInEditor(page, editorDesc, node);
    }

    public static void openBrowser(final String urlString, final Shell shell, final String errorDialogTitle) {
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String platform = SWT.getPlatform();
                boolean succeeded = true;
                if ("motif".equals(platform) || "gtk".equals(platform)) {
                    Program program = Program.findProgram((String)"html");
                    if (program == null) {
                        program = Program.findProgram((String)"htm");
                    }
                    if (program != null) {
                        succeeded = program.execute(urlString.toString());
                    }
                } else {
                    succeeded = Program.launch((String)urlString.toString());
                }
                if (!succeeded) {
                    MessageDialog.openInformation((Shell)shell, (String)errorDialogTitle, (String)AntUIModelMessages.getString("AntUtil.1"));
                }
            }
        });
    }
}

