/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.debug;

import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;

public class AntSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IFile resource;
        String path = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        path = StringVariableManager.getDefault().performStringSubstitution(path);
        WorkspaceSourceContainer sourceContainer = null;
        if (path != null && (resource = AntUtil.getFileForLocation(path, null)) != null) {
            IContainer container = resource.getParent();
            if (container.getType() == 4) {
                sourceContainer = new ProjectSourceContainer((IProject)container, false);
            } else if (container.getType() == 2) {
                sourceContainer = new FolderSourceContainer(container, false);
            }
        }
        if (sourceContainer == null) {
            sourceContainer = new WorkspaceSourceContainer();
        }
        return new ISourceContainer[]{sourceContainer};
    }
}

