/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.debug.model;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.ui.debug.model.DebugModelMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;

public class AntLineBreakpoint
extends LineBreakpoint {
    public AntLineBreakpoint() {
    }

    public AntLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this(resource, lineNumber, new HashMap());
    }

    public AntLineBreakpoint(final IResource resource, final int lineNumber, final Map attributes) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("org.eclipse.ant.ui.antLineBreakpointMarker");
                AntLineBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("lineNumber", new Integer(lineNumber));
                attributes.put("org.eclipse.debug.core.id", "org.eclipse.ant.ui.debug");
                attributes.put("message", MessageFormat.format(DebugModelMessages.getString("AntLineBreakpoint.0"), Integer.toString(lineNumber)));
                AntLineBreakpoint.this.ensureMarker().setAttributes(attributes);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public String getModelIdentifier() {
        return "org.eclipse.ant.ui.debug";
    }

    public boolean isRunToLine() {
        try {
            return this.ensureMarker().getAttribute("org.eclipse.ant.ui.runToLineBreakpoint", false);
        }
        catch (DebugException debugException) {
            return false;
        }
    }
}

