/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.editor.AntAutoEditStrategy;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.editor.AntEditorSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.AntSourceViewerInformationControl;
import org.eclipse.ant.internal.ui.editor.actions.FoldingActionGroup;
import org.eclipse.ant.internal.ui.editor.actions.InformationDispatchAction;
import org.eclipse.ant.internal.ui.editor.actions.OpenDeclarationAction;
import org.eclipse.ant.internal.ui.editor.actions.RunToLineAdapter;
import org.eclipse.ant.internal.ui.editor.actions.ToggleLineBreakpointAction;
import org.eclipse.ant.internal.ui.editor.outline.AntEditorContentOutlinePage;
import org.eclipse.ant.internal.ui.editor.text.AntEditorDocumentProvider;
import org.eclipse.ant.internal.ui.editor.text.AntFoldingStructureProvider;
import org.eclipse.ant.internal.ui.editor.text.IReconcilingParticipant;
import org.eclipse.ant.internal.ui.editor.text.XMLTextHover;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntModelChangeEvent;
import org.eclipse.ant.internal.ui.model.AntModelCore;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.IAntModelListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class AntEditor
extends TextEditor
implements IReconcilingParticipant,
IProjectionListener {
    protected ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AntEditor.this.fSelectionSetFromOutline = false;
            AntEditor.this.doSelectionChanged(event);
            AntEditor.this.fSelectionSetFromOutline = true;
        }
    };
    private IAntModelListener fAntModelListener = new IAntModelListener(){

        public void antModelChanged(AntModelChangeEvent event) {
            AntModel model = AntEditor.this.getAntModel();
            if (event.getModel() == model) {
                if (event.isPreferenceChange()) {
                    AntEditor.this.updateEditorImage(model);
                }
                if (AntEditor.this.fFoldingStructureProvider != null) {
                    AntEditor.this.fFoldingStructureProvider.updateFoldingRegions(model);
                }
            }
        }
    };
    protected AntEditorContentOutlinePage fOutlinePage;
    private TabConverter fTabConverter;
    private boolean fInitialReconcile = true;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    private ProjectionSupport fProjectionSupport;
    private AntFoldingStructureProvider fFoldingStructureProvider;
    private boolean fSelectionSetFromOutline = false;
    private FoldingActionGroup fFoldingGroup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public AntEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AntEditorSourceViewerConfiguration(this));
        this.setDocumentProvider((IDocumentProvider)new AntEditorDocumentProvider());
        AntModelCore.getDefault().addAntModelListener(this.fAntModelListener);
        if (this.isFoldingEnabled()) {
            this.fFoldingStructureProvider = new AntFoldingStructureProvider(this);
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.ant.internal.ui.editor.AntEditorMessages");
        Object action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextOperationAction(bundle, "ContentFormat.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.ant.ui.format");
        this.setAction("ContentFormat", (IAction)action);
        action = new OpenDeclarationAction(this);
        this.setAction("OpenDeclaration", (IAction)action);
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer());
        Object resAction = new TextOperationAction(AntEditorMessages.getResourceBundle(), "ShowTooltip.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(AntEditorMessages.getResourceBundle(), "ShowTooltip.", (TextOperationAction)resAction, this);
        resAction.setActionDefinitionId("org.eclipse.ant.ui.showTooltip");
        this.setAction("ShowTooltip", (IAction)resAction);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(AntUIPlugin.getDefault().getCombinedPreferenceStore());
        this.setCompatibilityMode(false);
        this.setHelpContextId("org.eclipse.ant.ui.ant_editor_context");
        this.setRulerContextMenuId("org.eclipse.ant.internal.ui.editor.AntEditor.RulerContext");
        this.setEditorContextMenuId("org.eclipse.ant.internal.ui.editor.AntEditor");
    }

    public Object getAdapter(Class key) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getOutlinePage();
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
            return adapter;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz3) {
            return new ToggleLineBreakpointAction();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz4) {
            return new RunToLineAdapter();
        }
        return super.getAdapter(key);
    }

    private AntEditorContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new AntEditorContentOutlinePage(AntModelCore.getDefault(), this);
            this.fOutlinePage.addPostSelectionChangedListener(this.fSelectionChangedListener);
            this.setOutlinePageInput(this.getEditorInput());
        }
        return this.fOutlinePage;
    }

    private void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        AntElementNode selectedXmlElement;
        IStructuredSelection selection = (IStructuredSelection)selectionChangedEvent.getSelection();
        if (!this.isActivePart() && AntUIPlugin.getActivePage() != null) {
            AntUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        if ((selectedXmlElement = (AntElementNode)selection.getFirstElement()) != null) {
            this.setSelection(selectedXmlElement, !this.isActivePart());
        }
    }

    private boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    /*
     * Exception decompiling
     */
    public void setSelection(AntElementNode reference, boolean moveCursor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 196->200)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((AntEditorSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property)) {
            Object value = event.getNewValue();
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            if (value instanceof Integer) {
                viewer.getTextWidget().setTabs(((Integer)value).intValue());
            } else if (value instanceof String) {
                viewer.getTextWidget().setTabs(Integer.parseInt((String)value));
            }
            return;
        }
        if ("spaces_for_tabs".equals(property)) {
            if (this.isTabConversionEnabled()) {
                this.startTabConversion();
            } else {
                this.stopTabConversion();
            }
            return;
        }
        AntEditorSourceViewerConfiguration sourceViewerConfiguration = (AntEditorSourceViewerConfiguration)this.getSourceViewerConfiguration();
        if (this.affectsTextPresentation(event)) {
            sourceViewerConfiguration.adaptToPreferenceChange(event);
        }
        sourceViewerConfiguration.changeConfiguration(event);
        super.handlePreferenceStoreChanged(event);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.setOutlinePageInput(input);
        if (this.fFoldingStructureProvider != null) {
            this.fFoldingStructureProvider.setDocument(this.getDocumentProvider().getDocument((Object)input));
        }
    }

    private void setOutlinePageInput(IEditorInput input) {
        IDocumentProvider provider;
        if (this.fOutlinePage != null && (provider = this.getDocumentProvider()) instanceof AntEditorDocumentProvider) {
            AntEditorDocumentProvider documentProvider = (AntEditorDocumentProvider)provider;
            AntModel model = documentProvider.getAntModel(input);
            this.fOutlinePage.setPageInput(model);
        }
    }

    public AntModel getAntModel() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof AntEditorDocumentProvider) {
            AntEditorDocumentProvider documentProvider = (AntEditorDocumentProvider)provider;
            return documentProvider.getAntModel(this.getEditorInput());
        }
        return null;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StatusLineSourceViewer viewer = new StatusLineSourceViewer(parent, ruler, this.getOverviewRuler(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    public void openReferenceElement() {
        ISelection selection = this.getSelectionProvider().getSelection();
        Object target = null;
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            ISourceViewer viewer = this.getSourceViewer();
            int textOffset = textSelection.getOffset();
            IRegion region = XMLTextHover.getRegion((ITextViewer)viewer, textOffset);
            target = this.findTarget(region);
        }
        this.openTarget(target);
    }

    protected void openTarget(Object node) {
        String errorMessage = null;
        if (node instanceof AntElementNode ? (errorMessage = this.openNode((AntElementNode)node)) == null : node instanceof String && (errorMessage = this.openInEditor((String)node, this.getAntModel().getEditedFile())) == null) {
            return;
        }
        if (errorMessage == null || errorMessage.length() == 0) {
            errorMessage = AntEditorMessages.getString("AntEditor.3");
        }
        this.setStatusLineErrorMessage(errorMessage);
        this.getSite().getShell().getDisplay().beep();
    }

    public Object findTarget(IRegion region) {
        ISourceViewer viewer = this.getSourceViewer();
        AntElementNode node = null;
        if (region != null) {
            String path;
            AntModel model;
            IDocument document = viewer.getDocument();
            String text = null;
            try {
                text = document.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException badLocationException) {}
            if (text != null && text.length() > 0 && (node = (model = this.getAntModel()).getReferenceNode(text)) == null && (node = model.getTargetNode(text)) == null && (node = model.getPropertyNode(text)) == null && (path = model.getPath(text, region.getOffset())) != null) {
                return path;
            }
        }
        return node;
    }

    private String openNode(AntElementNode node) {
        String errorMessage = null;
        if (node.isExternal()) {
            String path = node.getFilePath();
            errorMessage = this.openInEditor(path, null);
        } else {
            this.setSelection(node, true);
        }
        return errorMessage;
    }

    private String openInEditor(String path, File buildFile) {
        IFile file;
        File buildFileParent = null;
        if (buildFile != null) {
            buildFileParent = buildFile.getParentFile();
        }
        if ((file = AntUtil.getFileForLocation(path, buildFileParent)) != null && file.exists()) {
            try {
                IWorkbenchPage p = this.getEditorSite().getPage();
                if (p != null) {
                    IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)this.isActivePart());
                }
                return null;
            }
            catch (PartInitException e) {
                return e.getLocalizedMessage();
            }
        }
        return "";
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction action = this.getAction("ContentFormat");
        if (action != null && action.isEnabled()) {
            menu.add(action);
        }
        if ((action = this.getAction("OpenDeclaration")) != null) {
            String openGroup = "group.open";
            menu.appendToGroup("group.undo", (IContributionItem)new Separator(openGroup));
            menu.appendToGroup(openGroup, action);
        }
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.fTabConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            viewer.setTextConverter(this.fTabConverter);
            viewer.updateIndentationPrefixes();
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            viewer.setTextConverter(null);
            viewer.updateIndentationPrefixes();
            this.fTabConverter = null;
        }
    }

    protected int getTabSize() {
        IPreferenceStore preferences = this.getPreferenceStore();
        return preferences.getInt("tabWidth");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.createFoldingSupport(projectionViewer);
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
    }

    private void createFoldingSupport(ProjectionViewer projectionViewer) {
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new AntSourceViewerInformationControl(shell);
            }
        });
        this.fProjectionSupport.install();
        ((ProjectionViewer)this.getViewer()).addProjectionListener((IProjectionListener)this);
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("editor_folding_enabled");
    }

    protected boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("spaces_for_tabs");
    }

    public void dispose() {
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        AntModelCore.getDefault().removeAntModelListener(this.fAntModelListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        AntModel model = this.getAntModel();
        model.updateMarkers();
        this.updateEditorImage(model);
    }

    private void updateEditorImage(AntModel model) {
        Image titleImage = this.getTitleImage();
        if (titleImage == null) {
            return;
        }
        AntProjectNode node = model.getProjectNode();
        if (node != null) {
            this.postImageChange(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateForInitialReconcile() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        ISynchronizable doc = (ISynchronizable)provider.getDocument((Object)this.getEditorInput());
        if (doc == null) {
            return;
        }
        Object object = doc.getLockObject();
        synchronized (object) {
            AntModel model = this.getAntModel();
            if (model == null) {
                return;
            }
            this.fInitialReconcile = false;
            this.updateEditorImage(model);
            model.updateForInitialReconcile();
        }
    }

    private void postImageChange(final AntElementNode node) {
        Shell shell = this.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Image newImage;
                    if (AntEditor.this.getSite().getShell() == null || AntEditor.this.getSite().getShell().isDisposed()) {
                        return;
                    }
                    Image titleImage = AntEditor.this.getTitleImage();
                    if (titleImage != (newImage = node.getImage())) {
                        AntEditor.this.setTitleImage(newImage);
                    }
                }
            });
        }
    }

    public void synchronizeOutlinePage(boolean checkIfOutlinePageActive) {
        if (this.getSelectionProvider() == null) {
            return;
        }
        AntElementNode node = this.getNode();
        this.synchronizeOutlinePage(node, checkIfOutlinePageActive);
    }

    protected void synchronize(boolean checkIfOutlinePageActive) {
        if (this.getSelectionProvider() == null) {
            return;
        }
        AntElementNode node = this.getNode();
        if (AntUIPlugin.getDefault().getPreferenceStore().getBoolean("outline.linkWithEditor")) {
            this.synchronizeOutlinePage(node, checkIfOutlinePageActive);
        }
        this.setSelection(node, false);
    }

    private AntElementNode getNode() {
        AntModel model = this.getAntModel();
        if (model == null) {
            return null;
        }
        AntElementNode node = null;
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int offset = textSelection.getOffset();
            node = model.getNode(offset, false);
        }
        return node;
    }

    protected void synchronizeOutlinePage(AntElementNode node, boolean checkIfOutlinePageActive) {
        if (!(this.fOutlinePage == null || checkIfOutlinePageActive && this.isAntOutlinePageAction())) {
            this.fOutlinePage.removePostSelectionChangedListener(this.fSelectionChangedListener);
            this.fOutlinePage.select(node);
            this.fOutlinePage.addPostSelectionChangedListener(this.fSelectionChangedListener);
        }
    }

    public void reconciled() {
        SourceViewerConfiguration config;
        if (this.fInitialReconcile) {
            this.updateForInitialReconcile();
        }
        if ((config = this.getSourceViewerConfiguration()) == null) {
            return;
        }
        IAutoEditStrategy[] strategies = config.getAutoEditStrategies(this.getViewer(), null);
        int i = 0;
        while (i < strategies.length) {
            IAutoEditStrategy strategy = strategies[i];
            if (strategy instanceof AntAutoEditStrategy) {
                ((AntAutoEditStrategy)strategy).reconciled();
            }
            ++i;
        }
        Shell shell = this.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AntEditor.this.getSite().getShell() == null || AntEditor.this.getSite().getShell().isDisposed()) {
                        return;
                    }
                    AntEditor.this.synchronize(true);
                }
            });
        }
    }

    private boolean isAntOutlinePageAction() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return service.getActivePart();
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePage(true);
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    public void projectionEnabled() {
        this.fFoldingStructureProvider = new AntFoldingStructureProvider(this);
        this.fFoldingStructureProvider.setDocument(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
        this.fFoldingStructureProvider.updateFoldingRegions(this.getAntModel());
    }

    public void projectionDisabled() {
        this.fFoldingStructureProvider = null;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ant.ui.AntEditorScope"});
    }

    protected IPreferenceStore getEditorPreferenceStore() {
        return this.getPreferenceStore();
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AntModel model = AntEditor.this.getAntModel();
            if (model == null) {
                return;
            }
            ISelection selection = event.getSelection();
            AntElementNode node = null;
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                node = model.getNode(offset, false);
            }
            if (AntUIPlugin.getDefault().getPreferenceStore().getBoolean("outline.linkWithEditor")) {
                AntEditor.this.synchronizeOutlinePage(node, true);
            }
            AntEditor.this.setSelection(node, false);
        }
    }

    static class TabConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    class StatusLineSourceViewer
    extends ProjectionViewer {
        private boolean fIgnoreTextConverters = false;

        public StatusLineSourceViewer(Composite composite, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, int styles) {
            super(composite, verticalRuler, overviewRuler, AntEditor.this.isOverviewRulerVisible(), styles);
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null || !this.redraws()) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    AntEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    break;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                }
            }
            super.doOperation(operation);
        }

        public void setTextConverter(TabConverter tabConverter) {
            AntEditor.this.fTabConverter = tabConverter;
        }

        public void updateIndentationPrefixes() {
            SourceViewerConfiguration configuration = AntEditor.this.getSourceViewerConfiguration();
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && AntEditor.this.fTabConverter != null) {
                AntEditor.this.fTabConverter.customizeDocumentCommand(this.getDocument(), command);
            }
            this.fIgnoreTextConverters = false;
        }
    }
}

