/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.actions.FoldingActionGroup;
import org.eclipse.ant.internal.ui.editor.actions.OpenDeclarationAction;
import org.eclipse.ant.internal.ui.editor.actions.OpenExternalDocAction;
import org.eclipse.ant.internal.ui.editor.actions.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class AntEditorActionContributor
extends TextEditorActionContributor {
    protected RetargetTextEditorAction fContentAssistProposal;
    protected RetargetTextEditorAction fContentFormat;
    private OpenDeclarationAction fOpenDeclarationAction;
    private TogglePresentationAction fTogglePresentation;
    private OpenExternalDocAction fOpenExternalDocAction;

    public AntEditorActionContributor() {
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.ant.internal.ui.editor.AntEditorMessages");
        this.fContentAssistProposal = new RetargetTextEditorAction(bundle, "ContentAssistProposal.");
        this.fContentFormat = new RetargetTextEditorAction(bundle, "ContentFormat.");
        this.fTogglePresentation = new TogglePresentationAction();
    }

    protected void initializeActions(AntEditor editor) {
        this.fOpenDeclarationAction = new OpenDeclarationAction(editor);
        this.fOpenExternalDocAction = new OpenExternalDocAction(editor);
    }

    private void doSetActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        ITextEditor editor = null;
        if (part instanceof ITextEditor) {
            editor = (ITextEditor)part;
        }
        this.fContentAssistProposal.setAction(this.getAction(editor, "ContentAssistProposal"));
        this.fContentFormat.setAction(this.getAction(editor, "ContentFormat"));
        if (editor instanceof AntEditor) {
            FoldingActionGroup foldingActions;
            AntEditor antEditor = (AntEditor)part;
            if (this.fOpenDeclarationAction == null) {
                this.initializeActions(antEditor);
                this.contributeToMenu(this.getActionBars().getMenuManager());
            }
            if ((foldingActions = antEditor.getFoldingActionGroup()) != null) {
                foldingActions.updateActionBars();
            }
            if (this.fOpenDeclarationAction != null) {
                this.fOpenDeclarationAction.setEditor(antEditor);
            }
            if (this.fOpenExternalDocAction != null) {
                this.fOpenExternalDocAction.setActiveEditor(null, (IEditorPart)antEditor);
            }
        }
        if (this.fTogglePresentation != null) {
            this.fTogglePresentation.setEditor(editor);
        }
    }

    public void contributeToMenu(IMenuManager menu) {
        if (this.fOpenDeclarationAction == null) {
            return;
        }
        super.contributeToMenu(menu);
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("open.ext", (IAction)this.fOpenDeclarationAction);
            navigateMenu.appendToGroup("open.ext", (IAction)this.fOpenExternalDocAction);
            navigateMenu.setVisible(true);
        }
    }

    public void init(IActionBars bars) {
        super.init(bars);
        IMenuManager menuManager = bars.getMenuManager();
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator());
            editMenu.add((IAction)this.fContentAssistProposal);
            editMenu.add((IAction)this.fContentFormat);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        this.doSetActiveEditor(part);
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
    }
}

