/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.debug.model.AntDebugElement;
import org.eclipse.ant.internal.ui.debug.model.AntLineBreakpoint;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        IEditorPart editorPart = (IEditorPart)part;
        IEditorInput input = editorPart.getEditorInput();
        String errorMessage = null;
        if (input == null) {
            errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.0");
        } else {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)input);
            if (document == null) {
                errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.1");
            } else {
                IFile file;
                ITextSelection textSelection = (ITextSelection)selection;
                int lineNumber = textSelection.getStartLine() + 1;
                AntLineBreakpoint breakpoint = null;
                Map attributes = this.getRunToLineAttributes();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((file = (IFile)input.getAdapter((Class)clazz)) == null) {
                    errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.2");
                } else {
                    breakpoint = new AntLineBreakpoint((IResource)file, lineNumber, attributes);
                    breakpoint.setPersisted(false);
                    errorMessage = AntEditorActionMessages.getString("RunToLineAdapter.3");
                    if (target instanceof IAdaptable) {
                        IDebugTarget debugTarget;
                        IAdaptable iAdaptable = (IAdaptable)target;
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((debugTarget = (IDebugTarget)iAdaptable.getAdapter((Class)clazz2)) != null) {
                            this.prepareSkipBreakpoints((IBreakpoint)breakpoint);
                            debugTarget.getDebugTarget().breakpointAdded((IBreakpoint)breakpoint);
                            target.resume();
                            return;
                        }
                    }
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, AntUIPlugin.getUniqueIdentifier(), 120, errorMessage, null));
    }

    private Map getRunToLineAttributes() {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        attributes.put("transient", Boolean.TRUE);
        attributes.put("org.eclipse.ant.ui.runToLineBreakpoint", Boolean.TRUE);
        return attributes;
    }

    protected void prepareSkipBreakpoints(final IBreakpoint breakpoint) {
        final DebugPlugin plugin = DebugPlugin.getDefault();
        final IBreakpointManager manager = plugin.getBreakpointManager();
        if (!manager.isEnabled() || !DebugUITools.getPreferenceStore().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE)) {
            return;
        }
        manager.setEnabled(false);
        final IDebugEventSetListener debugEventListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    Object source = event.getSource();
                    if (source instanceof IThread && event.getKind() == 2 && event.getDetail() == 16) {
                        IBreakpoint[] breakpoints = ((IThread)source).getBreakpoints();
                        int j = 0;
                        while (j < breakpoints.length) {
                            if (breakpoints[j] == breakpoint) {
                                manager.setEnabled(true);
                            }
                            ++j;
                        }
                    } else if (source instanceof IDebugTarget && event.getKind() == 8) {
                        manager.setEnabled(true);
                    }
                    ++i;
                }
            }
        };
        plugin.addDebugEventListener(debugEventListener);
        manager.addBreakpointManagerListener(new IBreakpointManagerListener(){

            public void breakpointManagerEnablementChanged(boolean enabled) {
                plugin.removeDebugEventListener(debugEventListener);
            }
        });
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        return target instanceof AntDebugElement;
    }
}

