/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class AntFoldingStructureProvider {
    private AntEditor fEditor;
    private IDocument fDocument;
    private Map fPositionToElement = new HashMap();
    static /* synthetic */ Class class$0;

    public AntFoldingStructureProvider(AntEditor editor) {
        this.fEditor = editor;
    }

    private void updateFoldingRegions(ProjectionAnnotationModel model, Set currentRegions) {
        Annotation[] deletions = this.computeDifferences(model, currentRegions);
        HashMap additionsMap = new HashMap();
        Iterator iter = currentRegions.iterator();
        while (iter.hasNext()) {
            Object position = iter.next();
            AntElementNode node = (AntElementNode)this.fPositionToElement.get(position);
            additionsMap.put(new ProjectionAnnotation(node.collapseProjection()), position);
        }
        if (deletions.length != 0 || additionsMap.size() != 0) {
            model.modifyAnnotations(deletions, additionsMap, new Annotation[0]);
        }
    }

    private Annotation[] computeDifferences(ProjectionAnnotationModel model, Set additions) {
        ArrayList deletions = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = model.getPosition((Annotation)annotation);
            if (additions.contains(position)) {
                additions.remove(position);
                continue;
            }
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    public void updateFoldingRegions(AntModel antModel) {
        this.fPositionToElement = new HashMap();
        try {
            ProjectionAnnotationModel model;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((model = (ProjectionAnnotationModel)this.fEditor.getAdapter(clazz)) == null) {
                return;
            }
            HashSet currentRegions = new HashSet();
            AntProjectNode node = antModel.getProjectNode();
            if (node == null || node.getOffset() == -1 || node.getLength() == -1) {
                return;
            }
            ArrayList<AntProjectNode> root = new ArrayList<AntProjectNode>(2);
            root.add(node);
            List nodes = antModel.getNonStructuralNodes();
            root.addAll(nodes);
            this.addFoldingRegions(currentRegions, root);
            this.updateFoldingRegions(model, currentRegions);
        }
        catch (BadLocationException be) {
            AntUIPlugin.log(be);
        }
    }

    private void addFoldingRegions(Set regions, List children) throws BadLocationException {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            int endLine;
            AntElementNode element = (AntElementNode)iter.next();
            if (element.getImportNode() != null || element.isExternal()) continue;
            int startLine = this.fDocument.getLineOfOffset(element.getOffset());
            if (startLine < (endLine = this.fDocument.getLineOfOffset(element.getOffset() + element.getLength()))) {
                int start = this.fDocument.getLineOffset(startLine);
                int end = this.fDocument.getLineOffset(endLine) + this.fDocument.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, element);
            }
            if ((children = element.getChildNodes()) == null) continue;
            this.addFoldingRegions(regions, children);
        }
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }
}

