/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.Target;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntTargetNode
extends AntElementNode {
    private Target fTarget = null;
    private String fLabel = null;

    public AntTargetNode(Target target) {
        super("target");
        this.fTarget = target;
    }

    public String getLabel() {
        if (this.fLabel == null) {
            StringBuffer displayName = new StringBuffer(this.getTargetName());
            if (this.isDefaultTarget()) {
                displayName.append(AntModelMessages.getString("AntTargetNode.2"));
            }
            if (this.isExternal()) {
                this.appendEntityName(displayName);
            }
            this.fLabel = displayName.toString();
        }
        return this.fLabel;
    }

    public Target getTarget() {
        return this.fTarget;
    }

    public boolean isDefaultTarget() {
        String targetName = this.fTarget.getName();
        if (targetName == null) {
            return false;
        }
        return targetName.equals(this.fTarget.getProject().getDefaultTarget());
    }

    public boolean isInternal() {
        Target target = this.getTarget();
        return target.getDescription() == null && !this.isDefaultTarget();
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        ImageDescriptor base = null;
        base = this.isDefaultTarget() ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antDefaultTarget") : (this.getTarget().getDescription() == null ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antPrivateTarget") : AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antTarget"));
        return base;
    }

    public void setTarget(Target target) {
        this.fTarget = target;
    }

    public void reset() {
        super.reset();
        Hashtable currentTargets = this.fTarget.getProject().getTargets();
        if (currentTargets.get(this.fTarget.getName()) != null) {
            currentTargets.remove(this.fTarget.getName());
        }
    }

    public String checkDependencies() {
        Enumeration dependencies = this.fTarget.getDependencies();
        while (dependencies.hasMoreElements()) {
            String dependency = (String)dependencies.nextElement();
            if (this.fTarget.getProject().getTargets().get(dependency) != null) continue;
            return dependency;
        }
        return null;
    }

    public boolean collapseProjection() {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("editor_folding_targets");
    }

    public String getTargetName() {
        String targetName = this.fTarget.getName();
        if (targetName == null) {
            targetName = "target";
            this.setProblemSeverity(1);
        }
        return targetName;
    }
}

