/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;

public class DetachedWindow
extends Window {
    private PartStack folder;
    private WorkbenchPage page;
    private String title;
    private Rectangle bounds;

    public DetachedWindow(WorkbenchPage workbenchPage) {
        super(workbenchPage.getWorkbenchWindow().getShell());
        this.setShellStyle(0x10 | Window.getDefaultOrientation());
        this.page = workbenchPage;
        this.folder = new ViewStack(this.page, false, 2);
    }

    public void add(ViewPane part) {
        Shell shell = this.getShell();
        if (shell != null) {
            part.reparent((Composite)shell);
        }
        this.folder.add(part);
    }

    public boolean belongsToWorkbenchPage(IWorkbenchPage workbenchPage) {
        return this.page == workbenchPage;
    }

    public boolean close() {
        Shell s = this.getShell();
        if (s != null) {
            this.title = s.getText();
            this.bounds = s.getBounds();
        }
        if (this.folder != null) {
            this.folder.dispose();
        }
        IWorkbenchContextSupport contextSupport = this.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getContextSupport();
        contextSupport.unregisterShell(s);
        return super.close();
    }

    private void collectViewPanes(List result, LayoutPart[] parts) {
        int i = 0;
        int length = parts.length;
        while (i < length) {
            LayoutPart part = parts[i];
            if (part instanceof ViewPane) {
                result.add(part);
            }
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        if (this.title != null) {
            shell.setText(this.title);
        }
        shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Shell shell = (Shell)event.widget;
                DetachedWindow.this.folder.setBounds(shell.getClientArea());
            }
        });
        IWorkbenchContextSupport contextSupport = this.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getContextSupport();
        contextSupport.registerShell(shell, 2);
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.detached_window_context");
    }

    protected Control createContents(Composite parent) {
        this.folder.createControl(parent);
        Vector detachedChildren = new Vector();
        this.collectViewPanes(detachedChildren, this.getChildren());
        Enumeration itr = detachedChildren.elements();
        while (itr.hasMoreElements()) {
            LayoutPart part = (LayoutPart)itr.nextElement();
            part.reparent(parent);
        }
        return this.folder.getControl();
    }

    public LayoutPart[] getChildren() {
        return this.folder.getChildren();
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    protected void handleShellCloseEvent() {
        ArrayList views = new ArrayList();
        this.collectViewPanes(views, this.getChildren());
        Iterator itr = views.iterator();
        while (itr.hasNext()) {
            ViewPane child = (ViewPane)itr.next();
            this.page.hideView(child.getViewReference());
        }
        this.close();
    }

    protected void initializeBounds() {
        if (this.bounds != null) {
            this.getShell().setBounds(this.bounds);
        } else {
            super.initializeBounds();
        }
    }

    public void restoreState(IMemento memento) {
        IMemento childMem;
        this.title = memento.getString("title");
        Integer bigInt = memento.getInteger("x");
        int x = bigInt;
        bigInt = memento.getInteger("y");
        int y = bigInt;
        bigInt = memento.getInteger("width");
        int width = bigInt;
        bigInt = memento.getInteger("height");
        int height = bigInt;
        bigInt = memento.getInteger("float");
        this.bounds = new Rectangle(x, y, width, height);
        if (this.getShell() != null) {
            this.getShell().setText(this.title);
            this.getShell().setBounds(this.bounds);
        }
        if ((childMem = memento.getChild("folder")) != null) {
            this.folder.restoreState(childMem);
        }
    }

    public void saveState(IMemento memento) {
        if (this.getShell() != null) {
            this.title = this.getShell().getText();
            this.bounds = this.getShell().getBounds();
        }
        memento.putString("title", this.title);
        memento.putInteger("x", this.bounds.x);
        memento.putInteger("y", this.bounds.y);
        memento.putInteger("width", this.bounds.width);
        memento.putInteger("height", this.bounds.height);
        IMemento childMem = memento.createChild("folder");
        this.folder.saveState(childMem);
    }

    public Control getControl() {
        return this.folder.getControl();
    }

    private static boolean intersectsAnyMonitor(Display display, Rectangle someRectangle) {
        Monitor[] monitors = display.getMonitors();
        int idx = 0;
        while (idx < monitors.length) {
            Monitor mon = monitors[idx];
            if (mon.getClientArea().intersects(someRectangle)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        Rectangle bounds = this.getShell().getBounds();
        int ret = super.open();
        if (!bounds.equals((Object)this.getShell().getBounds())) {
            this.getShell().setBounds(bounds);
        }
        return ret;
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        if (DetachedWindow.intersectsAnyMonitor(this.getShell().getDisplay(), preferredSize)) {
            return preferredSize;
        }
        return super.getConstrainedShellBounds(preferredSize);
    }
}

