/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.presentations.IPresentablePart;

public abstract class PartPane
extends LayoutPart
implements Listener {
    protected PresentablePart presentableAdapter = new PresentablePart(this);
    public static final String PROP_ZOOMED = "zoomed";
    private boolean isZoomed = false;
    private MenuManager paneMenuManager;
    protected IWorkbenchPartReference partReference;
    protected WorkbenchPage page;
    protected Composite control;
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            LayoutPart parent;
            Control parentControl;
            ILayoutContainer container;
            if ((e.detail == 512 || e.detail == 256) && (container = PartPane.this.getContainer()) != null && container instanceof LayoutPart && (parentControl = (parent = (LayoutPart)((Object)container)).getControl()) != null && !parentControl.isDisposed()) {
                parentControl.traverse(e.detail);
                e.doit = false;
            }
        }
    };

    public PartPane(IWorkbenchPartReference partReference, WorkbenchPage workbenchPage) {
        super(partReference.getId());
        this.partReference = partReference;
        this.page = workbenchPage;
        ((WorkbenchPartReference)partReference).setPane(this);
    }

    protected void doCreateChildControl() {
        final IWorkbenchPart[] part = new IWorkbenchPart[]{this.partReference.getPart(false)};
        if (part[0] == null) {
            return;
        }
        Assert.isNotNull((Object)this.control);
        int style = 0;
        if (part[0] instanceof WorkbenchPart) {
            style = ((WorkbenchPart)part[0]).getOrientation();
        }
        final Composite content = new Composite(this.control, style);
        content.setLayout((Layout)new FillLayout());
        String error = WorkbenchMessages.format("PartPane.unableToCreate", new Object[]{this.partReference.getTitle()});
        Platform.run((ISafeRunnable)new SafeRunnable(error){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    UIStats.start(1, PartPane.this.id);
                    part[0].createPartControl(content);
                    Rectangle oldBounds = PartPane.this.control.getBounds();
                    ((WorkbenchPartReference)PartPane.this.getPartReference()).refreshFromPart();
                    if (oldBounds.equals((Object)PartPane.this.control.getBounds())) {
                        PartPane.this.control.layout(true);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    UIStats.end(1, PartPane.this.id);
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                UIStats.end(1, PartPane.this.id);
            }

            public void handleException(Throwable e) {
                Workbench wb = (Workbench)PlatformUI.getWorkbench();
                if (!wb.isStarting()) {
                    super.handleException(e);
                }
                Control[] children = content.getChildren();
                int i = 0;
                while (i < children.length) {
                    children[i].dispose();
                    ++i;
                }
                IWorkbenchPart newPart = PartPane.this.createErrorPart(part[0]);
                part[0].getSite().setSelectionProvider(null);
                newPart.createPartControl(content);
                ((WorkbenchPartReference)PartPane.this.partReference).setPart(newPart);
                part[0] = newPart;
            }
        });
        this.page.addPart(this.partReference);
        this.page.firePartOpened(part[0]);
    }

    public void addSizeMenuItem(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 64, index);
        item.setText(WorkbenchMessages.getString("PartPane.size"));
        Menu sizeMenu = new Menu(menu);
        item.setMenu(sizeMenu);
        this.addSizeItems(sizeMenu);
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null) {
            return;
        }
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.control.setVisible(false);
        this.createTitleBar();
        this.createChildControl();
        this.control.addListener(26, (Listener)this);
        this.control.addTraverseListener(this.traverseListener);
    }

    protected abstract IWorkbenchPart createErrorPart(IWorkbenchPart var1);

    protected abstract void createTitleBar();

    public void dispose() {
        super.dispose();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(26, (Listener)this);
            this.control.removeTraverseListener(this.traverseListener);
            this.control.dispose();
            this.control = null;
        }
        if (this.paneMenuManager != null) {
            this.paneMenuManager.dispose();
            this.paneMenuManager = null;
        }
    }

    public abstract void doHide();

    protected void doZoom() {
        if (this.getWindow() instanceof IWorkbenchWindow) {
            this.page.toggleZoom(this.partReference);
        }
    }

    public Rectangle getBounds() {
        return this.getControl().getBounds();
    }

    public Control getControl() {
        return this.control;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    public void handleEvent(Event event) {
        if (event.type == 26) {
            this.requestActivation();
        }
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public void moveAbove(Control refControl) {
        if (this.getControl() != null) {
            this.getControl().moveAbove(refControl);
        }
    }

    protected void requestActivation() {
        this.page.requestActivation(this.partReference.getPart(true));
    }

    public void setContainer(ILayoutContainer container) {
        super.setContainer(container);
    }

    public void setVisible(boolean makeVisible) {
        if (makeVisible) {
            this.partReference.getPart(true);
            this.createChildControl();
        }
        super.setVisible(makeVisible);
    }

    protected final void createChildControl() {
        if (this.partReference.getPart(false) == null) {
            return;
        }
        Assert.isNotNull((Object)this.control);
        if (this.control.getChildren().length != 0) {
            return;
        }
        this.doCreateChildControl();
    }

    public void setFocus() {
        this.requestActivation();
        IWorkbenchPart part = this.partReference.getPart(true);
        if (part != null) {
            part.setFocus();
        }
    }

    public void setWorkbenchPage(WorkbenchPage workbenchPage) {
        this.page = workbenchPage;
    }

    public void setZoomed(boolean isZoomed) {
        if (this.isZoomed == isZoomed) {
            return;
        }
        super.setZoomed(isZoomed);
        this.isZoomed = isZoomed;
        Object[] listeners = this.getPropertyListeners().getListeners();
        if (listeners.length > 0) {
            Boolean oldValue = isZoomed ? Boolean.FALSE : Boolean.TRUE;
            Boolean zoomed = isZoomed ? Boolean.TRUE : Boolean.FALSE;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROP_ZOOMED, (Object)oldValue, (Object)zoomed);
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }
    }

    abstract void shellActivated();

    abstract void shellDeactivated();

    public abstract void showFocus(boolean var1);

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        return this;
    }

    public PartStack getStack() {
        ILayoutContainer container = this.getContainer();
        if (container instanceof PartStack) {
            return (PartStack)container;
        }
        return null;
    }

    public void showPaneMenu() {
        PartStack folder = this.getStack();
        if (folder != null) {
            folder.showSystemMenu();
        }
    }

    public void showViewMenu() {
        PartStack folder = this.getStack();
        if (folder != null) {
            folder.showPaneMenu();
        }
    }

    protected Sashes findSashes() {
        Sashes result = new Sashes();
        ILayoutContainer container = this.getContainer();
        if (container == null) {
            return result;
        }
        container.findSashes(this, result);
        return result;
    }

    protected void moveSash(Sash sash) {
        PartPane.moveSash(sash, this);
    }

    public static void moveSash(final Sash sash, final LayoutPart toGetFocusWhenDone) {
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.character == '\u001b' || e.character == '\r') && toGetFocusWhenDone != null) {
                    toGetFocusWhenDone.setFocus();
                }
            }
        };
        sash.addFocusListener((FocusListener)new FocusAdapter((KeyListener)listener){
            private final /* synthetic */ KeyListener val$listener;
            {
                this.val$listener = keyListener;
            }

            public void focusGained(FocusEvent e) {
                sash.setBackground(sash.getDisplay().getSystemColor(26));
                sash.addKeyListener(this.val$listener);
            }

            public void focusLost(FocusEvent e) {
                sash.setBackground(null);
                sash.removeKeyListener(this.val$listener);
            }
        });
        sash.setFocus();
    }

    protected void addSizeItem(Menu sizeMenu, String labelMessage, final Sash sash) {
        MenuItem item = new MenuItem(sizeMenu, 0);
        item.setText(labelMessage);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartPane.this.moveSash(sash);
            }
        });
        item.setEnabled(!this.isZoomed() && sash != null);
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    protected void addSizeItems(Menu sizeMenu) {
        Sashes sashes = this.findSashes();
        this.addSizeItem(sizeMenu, WorkbenchMessages.getString("PartPane.sizeLeft"), sashes.left);
        this.addSizeItem(sizeMenu, WorkbenchMessages.getString("PartPane.sizeRight"), sashes.right);
        this.addSizeItem(sizeMenu, WorkbenchMessages.getString("PartPane.sizeTop"), sashes.top);
        this.addSizeItem(sizeMenu, WorkbenchMessages.getString("PartPane.sizeBottom"), sashes.bottom);
    }

    protected void doDock() {
    }

    public void setBusy(boolean isBusy) {
    }

    public void showHighlight() {
    }

    public void reparent(Composite newParent) {
        super.reparent(newParent);
    }

    public abstract Control getToolBar();

    public boolean hasViewMenu() {
        return false;
    }

    public void showViewMenu(Point location) {
    }

    public boolean isBusy() {
        return false;
    }

    public IPresentablePart getPresentablePart() {
        return this.presentableAdapter;
    }

    public abstract boolean isCloseable();

    public static class Sashes {
        public Sash left;
        public Sash right;
        public Sash top;
        public Sash bottom;
    }
}

