/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.PluginAction;

public class PluginActionContributionItem
extends ActionContributionItem
implements IIdentifierListener,
IActivityManagerListener {
    private IIdentifier identifier = null;

    public PluginActionContributionItem(PluginAction action) {
        super((IAction)action);
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener(this);
        if (WorkbenchActivityHelper.isFiltering()) {
            this.createIdentifier();
        }
    }

    private void createIdentifier() {
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IPluginContribution contribution = (IPluginContribution)this.getAction();
        this.identifier = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(contribution));
        this.identifier.addIdentifierListener(this);
    }

    private void disposeIdentifier() {
        if (this.identifier != null) {
            this.identifier.removeIdentifierListener(this);
            this.identifier = null;
        }
    }

    public void dispose() {
        PluginAction pluginAction = (PluginAction)this.getAction();
        if (pluginAction != null) {
            pluginAction.disposeDelegate();
        }
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener(this);
        this.disposeIdentifier();
    }

    public boolean isVisible() {
        if (this.identifier != null && !this.identifier.isEnabled()) {
            return false;
        }
        return super.isVisible();
    }

    public void identifierChanged(IdentifierEvent identifierEvent) {
        this.getParent().markDirty();
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (WorkbenchActivityHelper.isFiltering() && this.identifier == null) {
            this.createIdentifier();
            this.getParent().markDirty();
        } else if (!WorkbenchActivityHelper.isFiltering() && this.identifier != null) {
            this.disposeIdentifier();
            this.getParent().markDirty();
        }
    }

    public ISelection getSelection() {
        return ((PluginAction)this.getAction()).getSelection();
    }
}

