/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.IWindowTrim;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.CompatibilityDragTarget;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.layout.TrimLayout;

class TrimDropTarget
implements IDragOverListener {
    private ActualTrimDropTarget dropTarget;
    private TrimLayout layout;
    private Composite windowComposite;
    private WorkbenchWindow window;
    private static final float edgeDockRatio = 0.2f;

    public TrimDropTarget(Composite someComposite, WorkbenchWindow theWindow) {
        this.layout = (TrimLayout)someComposite.getLayout();
        this.windowComposite = someComposite;
        this.window = theWindow;
    }

    public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
        Control targetTrim;
        IWindowTrim draggedTrim;
        Control trimControl;
        if (draggedObject instanceof IWindowTrim && (trimControl = (draggedTrim = (IWindowTrim)draggedObject).getControl()).getParent() == this.windowComposite && (targetTrim = this.getTrimControl(currentControl)) != null) {
            int side = this.layout.getTrimLocation(targetTrim);
            if (side == -1 && targetTrim == this.layout.getCenterControl()) {
                side = CompatibilityDragTarget.getRelativePosition(targetTrim, position);
                if (side == 0x1000000) {
                    side = -1;
                }
                targetTrim = null;
            }
            if (side != -1 && targetTrim != trimControl && (targetTrim != null || side != this.layout.getTrimLocation(trimControl)) && (side & draggedTrim.getValidSides()) != 0) {
                int dropSide = side;
                return this.createDropResult(dragRectangle, draggedTrim, dropSide);
            }
        }
        return null;
    }

    private IDropTarget createDropResult(Rectangle dragRectangle, IWindowTrim draggedTrim, int dropSide) {
        if (this.dropTarget == null) {
            this.dropTarget = new ActualTrimDropTarget(dragRectangle, draggedTrim, dropSide);
        } else {
            this.dropTarget.setTarget(dragRectangle, draggedTrim, dropSide);
        }
        return this.dropTarget;
    }

    private Control getTrimControl(Control searchSource) {
        if (searchSource == null) {
            return null;
        }
        if (searchSource.getParent() == this.windowComposite) {
            return searchSource;
        }
        return this.getTrimControl((Control)searchSource.getParent());
    }

    private final class ActualTrimDropTarget
    extends AbstractDropTarget {
        private Rectangle dragRectangle;
        private IWindowTrim draggedTrim;
        private int dropSide;

        ActualTrimDropTarget(Rectangle dragRectangle, IWindowTrim draggedTrim, int dropSide) {
            this.dragRectangle = dragRectangle;
            this.draggedTrim = draggedTrim;
            this.dropSide = dropSide;
        }

        private void setTarget(Rectangle dragRectangle, IWindowTrim draggedTrim, int dropSide) {
            this.dragRectangle = dragRectangle;
            this.draggedTrim = draggedTrim;
            this.dropSide = dropSide;
        }

        public void drop() {
            this.draggedTrim.dock(this.dropSide);
        }

        public Cursor getCursor() {
            return DragCursors.getCursor(DragCursors.positionToDragCursor(this.dropSide));
        }

        public Rectangle getSnapRectangle() {
            int smaller = Math.min(this.dragRectangle.width, this.dragRectangle.height);
            return Geometry.toDisplay((Control)TrimDropTarget.this.windowComposite, (Rectangle)Geometry.getExtrudedEdge((Rectangle)TrimDropTarget.this.windowComposite.getClientArea(), (int)smaller, (int)this.dropSide));
        }
    }
}

