/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.commands.CommandManagerFactory;
import org.eclipse.ui.internal.commands.IMutableCommandManager;
import org.eclipse.ui.internal.commands.MutableCommandManager;
import org.eclipse.ui.internal.commands.ws.HandlerProxy;
import org.eclipse.ui.internal.contexts.ws.WorkbenchContextSupport;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeyFormatterFactory;
import org.eclipse.ui.keys.SWTKeySupport;

public class WorkbenchCommandSupport
implements IWorkbenchCommandSupport {
    private static final boolean DEBUG = Policy.DEBUG_HANDLERS;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_VERBOSE_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private static final int MATCH_ANY = 0;
    private static final int MATCH_PARTIAL = 1;
    private static final int MATCH_EXACT = 2;
    private Listener activationListener = new Listener(){

        public void handleEvent(Event event) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false, event.display.getActiveShell());
        }
    };
    private String activePartId;
    private Shell activeShell;
    private IWorkbenchSite activeWorkbenchSite;
    private IWorkbenchWindow activeWorkbenchWindow;
    private final Map handlerSubmissionsByCommandId = new HashMap();
    private final IMutableCommandManager mutableCommandManager;
    private final IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage workbenchPage) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void pageClosed(IWorkbenchPage workbenchPage) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void pageOpened(IWorkbenchPage workbenchPage) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }
    };
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partBroughtToTop(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partClosed(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partDeactivated(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void partOpened(IWorkbenchPart workbenchPart) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }
    };
    private final IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }

        public void perspectiveChanged(IWorkbenchPage workbenchPage, IPerspectiveDescriptor perspectiveDescriptor, String changeId) {
            WorkbenchCommandSupport.this.processHandlerSubmissions(false);
        }
    };
    private boolean processing = true;
    private final Workbench workbench;

    static {
        MutableCommandManager.DEBUG_HANDLERS = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
        MutableCommandManager.DEBUG_HANDLERS_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
        MutableCommandManager.DEBUG_COMMAND_EXECUTION = Policy.DEBUG_KEY_BINDINGS_VERBOSE;
    }

    private static final int compareWindows(Shell shellToMatch, Shell activeShell) {
        if (shellToMatch == null) {
            return 0;
        }
        if (shellToMatch == activeShell) {
            return 2;
        }
        return 1;
    }

    public WorkbenchCommandSupport(Workbench workbenchToSupport) {
        this.workbench = workbenchToSupport;
        this.mutableCommandManager = CommandManagerFactory.getMutableCommandManager();
        KeyFormatterFactory.setDefault(SWTKeySupport.getKeyFormatterForPlatform());
        workbenchToSupport.getDisplay().addFilter(26, this.activationListener);
        ArrayList<HandlerSubmission> submissions = new ArrayList<HandlerSubmission>();
        MutableCommandManager commandManager = (MutableCommandManager)this.mutableCommandManager;
        Set handlers = commandManager.getDefinedHandlers();
        Iterator handlerItr = handlers.iterator();
        while (handlerItr.hasNext()) {
            HandlerProxy proxy = (HandlerProxy)handlerItr.next();
            String commandId = proxy.getCommandId();
            HandlerSubmission submission = new HandlerSubmission(null, null, null, commandId, proxy, Priority.LOW);
            submissions.add(submission);
        }
        if (!submissions.isEmpty()) {
            this.addHandlerSubmissions(submissions);
        }
    }

    public void addHandlerSubmission(HandlerSubmission handlerSubmission) {
        this.addHandlerSubmissionReal(handlerSubmission);
        this.processHandlerSubmissions(true);
    }

    private final void addHandlerSubmissionReal(HandlerSubmission handlerSubmission) {
        String commandId = handlerSubmission.getCommandId();
        ArrayList<HandlerSubmission> handlerSubmissions2 = (ArrayList<HandlerSubmission>)this.handlerSubmissionsByCommandId.get(commandId);
        if (handlerSubmissions2 == null) {
            handlerSubmissions2 = new ArrayList<HandlerSubmission>();
            this.handlerSubmissionsByCommandId.put(commandId, handlerSubmissions2);
        }
        handlerSubmissions2.add(handlerSubmission);
    }

    public void addHandlerSubmissions(Collection handlerSubmissions) {
        Iterator submissionItr = handlerSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.addHandlerSubmissionReal((HandlerSubmission)submissionItr.next());
        }
        this.processHandlerSubmissions(true);
    }

    public ICommandManager getCommandManager() {
        return this.mutableCommandManager;
    }

    private void processHandlerSubmissions(boolean force) {
        this.processHandlerSubmissions(force, this.workbench.getDisplay().getActiveShell());
    }

    public void processHandlerSubmissions(boolean force, Shell newActiveShell) {
        if (!this.processing) {
            return;
        }
        IWorkbenchPartSite newActiveWorkbenchSite = null;
        String newActivePartId = null;
        IWorkbenchWindow newWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        boolean update = false;
        if (this.activeShell != newActiveShell) {
            this.activeShell = newActiveShell;
            update = true;
        }
        if (this.activeWorkbenchWindow != newWorkbenchWindow) {
            if (this.activeWorkbenchWindow != null) {
                this.activeWorkbenchWindow.removePageListener(this.pageListener);
                this.activeWorkbenchWindow.removePerspectiveListener(this.perspectiveListener);
                this.activeWorkbenchWindow.getPartService().removePartListener(this.partListener);
            }
            if (newWorkbenchWindow != null) {
                newWorkbenchWindow.addPageListener(this.pageListener);
                newWorkbenchWindow.addPerspectiveListener(this.perspectiveListener);
                newWorkbenchWindow.getPartService().addPartListener(this.partListener);
            }
            this.activeWorkbenchWindow = newWorkbenchWindow;
            update = true;
        }
        if (newWorkbenchWindow != null) {
            IWorkbenchPage activeWorkbenchPage = newWorkbenchWindow.getActivePage();
            if (activeWorkbenchPage != null) {
                IWorkbenchPart activeWorkbenchPart = activeWorkbenchPage.getActivePart();
                if (activeWorkbenchPart != null) {
                    newActiveWorkbenchSite = activeWorkbenchPart.getSite();
                    newActivePartId = newActiveWorkbenchSite.getId();
                    if (this.activeWorkbenchSite != newActiveWorkbenchSite || !this.activePartId.equals(newActivePartId)) {
                        this.activeWorkbenchSite = newActiveWorkbenchSite;
                        this.activePartId = newActivePartId;
                        update = true;
                    }
                } else if (this.activeWorkbenchSite != null || this.activePartId != null) {
                    this.activeWorkbenchSite = null;
                    this.activePartId = null;
                    update = true;
                }
            } else if (this.activeWorkbenchSite != null || this.activePartId != null) {
                this.activeWorkbenchSite = null;
                this.activePartId = null;
                update = true;
            }
        } else if (this.activeWorkbenchSite != null || this.activePartId != null) {
            this.activeWorkbenchSite = null;
            this.activePartId = null;
            update = true;
        }
        if (force || update) {
            HashMap<String, IHandler> handlersByCommandId = new HashMap<String, IHandler>();
            WorkbenchContextSupport contextSupport = (WorkbenchContextSupport)this.workbench.getContextSupport();
            Map contextTree = contextSupport.createFilteredContextTreeFor(contextSupport.getContextManager().getEnabledContextIds());
            boolean dialogOpen = contextTree.containsKey("org.eclipse.ui.contexts.dialog");
            Iterator iterator = this.handlerSubmissionsByCommandId.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String commandId = (String)entry.getKey();
                List handlerSubmissions = (List)entry.getValue();
                Iterator submissionItr = handlerSubmissions.iterator();
                HandlerSubmission bestHandlerSubmission = null;
                boolean conflict = false;
                while (submissionItr.hasNext()) {
                    String partIdToMatch;
                    HandlerSubmission handlerSubmission = (HandlerSubmission)submissionItr.next();
                    IWorkbenchPartSite siteToMatch = handlerSubmission.getActiveWorkbenchPartSite();
                    if (siteToMatch != null && siteToMatch != newActiveWorkbenchSite || (partIdToMatch = handlerSubmission.getActivePartId()) != null && !partIdToMatch.equals(this.activePartId)) continue;
                    Shell shellToMatch = handlerSubmission.getActiveShell();
                    Shell wbWinShell = this.activeWorkbenchWindow == null ? null : this.activeWorkbenchWindow.getShell();
                    if (shellToMatch != null && shellToMatch != this.activeShell && (shellToMatch != wbWinShell || dialogOpen)) continue;
                    if (bestHandlerSubmission == null) {
                        bestHandlerSubmission = handlerSubmission;
                        continue;
                    }
                    int compareTo = Util.compareIdentity(siteToMatch, bestHandlerSubmission.getActiveWorkbenchPartSite());
                    int currentMatch = WorkbenchCommandSupport.compareWindows(shellToMatch, this.activeShell);
                    Shell bestMatchingShell = bestHandlerSubmission.getActiveShell();
                    int bestMatch = WorkbenchCommandSupport.compareWindows(bestMatchingShell, this.activeShell);
                    if (bestHandlerSubmission.getHandler() instanceof HandlerProxy && currentMatch <= 1 && dialogOpen) {
                        compareTo = -1;
                        if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                            System.out.println("HANDLERS >>> A handler contributed via XML will win over a less than exact match: " + bestHandlerSubmission.getHandler());
                        }
                    } else if (handlerSubmission.getHandler() instanceof HandlerProxy && bestMatch <= 1 && dialogOpen) {
                        compareTo = 1;
                        if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                            System.out.println("HANDLERS >>> A handler contributed via XML will win over a less than exact match: " + handlerSubmission.getHandler());
                        }
                    } else if ((currentMatch > bestMatch || compareTo == 0) && (compareTo = currentMatch - bestMatch) == 0) {
                        compareTo = Util.compare(handlerSubmission.getPriority(), bestHandlerSubmission.getPriority());
                    }
                    if (compareTo > 0) {
                        if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                            System.out.println("HANDLERS >>> Resolved conflict detected between ");
                            System.out.println("HANDLERS >>>     win: " + handlerSubmission);
                            System.out.println("HANDLERS >>>    lose: " + bestHandlerSubmission);
                        }
                        conflict = false;
                        bestHandlerSubmission = handlerSubmission;
                        continue;
                    }
                    if (compareTo == 0 && bestHandlerSubmission.getHandler() != handlerSubmission.getHandler()) {
                        if (DEBUG) {
                            System.out.println("HANDLERS >>> Unresolved conflict detected for " + commandId);
                        }
                        conflict = true;
                        continue;
                    }
                    if (!DEBUG_VERBOSE || DEBUG_VERBOSE_COMMAND_ID != null && !DEBUG_VERBOSE_COMMAND_ID.equals(commandId)) continue;
                    System.out.println("HANDLERS >>> Resolved conflict detected between ");
                    System.out.println("HANDLERS >>>     win: " + bestHandlerSubmission);
                    System.out.println("HANDLERS >>>    lose: " + handlerSubmission);
                }
                if (bestHandlerSubmission == null || conflict) continue;
                handlersByCommandId.put(commandId, bestHandlerSubmission.getHandler());
            }
            this.mutableCommandManager.setHandlersByCommandId(handlersByCommandId);
        }
    }

    public void removeHandlerSubmission(HandlerSubmission handlerSubmission) {
        this.removeHandlerSubmissionReal(handlerSubmission);
        this.processHandlerSubmissions(true);
    }

    private final void removeHandlerSubmissionReal(HandlerSubmission handlerSubmission) {
        String commandId = handlerSubmission.getCommandId();
        List handlerSubmissions2 = (List)this.handlerSubmissionsByCommandId.get(commandId);
        if (handlerSubmissions2 != null) {
            handlerSubmissions2.remove(handlerSubmission);
            if (handlerSubmissions2.isEmpty()) {
                this.handlerSubmissionsByCommandId.remove(commandId);
            }
        }
    }

    public void removeHandlerSubmissions(Collection handlerSubmissions) {
        Iterator submissionItr = handlerSubmissions.iterator();
        while (submissionItr.hasNext()) {
            this.removeHandlerSubmissionReal((HandlerSubmission)submissionItr.next());
        }
        this.processHandlerSubmissions(true);
    }

    public void setActiveContextIds(Map activeContextIds) {
        this.mutableCommandManager.setActiveContextIds(activeContextIds);
    }

    public final void setProcessing(boolean processing) {
        boolean reprocess = !this.processing && processing;
        this.processing = processing;
        if (reprocess) {
            this.processHandlerSubmissions(true);
        }
    }
}

