/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceContentProvider;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceGroup;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;

public class GroupedPreferenceContentProvider
extends FilteredPreferenceContentProvider {
    Collection groupedIds;
    WorkbenchPreferenceGroup currentInput;
    boolean groupedMode;

    public GroupedPreferenceContentProvider(boolean grouped) {
        this.groupedMode = grouped;
        this.groupedIds = new HashSet();
        WorkbenchPreferenceManager manager = (WorkbenchPreferenceManager)WorkbenchPlugin.getDefault().getPreferenceManager();
        WorkbenchPreferenceGroup[] groups = manager.groups;
        this.setManager(manager);
        int i = 0;
        while (i < groups.length) {
            WorkbenchPreferenceGroup group = groups[i];
            this.groupedIds.addAll(group.getPageIds());
            ++i;
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.groupedMode) {
            return ((WorkbenchPreferenceGroup)inputElement).getPreferenceNodes();
        }
        return super.getElements(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean bl = this.groupedMode = newInput != null && newInput instanceof WorkbenchPreferenceGroup;
        if (this.groupedMode) {
            this.currentInput = (WorkbenchPreferenceGroup)newInput;
        } else {
            super.inputChanged(viewer, oldInput, newInput);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = super.getChildren(parentElement);
        if (!this.groupedMode) {
            return children;
        }
        ArrayList<Object> returnValue = new ArrayList<Object>();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof WorkbenchPreferenceNode) {
                WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)children[i];
                if (!this.groupedIds.contains(node.getId())) {
                    returnValue.add(node);
                }
            } else {
                returnValue.add(children[i]);
            }
            ++i;
        }
        return returnValue.toArray();
    }
}

