/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class LinkArea
extends Canvas
implements Listener {
    private IRunnableContext runnable;
    private String text;
    static final int MARGINWIDTH = 1;
    static final int MARGINHEIGHT = 1;
    boolean hasFocus;
    boolean mouseOver;
    private Cursor handCursor = new Cursor((Device)this.getDisplay(), 21);
    private Cursor normalCursor = new Cursor((Device)this.getDisplay(), 0);
    boolean linkEnabled;
    boolean foundImage;

    public LinkArea(Composite parent, int style) {
        super(parent, 0);
        this.addListener(9, this);
        this.addListener(6, this);
        this.addListener(7, this);
        this.addListener(3, this);
        this.addListener(4, this);
        this.addListener(15, this);
        this.addListener(16, this);
        this.redraw();
    }

    public void handleEvent(Event e) {
        switch (e.type) {
            case 9: {
                this.paint(e.gc);
                break;
            }
            case 15: {
                this.hasFocus = true;
            }
            case 6: {
                this.mouseOver = true;
                this.redraw();
                break;
            }
            case 16: {
                this.hasFocus = false;
            }
            case 7: {
                this.mouseOver = false;
                this.redraw();
                break;
            }
            case 3: {
                this.runRunnable();
                break;
            }
            case 4: {
                Point size = this.getSize();
                if (e.button != 1 || e.x < 0 || e.y < 0 || e.x >= size.x || e.y >= size.y) {
                    return;
                }
                this.redraw();
            }
        }
    }

    private void setLinkEnable(boolean enable) {
        if (enable != this.linkEnabled) {
            this.linkEnabled = enable;
            this.setCursor(this.handCursor);
            this.redraw();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= 2;
        }
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        Point extent = gc.textExtent(this.text);
        gc.dispose();
        return new Point(extent.x + 2, extent.y + 2);
    }

    private Color getFGColor() {
        if (this.mouseOver) {
            return JFaceColors.getActiveHyperlinkText((Display)this.getDisplay());
        }
        return JFaceColors.getHyperlinkText((Display)this.getDisplay());
    }

    protected void paint(GC gc) {
        Rectangle clientArea = this.getClientArea();
        if (clientArea.isEmpty()) {
            return;
        }
        Color fg = this.getFGColor();
        GC bufferGC = gc;
        bufferGC.setForeground(fg);
        bufferGC.fillRectangle(0, 0, clientArea.width, clientArea.height);
        bufferGC.setFont(this.getFont());
        bufferGC.drawText(this.text, 1, 1, true);
        int sw = bufferGC.stringExtent((String)this.text).x;
        FontMetrics fm = bufferGC.getFontMetrics();
        int lineY = clientArea.height - 1 - fm.getDescent() + 1;
        bufferGC.drawLine(1, lineY, 1 + sw, lineY);
        if (this.hasFocus) {
            bufferGC.drawFocus(0, 0, sw, clientArea.height);
        }
    }

    public void dispose() {
        super.dispose();
        this.handCursor.dispose();
        this.normalCursor.dispose();
    }

    private void runRunnable() {
        try {
            this.runnable.run(false, false, null);
        }
        catch (InvocationTargetException exception) {
            WorkbenchPlugin.log("Error in hyperlink", exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setRunnable(IRunnableContext runnable) {
        this.runnable = runnable;
    }

    public void setText(String text) {
        this.text = text;
    }
}

