/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesContentProvider
implements ITreeContentProvider {
    private static Set scopes = new HashSet();

    static {
        scopes.add("instance");
        scopes.add("configuration");
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object parent) {
        Object[] children = this.getChildren(parent);
        Object[] preferences = new IEclipsePreferences[children.length];
        System.arraycopy(children, 0, preferences, 0, children.length);
        return preferences;
    }

    public void dispose() {
    }

    public Object getParent(Object child) {
        if (child instanceof IEclipsePreferences) {
            return ((IEclipsePreferences)child).parent();
        }
        return null;
    }

    private boolean hasKeys(Preferences node) throws BackingStoreException {
        if (node.keys().length > 0) {
            return true;
        }
        String[] children = node.childrenNames();
        int i = 0;
        while (i < children.length) {
            String child = children[i];
            if (this.hasKeys(node.node(child))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] getChildren(Object parent) {
        ArrayList<Preferences> result = new ArrayList<Preferences>();
        if (parent instanceof IEclipsePreferences) {
            IEclipsePreferences node = (IEclipsePreferences)parent;
            try {
                if (node.parent() == null) {
                    String[] childrenNames = node.childrenNames();
                    int i = 0;
                    while (childrenNames != null && i < childrenNames.length) {
                        Preferences preferences;
                        String child = childrenNames[i];
                        if (scopes.contains(child) && this.hasKeys(preferences = node.node(child))) {
                            result.add(preferences);
                        }
                        ++i;
                    }
                } else if (node.parent().parent() == null) {
                    String[] childrenNames = node.childrenNames();
                    int i = 0;
                    while (childrenNames != null && i < childrenNames.length) {
                        String child = childrenNames[i];
                        Preferences preferences = node.node(child);
                        if (this.hasKeys(preferences)) {
                            result.add(preferences);
                        }
                        ++i;
                    }
                }
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return result.toArray(new Object[result.size()]);
    }

    public boolean hasChildren(Object parent) {
        IEclipsePreferences node = (IEclipsePreferences)parent;
        try {
            if (node.parent() == null && this.hasKeys((Preferences)node)) {
                return true;
            }
            if (node.parent().parent() == null && this.hasKeys((Preferences)node)) {
                return true;
            }
        }
        catch (BackingStoreException backingStoreException) {}
        return false;
    }
}

