/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PreferenceImportExportFileSelectionPage;
import org.eclipse.ui.internal.dialogs.PreferencesContentProvider;

public class PreferencesExportDialog
extends Dialog {
    CheckboxTreeViewer viewer;
    Combo outputLocationCombo;
    private static final int MIN_DIALOG_WIDTH = 350;
    private static final int MIN_DIALOG_HEIGHT = 150;
    private static String EXPORT_LOCATION_KEY = "PREFERENCES_EXPORT_LOCATION";

    public PreferencesExportDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(WorkbenchMessages.getString("PreferencesExportDialog.SelectMessage"));
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Control outerArea = super.createDialogArea(parent);
        this.createOutputSelectionArea((Composite)outerArea);
        Label title = new Label((Composite)outerArea, 0);
        title.setText(WorkbenchMessages.getString("PreferencesExportDialog.PreferencesListLabel"));
        this.viewer = new CheckboxTreeViewer((Composite)outerArea);
        final PreferencesContentProvider contentProvider = new PreferencesContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object obj) {
                IEclipsePreferences node = (IEclipsePreferences)obj;
                if (node.parent().parent() == null) {
                    if (node.name().equals("instance")) {
                        return WorkbenchMessages.getString("PreferencesExportDialog.WorkspaceScope");
                    }
                    if (node.name().equals("configuration")) {
                        return WorkbenchMessages.getString("PreferencesExportDialog.ConfigurationScope");
                    }
                    return node.name();
                }
                String result = node.name();
                Plugin plugin = Platform.getPlugin((String)result);
                if (plugin != null) {
                    return WorkbenchMessages.format("PreferencesExportDialog.PluginLabel", new String[]{plugin.getDescriptor().getLabel(), node.name()});
                }
                return node.name();
            }

            public Image getImage(Object obj) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
        });
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean state = event.getChecked();
                Object parentElement = contentProvider.getParent(element);
                if (parentElement != null) {
                    this.determineCheckedState(parentElement, state);
                }
                Object[] children = contentProvider.getChildren(element);
                int i = 0;
                while (i < children.length) {
                    PreferencesExportDialog.this.viewer.setChecked(children[i], state);
                    ++i;
                }
            }

            private void determineCheckedState(Object parentElement, boolean childState) {
                Object[] children = contentProvider.getChildren(parentElement);
                if (childState) {
                    if (this.checkState(children, false)) {
                        PreferencesExportDialog.this.viewer.setGrayChecked(parentElement, false);
                        PreferencesExportDialog.this.viewer.setChecked(parentElement, true);
                        return;
                    }
                } else if (this.checkState(children, true)) {
                    PreferencesExportDialog.this.viewer.setGrayChecked(parentElement, false);
                    PreferencesExportDialog.this.viewer.setChecked(parentElement, false);
                    return;
                }
                PreferencesExportDialog.this.viewer.setGrayChecked(parentElement, true);
            }

            private boolean checkState(Object[] children, boolean failState) {
                int i = 0;
                while (i < children.length) {
                    Object object = children[i];
                    if (PreferencesExportDialog.this.viewer.getChecked(object) == failState) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        this.viewer.setInput((Object)Platform.getPreferencesService().getRootNode());
        GridData data = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)data);
        return outerArea;
    }

    private void createOutputSelectionArea(Composite outerArea) {
        Composite outputArea = new Composite(outerArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        outputArea.setLayout((Layout)layout);
        GridData data = new GridData(768);
        outputArea.setLayoutData((Object)data);
        Label titleLabel = new Label(outputArea, 0);
        titleLabel.setText(WorkbenchMessages.getString("ExportWizard.selectDestination"));
        IDialogSettings settings = WorkbenchPlugin.getDefault().getDialogSettings();
        String[] locations = settings.getArray(EXPORT_LOCATION_KEY);
        this.outputLocationCombo = new Combo(outputArea, 0);
        if (locations != null) {
            this.outputLocationCombo.setItems(locations);
            this.outputLocationCombo.select(0);
        }
        this.outputLocationCombo.setLayoutData((Object)new GridData(768));
        this.outputLocationCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                PreferencesExportDialog.this.enableOKButton(PreferencesExportDialog.this.outputLocationCombo.getText().length() > 0);
            }
        });
        Button destinationBrowseButton = new Button(outputArea, 8);
        destinationBrowseButton.setText(WorkbenchMessages.getString("EditorSelection.browse"));
        destinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PreferencesExportDialog.this.getShell(), 8192);
                dialog.setText(WorkbenchMessages.getString("PreferencesExportDialog.ExportDialogTitle"));
                dialog.setFilterExtensions(PreferenceImportExportFileSelectionPage.DIALOG_PREFERENCE_EXTENSIONS);
                String selectedDirectoryName = dialog.open();
                if (selectedDirectoryName != null) {
                    PreferencesExportDialog.this.outputLocationCombo.setText(selectedDirectoryName);
                    PreferencesExportDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.setButtonLayoutData(destinationBrowseButton);
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(437), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(225), shellSize.y));
    }

    protected void okPressed() {
        Object[] selections = this.viewer.getCheckedElements();
        ArrayList<Object> blackChecked = new ArrayList<Object>();
        int i = 0;
        while (i < selections.length) {
            if (!this.viewer.getGrayed(selections[i])) {
                blackChecked.add(selections[i]);
            }
            ++i;
        }
        IEclipsePreferences[] preferences = new IEclipsePreferences[blackChecked.size()];
        blackChecked.toArray(preferences);
        String outputPath = this.getOutputFileName();
        this.exportPreferences((IPath)new Path(outputPath), preferences);
        String[] items = this.outputLocationCombo.getItems();
        boolean needToAddOutput = true;
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2].equals(outputPath)) {
                needToAddOutput = false;
                break;
            }
            ++i2;
        }
        if (needToAddOutput) {
            String[] newValues = new String[items.length + 1];
            newValues[0] = outputPath;
            System.arraycopy(items, 0, newValues, 1, items.length);
            items = newValues;
        }
        WorkbenchPlugin.getDefault().getDialogSettings().put(EXPORT_LOCATION_KEY, items);
        super.okPressed();
    }

    private String getOutputFileName() {
        String fileName = new File(this.outputLocationCombo.getText()).getPath();
        if (fileName.lastIndexOf(".") == -1) {
            fileName = String.valueOf(fileName) + ".epf";
        }
        return fileName;
    }

    /*
     * Exception decompiling
     */
    private void exportPreferences(IPath path, IEclipsePreferences[] preferences) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 169->173)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void openErrorDialog(IStatus status) {
        ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("PreferencesExportDialog.ErrorDialogTitle"), (String)WorkbenchMessages.getString("PreferencesExportDialog.ErrorDialogMessage"), (IStatus)status);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableOKButton(this.outputLocationCombo.getSelectionIndex() > -1);
    }

    private void enableOKButton(boolean state) {
        this.getButton(0).setEnabled(state);
    }
}

