/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceGroup;

public class WorkbenchPreferenceManager
extends PreferenceManager {
    WorkbenchPreferenceGroup[] groups;
    private static final String GENERAL_ID = "org.eclipse.ui.general";
    private static final String ADVANCED_ID = "org.eclipse.ui.advanced";

    public WorkbenchPreferenceManager(char separatorChar) {
        super(separatorChar);
    }

    private Hashtable getNodeMappings() {
        Hashtable returnValue = new Hashtable();
        int i = 0;
        while (i < this.groups.length) {
            this.addIds(this.groups[i], returnValue);
            ++i;
        }
        return returnValue;
    }

    private void addIds(WorkbenchPreferenceGroup group, Hashtable returnValue) {
        Iterator pageIds = group.getPageIds().iterator();
        while (pageIds.hasNext()) {
            returnValue.put(pageIds.next(), group);
        }
    }

    private void sortGroups(Collection collectedGroups) {
        this.groups = new WorkbenchPreferenceGroup[collectedGroups.size()];
        collectedGroups.toArray(this.groups);
        Arrays.sort(this.groups, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                WorkbenchPreferenceGroup first = (WorkbenchPreferenceGroup)arg0;
                WorkbenchPreferenceGroup second = (WorkbenchPreferenceGroup)arg1;
                if (first.getId().equals(WorkbenchPreferenceManager.GENERAL_ID) || second.getId().equals(WorkbenchPreferenceManager.ADVANCED_ID)) {
                    return -1;
                }
                if (first.getId().equals(WorkbenchPreferenceManager.ADVANCED_ID) || second.getId().equals(WorkbenchPreferenceManager.GENERAL_ID)) {
                    return 1;
                }
                return first.getId().compareTo(second.getId());
            }
        });
    }

    public WorkbenchPreferenceGroup[] getGroups() {
        return this.groups;
    }

    public void addPagesAndGroups(Collection pageContributions, Collection newGroups) {
        ArrayList collectedCategories = new ArrayList();
        Iterator iterator = pageContributions.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof IPreferenceNode) {
                this.addToRoot((IPreferenceNode)next);
                continue;
            }
            collectedCategories.add(next);
        }
        this.sortGroups(newGroups);
    }
}

