/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.NewProgressViewer;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.SubTaskInfo;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;

class FinishedJobs {
    private static FinishedJobs theInstance;
    private static ListenerList listeners;
    private IJobProgressManagerListener listener;
    private HashSet keptjobinfos = new HashSet();
    private HashMap finishedTime = new HashMap();

    static {
        listeners = new ListenerList();
    }

    static synchronized FinishedJobs getInstance() {
        if (theInstance == null) {
            theInstance = new FinishedJobs();
        }
        return theInstance;
    }

    private FinishedJobs() {
        this.listener = new IJobProgressManagerListener(){

            public void addJob(JobInfo info) {
                FinishedJobs.this.checkForDuplicates(info);
            }

            public void addGroup(GroupInfo info) {
                FinishedJobs.this.checkForDuplicates(info);
            }

            public void refreshJobInfo(JobInfo info) {
                FinishedJobs.this.checkTasks(info);
            }

            public void refreshGroup(GroupInfo info) {
            }

            public void refreshAll() {
            }

            public void removeJob(JobInfo info) {
                if (FinishedJobs.keep(info)) {
                    FinishedJobs.this.checkForDuplicates(info);
                    FinishedJobs.this.add(info);
                }
            }

            public void removeGroup(GroupInfo group) {
            }

            public boolean showsDebug() {
                return false;
            }
        };
        ProgressManager.getInstance().addListener(this.listener);
    }

    static boolean keep(JobInfo info) {
        Job job = info.getJob();
        if (job != null) {
            Object prop = job.getProperty(NewProgressViewer.KEEP_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            prop = job.getProperty(NewProgressViewer.KEEPONE_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            IStatus status = job.getResult();
            if (status != null && status.getSeverity() == 4) {
                return true;
            }
        }
        return false;
    }

    void addListener(KeptJobsListener l) {
        listeners.add((Object)l);
    }

    void removeListener(KeptJobsListener l) {
        listeners.remove((Object)l);
    }

    private void checkForDuplicates(GroupInfo info) {
        Object[] objects = info.getChildren();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof JobInfo) {
                this.checkForDuplicates((JobInfo)objects[i]);
            }
            ++i;
        }
    }

    private void checkForDuplicates(JobTreeElement info) {
        JobTreeElement[] toBeRemoved = this.findJobsToRemove(info);
        if (toBeRemoved != null) {
            int i = 0;
            while (i < toBeRemoved.length) {
                this.remove(toBeRemoved[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(JobInfo info) {
        boolean fire = false;
        HashSet hashSet = this.keptjobinfos;
        synchronized (hashSet) {
            if (!this.keptjobinfos.contains(info)) {
                this.keptjobinfos.add(info);
                long now = System.currentTimeMillis();
                this.finishedTime.put(info, new Long(now));
                Object parent = info.getParent();
                if (parent != null && !this.keptjobinfos.contains(parent)) {
                    this.keptjobinfos.add(parent);
                    this.finishedTime.put(parent, new Long(now));
                }
                fire = true;
            }
        }
        if (fire) {
            Object[] l = listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                KeptJobsListener jv = (KeptJobsListener)l[i];
                jv.finished(info);
                ++i;
            }
        }
    }

    static void disposeAction(JobTreeElement jte) {
        Object prop;
        JobInfo ji;
        Job job;
        if (jte.isJobInfo() && (job = (ji = (JobInfo)jte).getJob()) != null && (prop = job.getProperty(IProgressConstants.ACTION_PROPERTY)) instanceof ActionFactory.IWorkbenchAction) {
            ((ActionFactory.IWorkbenchAction)prop).dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobTreeElement[] findJobsToRemove(JobTreeElement info) {
        if (info.isJobInfo()) {
            Object prop;
            JobInfo parent;
            Job myJob = null;
            if (info instanceof JobInfo) {
                myJob = ((JobInfo)info).getJob();
            } else if (info instanceof SubTaskInfo && (parent = (JobInfo)((SubTaskInfo)info).getParent()) != null) {
                myJob = parent.getJob();
            }
            if (myJob != null && (prop = myJob.getProperty(NewProgressViewer.KEEPONE_PROPERTY)) instanceof Boolean && ((Boolean)prop).booleanValue()) {
                JobTreeElement[] all;
                ArrayList<Object> found = null;
                Object myRoot = FinishedJobs.getRoot(info);
                HashSet hashSet = this.keptjobinfos;
                synchronized (hashSet) {
                    all = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
                }
                int i = 0;
                while (i < all.length) {
                    JobInfo ji;
                    Job job;
                    JobTreeElement jte = all[i];
                    Object otherRoot = FinishedJobs.getRoot(jte);
                    if (otherRoot != myRoot && jte.isJobInfo() && (job = (ji = (JobInfo)jte).getJob()) != null && job != myJob && job.belongsTo((Object)myJob)) {
                        if (found == null) {
                            found = new ArrayList<Object>();
                        }
                        found.add(otherRoot);
                    }
                    ++i;
                }
                if (found != null) {
                    return found.toArray(new JobTreeElement[found.size()]);
                }
            }
        }
        return null;
    }

    private static Object getRoot(JobTreeElement jte) {
        Object parent;
        while ((parent = jte.getParent()) != null) {
            jte = (JobTreeElement)parent;
        }
        return jte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTasks(JobInfo info) {
        TaskInfo tinfo;
        if (FinishedJobs.keep(info) && (tinfo = info.getTaskInfo()) != null) {
            JobTreeElement[] toBeRemoved = null;
            boolean fire = false;
            JobTreeElement element = (JobTreeElement)tinfo.getParent();
            HashSet hashSet = this.keptjobinfos;
            synchronized (hashSet) {
                if (element == info && !this.keptjobinfos.contains(tinfo)) {
                    toBeRemoved = this.findJobsToRemove(element);
                    this.keptjobinfos.add(tinfo);
                    this.finishedTime.put(tinfo, new Long(System.currentTimeMillis()));
                }
            }
            if (toBeRemoved != null) {
                int i = 0;
                while (i < toBeRemoved.length) {
                    this.remove(toBeRemoved[i]);
                    ++i;
                }
            }
            if (fire) {
                Object[] l = listeners.getListeners();
                int i = 0;
                while (i < l.length) {
                    KeptJobsListener jv = (KeptJobsListener)l[i];
                    jv.finished(info);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(JobTreeElement jte) {
        boolean fire = false;
        boolean removed = false;
        HashSet hashSet = this.keptjobinfos;
        synchronized (hashSet) {
            if (this.keptjobinfos.remove(jte)) {
                removed = true;
                this.finishedTime.remove(jte);
                FinishedJobs.disposeAction(jte);
                JobTreeElement[] jtes = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
                int i = 0;
                while (i < jtes.length) {
                    JobTreeElement parent = (JobTreeElement)jtes[i].getParent();
                    if (parent != null && (parent == jte || parent.getParent() == jte)) {
                        if (this.keptjobinfos.remove(jtes[i])) {
                            FinishedJobs.disposeAction(jtes[i]);
                        }
                        this.finishedTime.remove(jtes[i]);
                    }
                    ++i;
                }
                fire = true;
            }
        }
        if (fire) {
            Object[] l = listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                KeptJobsListener jv = (KeptJobsListener)l[i];
                jv.removed(jte);
                ++i;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobTreeElement[] getJobInfos() {
        JobTreeElement[] all;
        HashSet hashSet = this.keptjobinfos;
        synchronized (hashSet) {
            all = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
        }
        Arrays.sort(all, new Comparator(){

            public int compare(Object o1, Object o2) {
                long t2;
                long t1 = FinishedJobs.this.getFinishedDateAsLong((JobTreeElement)o1);
                if (t1 < (t2 = FinishedJobs.this.getFinishedDateAsLong((JobTreeElement)o2))) {
                    return -1;
                }
                if (t1 > t2) {
                    return 1;
                }
                return 0;
            }
        });
        return all;
    }

    private long getFinishedDateAsLong(JobTreeElement jte) {
        Object o = this.finishedTime.get(jte);
        if (o instanceof Long) {
            return (Long)o;
        }
        return 0L;
    }

    public Date getFinishDate(JobTreeElement jte) {
        Object o = this.finishedTime.get(jte);
        if (o instanceof Long) {
            return new Date((Long)o);
        }
        return null;
    }

    public boolean isFinished(JobTreeElement element) {
        return this.keptjobinfos.contains(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        HashSet hashSet = this.keptjobinfos;
        synchronized (hashSet) {
            JobTreeElement[] all = this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
            int i = 0;
            while (i < all.length) {
                FinishedJobs.disposeAction(all[i]);
                ++i;
            }
            this.keptjobinfos.clear();
            this.finishedTime.clear();
        }
        Object[] l = listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            KeptJobsListener jv = (KeptJobsListener)l[i];
            jv.removed(null);
            ++i;
        }
    }

    static interface KeptJobsListener {
        public void finished(JobTreeElement var1);

        public void removed(JobTreeElement var1);
    }
}

