/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class EditorRegistryReader
extends RegistryReader {
    public static final String TAG_EDITOR = "editor";
    public static final String P_TRUE = "true";
    private EditorRegistry editorRegistry;

    protected void addEditors(boolean readAll, EditorRegistry registry) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.editorRegistry = registry;
        this.readRegistry(extensionRegistry, "org.eclipse.ui", "editors");
    }

    protected boolean readElement(IConfigurationElement element) {
        String def;
        String filenamesString;
        if (!element.getName().equals(TAG_EDITOR)) {
            return false;
        }
        String id = element.getAttribute("id");
        if (element.getAttribute("id") == null) {
            RegistryReader.logMissingAttribute(element, "id");
            return true;
        }
        EditorDescriptor editor = new EditorDescriptor(id, element);
        ArrayList<String> extensionsVector = new ArrayList<String>();
        ArrayList<String> filenamesVector = new ArrayList<String>();
        boolean defaultEditor = false;
        if (element.getAttribute("name") == null) {
            RegistryReader.logMissingAttribute(element, "name");
            return true;
        }
        if (element.getAttribute("icon") == null && element.getAttribute("class") != null) {
            RegistryReader.logMissingAttribute(element, "icon");
            return true;
        }
        String extensionsString = element.getAttribute("extensions");
        if (extensionsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionsString, ",");
            while (tokenizer.hasMoreTokens()) {
                extensionsVector.add(tokenizer.nextToken().trim());
            }
        }
        if ((filenamesString = element.getAttribute("filenames")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(filenamesString, ",");
            while (tokenizer.hasMoreTokens()) {
                filenamesVector.add(tokenizer.nextToken().trim());
            }
        }
        if ((def = element.getAttribute("default")) != null) {
            defaultEditor = Boolean.valueOf(def);
        }
        this.editorRegistry.addEditorFromPlugin(editor, extensionsVector, filenamesVector, defaultEditor);
        return true;
    }

    public void readElement(EditorRegistry editorRegistry, IConfigurationElement element) {
        this.editorRegistry = editorRegistry;
        this.readElement(element);
    }
}

